define(function(require) {
    var Config = require('config');
    var Core = require('core/core');
    var Page = require('core/page');

    
    var HousetoAdd = require('./houseto.add');
    var HousetoEdit = require('./houseto.edit');
    var HousetoView = require('./houseto.view');
    var HousetoRemove = require('./houseto.remove');

    // 业务信息
    var Houseto = Page.extend(function() {
    	
    	this.injecte([
          new HousetoAdd('houseto_add'),
          new HousetoEdit('houseto_edit'),
          new HousetoView('houseto_view'),
          new HousetoRemove('houseto_remove')
    	]);
    	
    	// @override
    	this.load = function(panel) {
    		var table = this.table = panel.find('table');
    		
    		table.cdatagrid({
    			controller: this
    		});
    	};
    	
    });

    return Houseto;
});