<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<div class="easyui-layout" fit="true" id="housemoney-info-main">
    <div region="north" border="false" style="height: 60px; padding: 4px;">
        <div class="easyui-panel search-body" cls="search" style="width: 100%; margin-bottom: 0;">
            <form class="clearFromValue" >
                <input type="hidden" name="hm_usertype" id="hm_usertype"/>
                <div class="search-item">
                    <label>年份</label>
                    <input type="text" class="easyui-combobox" name="year"
                           url="service/common/getYearList/10" method="get"
                           data-options="valueField:'year',textField:'year'" id="tableListYear" style="width: 80px"/>
                </div>
                <div class="search-item">
                    <label>行政区划</label>
                    <!--江苏省-->
                    <div style="display: none">
                        <input type="text" class="easyui-combobox" name="first"  data-options="valueField: 'value',textField: 'label', data: [{label: '江苏省',value: '320000000000'}]"
                               method="get" prompt="省" value="320000000000" validType="true" />
                    </div>
                    &nbsp;
                    <input type="text" class="easyui-combobox" data-options="valueField:'unitCode',textField:'unitName'" name="city" id="user_second" method="get" prompt="市"/>
                    &nbsp;
                    <input type="text" class="easyui-combobox" data-options="valueField:'unitCode',textField:'unitName'" name="county" id="user_third" method="get" prompt="县区"/>
                    &nbsp;

                </div>

                <button  type="button"class="easyui-linkbutton btn-search" iconCls="icon-search" id="housemoneySearch">搜索</button>
                <a class="warnSelf">说明：19年统计数据包括了18年的数据。</a>
                <%--<a class="easyui-linkbutton btn-search" iconCls="icon-search"><p id="e@btn.search">搜索</p></a>--%>
            </form>
        </div>
    </div>


    <div data-options="region:'center'" border="false" style="padding: 4px;">
        <table style="width:100%; height:90%" rownumbers="false" id="hmtableList" idField="id"
               search=".search" layoutH=".search" toolbar=".temp-toolbar"  pagination="false"
               fitColumns="true"  fit="true" >

            <thead>
            <tr>
                <th data-options="field:'status',align:'center'" rowspan="2" width="12%"  format="Dictionary:FUNDSUMSTATUS" >状态</th>
              <%--  <th data-options="field:'city',align:'center'" rowspan="2" width="10%">设区市</th>--%>
                <th data-options="field:'sjbm',align:'center'" rowspan="2" width="12%">县（市、区）</th>
                <th data-options="field:'housesum',align:'center',formatter:sumformat" rowspan="2" width="15%">改善户数合计<br/>合计</th>
                <th data-options="field:'moneysum',align:'center',formatter:sumformat" rowspan="2" width="15%">补助资金<br/>合计（万元）</th>
                <th colspan="2" >修缮加固（0.8万元/户）</th>
                <th colspan="2" >拆除新建（2.2万元/户）</th>

            </tr>
            <tr>
                <th data-options="field:'house6',align:'center',formatter:ccformat" width="11%">改善户数</th>
                <th data-options="field:'money6',align:'center',formatter:ccformat" width="12%">补助金额（万元）</th>
                <th data-options="field:'house4',align:'center',formatter:xgformat" width="11%">改善户数</th>
                <th data-options="field:'money4',align:'center',formatter:xgformat" width="12%">补助金额（万元）</th>
            </tr>
            </thead>
        </table>
        <div class="temp-toolbar">
            <a iconCls="icon-edit" trigger="single"
               target="confirm" rel="housemoney_tj"  id="housemoney_tj_btn" title="是否确定提交 {{text}}？">提交</a>
            <hr>


            <a iconCls="icon-base icon-sl" trigger="single"
               target="confirm" rel="housemoney_sl" id="housemoney_sl_btn" title="是否确定受理 {{text}}？">受理</a>
            <hr>
          <%--  <a iconCls="icon-base icon-th" trigger="single"
               target="confirm" rel="housemoney_th" id="housemoney_th_btn"  title="是否确定退回 {{text}}？">退回</a>--%>

            <a iconCls="icon-edit" href="modules/sjcj/housemoneytj/housemoneytj-th.jsp" trigger="single" id="housemoney_th_btn"
               target="dialog" rel="housemoney_th" title="退回 {{text}}" width="500" height="400"  buttons="[{method:'submit',text:'退回'}]" >退回</a>
            <hr>
            <a iconCls="icon-edit" href="modules/sjcj/housemoneytj/housemoneytj-view.jsp" trigger="single"
               target="dialog" rel="housemoneytj_view" title="查看  " width="1000" height="600" btnValue="查看">查看</a>
            <hr>
            <a iconCls="icon-redo" trigger="none" target="custom" rel="housemoney_exp" id="housemoney_exp_btn">导出</a>
    </div>
</div>
<script>

    $.parser.onComplete = function (panel) {
        $.parser.onComplete = $.noop;
        requirejs([
            'core/filter/filter.dictionary',
            'modules/sjcj/housemoneytj/ctrl/housemoneytj','css!plugins/viewer/viewer.min.css'
        ], function (FilterDictionary,Housemoneytj) {
            FilterDictionary.add(['FUNDSUMSTATUS','isBetter','BetterType']).then(function () {
                window.Housemoneytj = new Housemoneytj('housemoneytj', panel);
                window.Housemoneytj.load(panel);
            })
        });
    };

</script>