define(function(require) {
    var Config = require('config');
    var Core = require('core/core');
    var Page = require('core/page');
    var Dialog = require('centit/centit.dialog');

    var HousemoneyTj = require('./housemoneytj.tj');
    var HousemoneyTy = require('./housemoneytj.ty');
    var housemoneytjTh = require('./housemoneytj.th');
    var HousemoneyExp = require('./housemoneytj.exp');
    var HousemoneyView = require('./housemoneytj.view');

    var _self;
    var Housemoneytj = Page.extend(function() {

        this.injecte([
            new HousemoneyTj('housemoney_tj'),
            new housemoneytjTh('housemoney_th'),
            new HousemoneyTy('housemoney_sl'),
            new HousemoneyExp('housemoney_exp'),
            new HousemoneyView('housemoneytj_view'),
        ]);



        this.load = function(panel) {
            _self = this;
            var table = _self.table = panel.find('#hmtableList');

            var url = 'service/sjcj/farmhousejbxx/housemoney';
            table.cdatagrid({
                controller: this,
                url: url,
               /* onLoadSuccess: function (data) {
                    mergeCellsByField("hmtableList", "city");
                }*/
            });

            //行政区划初始化
            panel.find('#user_second').combobox({
                url: Config.ContextPath + "service/userinfo2/getUnitsByLoginAndUnitCode/2/320000000000",
                valueField: 'unitCode',
                textField: 'unitName',
                onLoadSuccess: function (list) {
                    if(list != null && list.length == 1){
                        $('#user_second').combobox('select', list[0]["unitCode"]);
                        $("#user_second").combobox('readonly', true);
                        panel.find('#user_third').combobox({
                            url: Config.ContextPath + "service/userinfo2/getUnitsByLoginAndUnitCode/3/"+list[0]["unitCode"] ,
                            valueField: 'unitCode',
                            textField: 'unitName',
                            onLoadSuccess: function (list2) {
                                if(list2 != null && list2.length == 1){
                                    $('#user_third').combobox('select', list2[0]["unitCode"]);
                                    $("#user_third").combobox('readonly', true);
                                    panel.find('#user_fourth').combobox({
                                        url: Config.ContextPath + "service/userinfo2/getUnitsByLoginAndUnitCode/4/"+list2[0]["unitCode"] ,
                                        valueField: 'unitCode',
                                        textField: 'unitName',
                                        onLoadSuccess: function (list3) {
                                            if(list3 != null && list3.length == 1){
                                                $('#user_fourth').combobox('select', list3[0]["unitCode"]);
                                            }
                                        }
                                    });
                                }
                            }
                        });
                    }
                }
            });

            //行政区划联动
            panel.find('#user_second').combobox({
                onChange: function(newValue,oldValue) {
                    panel.find('#user_third').combobox('clear');
                    // 重新获取数据
                    if(newValue != null){
                        panel.find('#user_third').combobox('reload', Config.ContextPath + "service/userinfo2/getUnitsByLoginAndUnitCode/3/"+newValue);
                    }
                }
            });




            //根据权限设置操作按钮
            Core.ajax(Config.ContextPath+'service/common/getLoginUserRoles', {
                method: 'get'
            }).then(function(rlt) {
                var isX = false;//县区
                var isPs = false;//省
                var isS = false;//市
                panel.find("#hm_usertype").val(rlt[1].roleCode);
                for(var i = 0 ; i < rlt.length ; i++){
                    if(rlt[i].roleCode == '0010'){
                        isPs = true;
                        break;
                    }
                    if(rlt[i].roleCode == '0011'){
                        isS = true;
                        break;
                    }
                    if(rlt[i].roleCode == '0012'){
                        isX = true;
                        break;
                    }
                }

                if(isX){

                    panel.find('#housemoney_th_btn, #housemoney_th_btn + hr', panel).remove();
                    panel.find('#housemoney_th_btn').parent('td').next().remove();
                    panel.find('#housemoney_sl_btn, #housemoney_sl_btn + hr', panel).remove();
                    panel.find('#housemoney_sl_btn').parent('td').next().remove();
                }
                if(isPs){
                    panel.find('#housemoney_tj_btn, #housemoney_tj_btn + hr', panel).remove();
                    panel.find('#housemoney_tj_btn').parent('td').next().remove();

                }
                if(isS){
                    panel.find('#housemoney_sl_btn, #housemoney_sl_btn + hr', panel).remove();
                    panel.find('#housemoney_sl_btn').parent('td').next().remove();
                }

            });
        };



        function mergeCellsByField(tableID, colList) {
            var ColArray = colList.split(",");
            var tTable = $("#" + tableID);
            var TableRowCnts = tTable.datagrid("getRows").length;
            var tmpA;
            var tmpB;
            var PerTxt = "";
            var CurTxt = "";
            var buyprocode = "";
            var newbuyprocode = "";
            var alertStr = "";
            for (j = ColArray.length - 1; j >= 0; j--) {
                PerTxt = "";
                buyprocode = "";
                tmpA = 1;
                tmpB = 0;

                for (i = 0; i <= TableRowCnts; i++) {
                    if (i == TableRowCnts) {
                        CurTxt = "";
                        newbuyprocode = "";
                    }
                    else {
                        CurTxt = tTable.datagrid("getRows")[i][ColArray[j]];
                        newbuyprocode = tTable.datagrid("getRows")[i]["buyprojectCode"];
                    }
                    if (PerTxt == CurTxt && buyprocode == newbuyprocode) {
                        tmpA += 1;
                    }
                    else {
                        tmpB += tmpA;

                        tTable.datagrid("mergeCells", {
                            index: i - tmpA,
                            field: ColArray[j],　　//合并字段
                            rowspan: tmpA,
                            colspan: null
                        });
                        tTable.datagrid("mergeCells", { //根据ColArray[j]进行合并
                            index: i - tmpA,
                            field: "Ideparture",
                            rowspan: tmpA,
                            colspan: null
                        });

                        tmpA = 1;
                    }
                    PerTxt = CurTxt;
                    buyprocode = newbuyprocode;
                }
            }
        }
    });

    this.sumformat = function (value,row) {

        var content = '';
        if (value != undefined && value != '0') {
            content = '<a  href="#" style="color:blue;" onclick="openSfxx(\'' + row.citycode + '\',\'' + row.countycode + '\',\'' + row.fyear +'\',null)" >' +value + '</a>';
        } else {
            content = '0';
        }
        return content;
    }
    this.xgformat = function (value,row) {
        row.type=4;
        var content = '';
        if (value != undefined && value != '0') {
            content = '<a   href="#" style="color:blue;" onclick="openSfxx(\'' + row.citycode + '\',\'' + row.countycode + '\',\'' + row.fyear +'\',\'4\')" >' +value + '</a>';
        } else {
            content = '0';
        }
        return content;
    }
    this.ccformat = function (value,row) {
        row.type=6;
        var content = '';
        if (value != undefined && value != '0') {
            content = '<a  href="#" style="color:blue;" onclick="openSfxx(\'' + row.citycode + '\',\'' + row.countycode + '\',\'' + row.fyear +'\',\'6\')" >' +value + '</a>';
        } else {
            content = '0';
        }
        return content;
    }
    this.openSfxx = function (citycode,countycode,fyear,type) {
        var objVal = new Object();
        objVal.citycode = citycode;
        objVal.countycode = countycode;
        objVal.fyear = fyear;
        objVal.type = type;
        objVal.persontype = "isNotNull";
        var SelectUser = require('modules/sjcj/housemoneytj/ctrl/housemoneyDeatil');
        var _SelectUser = new SelectUser("housemoneyDeatil");
        _self.controllers["housemoneyDeatil"] = _SelectUser;
        _SelectUser.parent = _self;
        var title = "改造户数和专项资金详情信息";
        var url = 'modules/sjcj/housemoneytj/housemoneyDetail.jsp';
        var buttons = [{method: 'onClose', text: '关闭'}];
        var dialogId = "_sfzcwxx";
        Dialog.open({
            id: dialogId,
            title: title,
            href: url,
            width: 1250,
            height: 600,
            buttons: buttons
        }, {objValue: objVal}, _self.controllers["housemoneyDeatil"]);

    }

    return Housemoneytj;
});

