<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<!-- 项目选择 -->
<div class="easyui-panel search-body" cls="search">
    <form>
        <div class="search-item">
            <label>年份</label>
            <input type="text" class="easyui-combobox" name="s_year"
                   url="service/common/getYearList/10" method="get"
                   data-options="valueField:'year',textField:'year'"/>
        </div>
        <div class="search-item">
            <label>四类人群</label>
            <input class="easyui-combobox" name="s_persontype" style="width: 180px"
                   target="dictionary"
                   key="PersonType"/>
        </div>
        <div class="search-item">
            <label>改善类型</label>
            <input class="easyui-combobox" name="s_bettertype" style="width: 200px"
                   target="dictionary"
                   key="BetterType"/>
        </div>
        <a class="easyui-linkbutton btn-search" iconCls="icon-search">查询</a>
    </form>
</div>
<table id="table_farms" idField="fid" checkbox="true"
       search=".search" sortName="updatetime" sortOrder="desc"
       toolbar=".temp-toolbar" layoutH=".search" treeField="text"
       singleSelect="true" checkOnSelect="true" selectOnCheck="true">
    <thead>
    <tr>
        <th data-options="field:'' , width:'5%'" checkbox="true"></th>
        <th data-options="field:'fid'" hidden>农房id</th>
        <th data-options="field:'vid'" hidden>村庄名称</th>
        <th data-options="field:'housingarea', width:'12%'">住房面积（㎡）</th>
        <th data-options="field:'housingaddress', width:'30%'">现居住地详址</th>
        <th data-options="field:'persontype', width:'12%'" format="Dictionary:PersonType">四类人群</th>
        <%--<th data-options="field:'tel'">联系电话</th>--%>
        <th data-options="field:'bettertype', width:'15%'" format="Dictionary:BetterType">改善类型</th>
        <th data-options="field:'bettertime', width:'10%'" format="Date:yyyy-MM-dd">计划改善时间</th>
        <th data-options="field:'housingstructure',  width:'15%'">房屋结构</th>
    <%--    <th data-options="field:'updatetime'" format="Date:yyyy-MM-dd">更新时间</th>--%>
    </tr>
    </thead>
</table>
