define(function(require) {
    var Config = require('config');
    var Page = require('core/page');
    var Core = require('core/core');
    var $ = require('jquery');
    var ajaxSubmit = require('plugins/jquery.form');


    var HouseholdregisterjbxxImp = Page.extend(function() {
        var _self = this;
        var _data;
        // @override
        this.load = function(panel, data) {
            _data = data;
            var form = panel.find('form');
            form.form('disableValidation');
            var fid = this.parent.panel.find("#hhd_s_fid").val();
            $("#householdregister_imp_btn").click(function() {
                var form = panel.find('form');

                form.form('enableValidation');
                var isValid = form.form('validate');

                if (isValid) {
                    $("#householdregister_imp_form").ajaxSubmit({
                        url: Config.ContextPath + 'service/sjcj/householdregisterjbxx/imp',
                        type: 'post',
                        data: {
                            "fid" : fid
                        },
                        error: function () {
                            $.messager.alert('警告', '导入失败！', 'warning');
                        },
                        success: function (rlt) {
                            if (rlt.code == 0) {
                                $("#succ_div").html(rlt.data.succCnt);

                                var failedHtml = '共' + rlt.data.failedArr.length + '条<br>';
                                $.each(rlt.data.failedArr, function (index, item) {
                                    failedHtml += ' 行号:' + item.rowNo;
                                    failedHtml += ' &nbsp;&nbsp;失败原因:【' + item.colName + '】';
                                    if (item.value != null && !item.value == '') {
                                        failedHtml += '("' + item.value + '") ';
                                    }
                                    failedHtml += item.errMsg;
                                    if (item.validValue != null && !item.validValue == '') {
                                        failedHtml += ' &nbsp;&nbsp;可选值 [' + item.validValue + ']';
                                    }
                                    failedHtml += '<br>';
                                });
                                $("#fail_div").html(failedHtml);
                            } else {
                                $.messager.alert('警告', rlt.message, 'warning');
                            }
                        }
                    });
                }
            });
        };

        // @override
        this.submit = function(panel, data, closeCallback) {
            closeCallback();
            return false;
        };

        // @override
        this.onClose = function(table, data) {
            table.datagrid('reload');
        };
    });

    return HouseholdregisterjbxxImp;
});