define(function(require) {
	var Config = require('config');
	var Core = require('core/core');
    var Dialog = require('centit/centit.dialog');
	var HouseholdregisterjbxxAdd = require('./householdregisterjbxx.add');

	var HouseholdregisterjbxxEdit = HouseholdregisterjbxxAdd.extend(function() {
		var _self = this;
		
		// @override
		this.load = function(panel, data) {
            var SelectUser = require('modules/sjcj/householdregisterjbxx/ctrl/farmhouse.choose');
            var _self = this;
            panel.find('#p_farmhouseid').click(function() {
                var _SelectUser = new SelectUser("farmhouse");
                _self.controllers["farmhouse"] = _SelectUser;
                _SelectUser.parent = _self;
                Dialog.open({
                    id : 'selectuser',
                    title : '农房改善信息',
                    href : "modules/sjcj/householdregisterjbxx/farmhouse-choosefarmid.jsp",
                    width : 900,
                    height : 570
                }, {}, _self.controllers["farmhouse"]);

            });
			var form = panel.find('form');
			
			Core.ajax(Config.ContextPath+'service/sjcj/householdregisterjbxx/'+data.hid, {
				type: 'json',
				method: 'get' 
			}).then(function(data) {
				_self.data = data;
				if(data.fid != null && data.fid != ''){
                    $('#p_farmhouseid, #p_farmhouseid + hr', panel).remove();
                    Core.ajax(Config.ContextPath+'service/sjcj/householdregisterjbxx/getFarmhousejbxx/'+data.fid, {//后面把这段代码补全
                        type: 'json',
                        method: 'get'
                    }).then(function(rlt) {
                        rlt.tel2 = rlt.tel;
                        delete rlt.tel;
                        var vid = rlt.vid;
                        if(vid != null && vid != '') {
                            Core.ajax(Config.ContextPath + 'service/sjcj/villagejbxx/' + vid, {
                                type: 'json',
                                method: 'get'
                            }).then(function (rlt1) {
                                rlt.districtcode = rlt1.districtcode;
                                rlt.town = rlt1.town;
                                rlt.administrativevillage = rlt1.administrativevillage;
                                rlt.naturalvillage = rlt1.naturalvillage;
                                data = $.extend(data, rlt);
                                form.form('load', data)
                                    .form('disableValidation')
                                    .form('readonly', 'hid')
                                    .form('focus');
                            });
                        }else{
                            rlt.districtcode = '';
                            rlt.town = '';
                            rlt.administrativevillage = '';
                            rlt.naturalvillage = '';
                            data = $.extend(data, rlt);
                            form.form('load', data)
                                .form('disableValidation')
                                .form('readonly', 'hid')
                                .form('focus');
                        }

                    });
                } else {
                    form.form('load', data)
                        .form('disableValidation')
                        .form('readonly', 'hid')
                        .form('focus');
                }

			});
		};
		
		// @override
		this.submit = function(panel, data, closeCallback) {
			var form = panel.find('form');
			
			// 开启校验
			form.form('enableValidation');
			var isValid = form.form('validate');

            if (isValid) {
                var obj = form.form("value");
                var reg = /(^\d{15}$)|(^\d{18}$)|(^\d{17}(\d|X|x)$)/;
                var regLength = /^.{0,150}$/;
                if(reg.test(obj.pid) == false) {
                    $.messager.alert('提醒', '身份证号输入不合法！','warning');
                    return  false;
                }else if (!regLength.test(obj.familyIncome)) {
                    $.messager.alert('提醒', '家庭收入情况字符长度不能大于150！');
                    return false;
                } else {
                    form.form('ajax', {
                        url: Config.ContextPath + 'service/sjcj/householdregisterjbxx',
                        method: 'post',
                        data: data
                    }).then(function(rlt){
                        if(rlt.isOk){
                            $.messager.alert('提醒', '户籍信息更新成功！');
                            closeCallback();
                        } else{
                            $.messager.alert('提醒', '户籍信息更新失败，原因：'+rlt.msg ,'warning');
                            return  false;
                        }
                    });
                }
            }

			return false;
		};
		
		// @override
		this.onClose = function(table) {
			table.datagrid('reload');
		};
	});

	return HouseholdregisterjbxxEdit;
});