define(function(require) {
    var Config = require('config');
    var Core = require('core/core');
    var Page = require('core/page');
    var $ = require('jquery');

    var Farmchoose = Page.extend(function() {
        var _self=this;
        // @override
        this.load = function(panel) {
            var table = this.table = panel.find('table');
            var url = "service/sjcj/farmhousejbxx";

            table.cdatagrid({
                controller: this,
                url:url

            });
        };

        // @override
        this.submit = function(panel, data, closeCallback) {
            var table = panel.find('#table_farms');
            var row = table.datagrid('getSelected');

            var tel2 = row.tel;
            var persontype = row.persontype;
            var vid = row.vid;
            var bettertype = row.bettertype;
            var fid = row.fid;
            var data = _self.parent.data;
            data.tel2 = tel2;
            data.persontype = persontype;
            data.fid = fid;
            data.bettertype = bettertype;
            if(vid != null && vid != ''){
                data.vid = vid;
                Core.ajax(Config.ContextPath+'service/sjcj/villagejbxx/'+vid, {
                    type: 'json',
                    method: 'get'
                }).then(function(rlt) {
                    var districtcode = rlt.districtcode;
                    var town = rlt.town;
                    var administrativevillage = rlt.administrativevillage;
                    var naturalvillage = rlt.naturalvillage;
                    data.districtcode = districtcode;
                    data.town = town;
                    data.administrativevillage = administrativevillage;
                    data.naturalvillage = naturalvillage;
                    var form = _self.parent.panel.find('form');
                    form.form('load', data);
                    closeCallback();
                });
            }else{
                data.districtcode = '';
                data.town = '';
                data.administrativevillage = '';
                data.naturalvillage = '';
                var form = _self.parent.panel.find('form');
                form.form('load', data);
              closeCallback();
            }


        };

        // @override
        this.onClose = function() {
        };
    });

    return Farmchoose;
});