let $1 = $(function () {
    define(function (require) {
        var Config = require('config');
        var Core = require('core/core');
        var Page = require('core/page');
        var Events = require('core/events');
        var echarts = require('js/echarts/echarts.min');
        var Dialog = require('centit/centit.dialog');
        var $ = require('jquery');
        var userType;
        /*ids:唯一标识
        * linkHref:请求页面地址
        * pageSrc:图片地址
        * childArray:二级机构数据
        * pageText:页面数据
        * requestText:请求页面tab
        * requestId:请求id
        * */
        var indexArray = [
            {
                "ids": 1,
                "linkHref": "modules/sjcj/villagejbxx/division.jsp",
                "pageSrc": "../../modules/sjcj/home/images/cy-icon1.png",
                "childArray": [],
                "pageText": "基础信息录入",
                "requestText": "基础信息录入",
                "requestId": "aa"
            },
            {
                "ids": 2,
                "linkHref": "modules/sjcj/villagejbxx/villagejbxx.jsp",
                "pageSrc": "../../modules/sjcj/home/images/cy-icon2.png",
                "pageText": "改善过程管理",
                "requestText": "改善过程管理",
                "requestId": "aa",
                "childArray": [
                    {
                        "ids": 5,
                        "linkHref": "/modules/task/task.jsp",
                        "pageSrc": "../../modules/sjcj/home/images/cy-icon5.png",
                        "pageText": "改善任务下发",
                        "requestText": "改善任务下发",
                        "requestId": "aa"
                    },
                    {
                        "ids": 6,
                        "linkHref": "modules/sjcj/statisticsList/statisticsList.jsp?stype=1",
                        "pageSrc": "../../modules/sjcj/home/images/cy-icon6.png",
                        "pageText": "改善计划编制",
                        "requestText": "改善计划编制",
                        "requestId": "aa"
                    },
                    {
                        "ids": 7,
                        "linkHref": "modules/sjcj/farmhousejbxx/farmhousejbxx-gs.jsp",
                        "pageSrc": "../../modules/sjcj/home/images/cy-icon7.png",
                        "pageText": "改善过程跟踪",
                        "requestText": "改善过程跟踪",
                        "requestId": "aa"
                    },
                    {
                        "ids": 8,
                        "linkHref": "modules/sjcj/statisticsList/statisticsList.jsp?stype=2",
                        "pageSrc": "../../modules/sjcj/home/images/cy-icon8.png",
                        "pageText": "实际改善推送",
                        "requestText": "实际改善推送",
                        "requestId": "aa"
                    }
                ]
            },
            {
                "ids": 3,
                "linkHref": "modules/sjcj/sjgsWork/sjgsWorkList.jsp",
                "pageSrc": "../../modules/sjcj/home/images/cy-icon3.png",
                "childArray": [],
                "pageText": "统计分析",
                "requestText": "统计分析",
                "requestId": "aa"
            },
            {
                "ids": 4,
                "childArray": [],
                "linkHref": "modules/sys/userinfo/userinfo.html",
                "pageSrc": "../../modules/sjcj/home/images/cy-icon4.png",
                "pageText": "用户管理",
                "requestText": "用户管理",
                "requestId": "aa"
            }
        ];


        // 业务信息
        var HomePage = Page.extend(function () {
            var curSelectXzqhCode = null; // 最后选择的行政区划编码
            var curSelectXzqhName = null; // 最后选择的行政区划名
            // @override
            var _self;
            var yhjb;
            this.load = function (panel) {
                //去掉加载效果
                var div1 = $($("#menu_tab_Dashboard").children("div").get(0));
                var div2 = $($("#center").children("div").get(1));
                div1.css("display", "none");
                div2.css("display", "none");
                _self = this;
                setTimeout(changeTzgg, 0);
                var allData = [];
                var thing = "<ul id=\"firstPage_vprocess\">\n" +
                    "\n" +
                    "    </ul>";

                // 地图
                Core.ajax(Config.ContextPath + 'service/common/getCurrentUnitInfo', {
                    method: 'get'
                }).then(function (rlt) {
                    var unitPath = rlt.unitPath;
                    userType = rlt.unitType;
                    unitPath = unitPath.substring(0, unitPath.length - 1);
                    var paths = unitPath.split("//");

                    //判断用户身份显示不同页面
                    if (userType == 4) {
                        //去掉加载效果
                        $(".ajax-loader-icon").parent("div").hide();
                        panel.find(".cy-others-content").hide();
                        //设置镇级用户填报权限
                        panel.find(".cy-user-content").show();
                        //panel.find(".cy-user-content").hide();
                        $("body").layout("collapse", "west");
                        //遍历得到一级菜单
                        var obj = {};
                        $.each(indexArray, function (index, element) {
                            allData.push(element);
                            var ids = element.ids;
                            obj[ids] = element.childArray;
                            var html = "<li unitCode=" + rlt.unitCode + " ids=" + element.ids + ">\n" +
                                "                    <a  href=\"#\">\n" +
                                "                           <div class=\"cy-icon-item\"" +
                                ">\n" +
                                "                            <img src=" + element.pageSrc + ">\n" +
                                "                            <p>" + element.pageText + "</p>\n" +
                                "                        </div>\n" +
                                "                    </a>\n" +
                                "                </li>";
                            $(".cy-ul-1").append(html);

                        });
                        /*点击进入二级菜单*/
                        var firstHtml = '  <div class="cy-first-children">\n' +
                            '                    <img src="../../modules/sjcj/home/images/4.png" class="cy-bg-img">\n' +
                            '                    <div class="cy-icon-item">\n' +
                            '                        <img src="../../modules/sjcj/home/images/cy-icon-12.png">\n' +
                            '                        <p>农房基础信息录入</p>\n' +
                            '                    </div>\n' +
                            '                    <div class="cy-icon-item">\n' +
                            '                        <img src="../../modules/sjcj/home/images/cy-icon-13.png">\n' +
                            '                        <p>改善项目信息录入</p>\n' +
                            '                    </div>\n' +
                            '                    <div class="cy-icon-item">\n' +
                            '                        <img src="../../modules/sjcj/home/images/cy-icon-11.png">\n' +
                            '                        <p>村庄基础录入</p>\n' +
                            '                    </div>\n' +
                            '                    </ul>\n' +
                            '                </div>';
                        var secondHtml = '<div class="cy-second-children">\n' +
                            '                    <img src="../../modules/sjcj/home/images/3.png" class="cy-bg-img">\n' +
                            '                    <div>\n' +
                            '                        <div class="cy-icon-item">\n' +
                            '                            <img src="../../modules/sjcj/home/images/cy-icon-21.png">\n' +
                            '                            <p>改善任务下发</p>\n' +
                            '                        </div>\n' +
                            '                        <div class="cy-icon-item">\n' +
                            '                            <img src="../../modules/sjcj/home/images/cy-icon-22.png">\n' +
                            '                            <p>改善计划编辑</p>\n' +
                            '                        </div>\n' +
                            '                        <div class="cy-icon-item">\n' +
                            '                            <img src="../../modules/sjcj/home/images/cy-icon-23.png">\n' +
                            '                            <p>改善过程跟踪</p>\n' +
                            '                        </div>\n' +
                            '                        <div class="cy-icon-item">\n' +
                            '                            <img src="../../modules/sjcj/home/images/cy-icon-24.png">\n' +
                            '                            <p>实际改善推送</p>\n' +
                            '                        </div>\n' +
                            '                    </div>\n' +
                            '                    </ul>\n' +
                            '                </div>';

                        //点击进入二级菜单或者跳转网页
                        $(".cy-ul-1 .cy-icon-item").on("click", "img", function () {
                            var index = $(this).parent().parent().parent().index();
                            if (index === 0) {
                                if ($(this).parent().parent().hasClass("cy-first-children")) {
                                    panel.find(".cy-first-children").hide();

                                } else {
                                    $(this).parent().parent().append(firstHtml);
                                }

                                panel.find(".cy-first-children .cy-icon-item").on("click", function () {
                                    var index = $(this).index();
                                    if (index === 3) {
                                        urlPost("modules/sjcj/villagejbxx/division.jsp", "aa", "选择行政村", "选择行政村");
                                    } else if (index === 1) {
                                        urlPost("/modules/sjcj/farmhousejbxx/farmhousejbxx.jsp", "aa", "农房基础信息", "农房基础信息");
                                    } else if (index === 2) {
                                        urlPost("/modules/sjcj/newhousingjbxx/newhousingjbxx.jsp", "aa", "改善项目信息", "改善项目信息");
                                    }
                                    $(this).parent().hide();

                                })
                                panel.find(".cy-second-children").hide();

                            } else if (index === 1) {
                                if ($(this).parent().parent().hasClass("cy-second-children")) {
                                    panel.find(".cy-second-children").hide();
                                } else {
                                    $(this).parent().parent().append(secondHtml);
                                }
                                panel.find(".cy-second-children .cy-icon-item").on("click", function () {
                                    var index = $(this).index();
                                    if (index === 0) {
                                        urlPost("/modules/task/task.jsp", "aa", "改善任务下发", "改善任务下发");
                                    } else if (index === 1) {
                                        urlPost("/modules/sjcj/statisticsList/statisticsList.jsp?stype=1", "aa", "改善计划编辑", "改善计划编辑");
                                    } else if (index === 2) {
                                        urlPost("/modules/sjcj/farmhousejbxx/farmhousejbxx-gs.jsp", "aa", "改善过程跟踪", "改善过程跟踪");
                                    } else if (index === 3) {
                                        urlPost("/modules/sjcj/statisticsList/statisticsList.jsp?stype=2", "aa", "实际改善推送", "实际改善推送");
                                    }
                                    $(this).parent().parent().hide();

                                })
                                panel.find(".cy-first-children").hide();
                            } else if (index === 2) {
                                urlPost("modules/sjcj/sjgsWork/sjgsWorkList.jsp", "aa", "统计分析", "统计分析");
                                panel.find(".cy-first-children").hide();
                                panel.find(".cy-second-children").hide();

                            } else if (index === 3) {
                                urlPost("modules/sys/userinfo/userinfo.html", "aa", "用户管理", "用户管理");
                                panel.find(".cy-first-children").hide();
                                panel.find(".cy-second-children").hide();
                            }
                        });
                        panel.off('click', '.nli2');
                    }
                    else {
                        $(".ajax-loader-icon").parent("div").hide();
                        panel.find(".cy-user-content").hide();
                        panel.find(".cy-others-content").show();
                        $(".cy-others-content").find("td:nth-child(2)").append(thing);
                        if (paths.length == 1) { // 省级
                            yhjb = "1";
                            curSelectXzqhCode = '320000000000';
                            curSelectXzqhName = '江苏省';
                            loadBoundary();
                            getHouseCount();
                            getHeatData();
                        }
                        if (paths.length > 1) { // 市级及以下
                            panel.find('#home_city_combobox').combobox({disabled: true});
                        }
                        if (paths.length > 2) { // 区级及以下
                            panel.find('#home_district_combobox').combobox({disabled: true});
                        }
                        if (paths.length > 3) { // 镇级及以下
                            panel.find('#home_town_combobox').combobox({disabled: true});
                        }

                        // 市下拉框
                        panel.find('#home_city_combobox').combobox({
                            onLoadSuccess: function () {
                                if (paths.length > 1) { // 市级及以下
                                    panel.find('#home_city_combobox').combobox('setValue', paths[1]);
                                }
                            },
                            onSelect: function (row) {
                                if (row.unitName != '') {
                                    panel.find('#home_district_combobox').combobox('reload', Config.ContextPath + 'service/common/getUnitList?parentUnit=' + row.unitCode);
                                    if (paths.length <= 2) { // 省级、市级
                                        curSelectXzqhCode = row.unitCode;
                                        curSelectXzqhName = row.unitName;
                                        loadBoundary();
                                        getHouseCount();
                                        getHeatData();
                                    }
                                }
                            },
                            onChange: function (newValue, oldValue) {
                                panel.find('#home_district_combobox').combobox('clear');
                                panel.find('#home_town_combobox').combobox('clear');
                                if (newValue == '') {
                                    panel.find('#home_district_combobox').combobox('loadData', {});
                                    curSelectXzqhCode = '320000000000';
                                    curSelectXzqhName = '江苏省';
                                    loadBoundary();
                                    getHouseCount();
                                    getHeatData();
                                }
                            }
                        });

                        // 区下拉框
                        panel.find('#home_district_combobox').combobox({
                            onLoadSuccess: function () {
                                if (paths.length > 2) { // 区级及以下
                                    panel.find('#home_district_combobox').combobox('setValue', paths[2]);
                                }
                            },
                            onSelect: function (row) {
                                if (row.unitName != '') {
                                    panel.find('#home_town_combobox').combobox('reload', Config.ContextPath + 'service/common/getUnitList?parentUnit=' + row.unitCode);
                                    if (paths.length <= 3) { // 省级、市级、区级
                                        curSelectXzqhCode = row.unitCode;
                                        curSelectXzqhName = panel.find('#home_city_combobox').combobox('getText') + row.unitName;
                                        loadBoundary();
                                        getHouseCount();
                                        getHeatData();
                                    }
                                }
                            },
                            onChange: function (newValue, oldValue) {
                                panel.find('#home_town_combobox').combobox('clear');
                                if (newValue == '') {
                                    panel.find('#home_town_combobox').combobox('loadData', {});
                                    if ("" != panel.find('#home_city_combobox').combobox('getValue')) {
                                        curSelectXzqhCode = panel.find('#home_city_combobox').combobox('getValue');
                                    }
                                    curSelectXzqhName = panel.find('#home_city_combobox').combobox('getText');
                                    loadBoundary();
                                    getHouseCount();
                                    getHeatData();
                                }
                            }
                        });

                        // 镇下拉框
                        panel.find('#home_town_combobox').combobox({
                            onLoadSuccess: function () {
                                if (paths.length > 3) { // 镇级及以下
                                    panel.find('#home_town_combobox').combobox('setValue', paths[3]);
                                }
                            },
                            onSelect: function (row) {
                                if (row.unitName != '') {
                                    curSelectXzqhCode = row.unitCode;
                                    curSelectXzqhName = panel.find('#home_city_combobox').combobox('getText') + row.unitName;
                                    clearBoundary();
                                    getHouseCount();
                                    getHeatData();
                                }
                            },
                            onChange: function (newValue, oldValue) {
                                if (newValue == '') {
                                    if ("" != panel.find('#home_district_combobox').combobox('getValue')) {
                                        curSelectXzqhCode = panel.find('#home_district_combobox').combobox('getValue');
                                    }
                                    /* curSelectXzqhCode = panel.find('#home_district_combobox').combobox('getValue');*/
                                    curSelectXzqhName = panel.find('#home_city_combobox').combobox('getText') + panel.find('#home_district_combobox').combobox('getText');
                                    loadBoundary();
                                    getHouseCount();
                                    getHeatData();
                                }
                            }
                        });

                        // 热力图
                        panel.find('#heat_map_btn').bind('click', toggleHeat);
                    }

                });

                //代办
                $('<div class="wdtz2">' + getXtsj() + '</div>').appendTo($('#firstPage-cztj-title'));
                $('<div class="wdtz2">' + getXtsj() + '</div>').appendTo($('#firstPage-bqtj-title'));
                $('<div class="wdtz2">' + getXtsj() + '</div>').appendTo($('#firstPage-nhtj-title'));
                $('<div class="wdtz2">' + getXtsj() + '</div>').appendTo($('#firstPage-fwtj-title'));

                dai_ban();

                function urlPost(linkHref, requestId, requestText) {
                    var url = Config.ContextPath + linkHref;
                    Events.trigger('open.MenuTab', {
                        id: requestId,
                        text: requestText,
                        url: url,
                        closable: true
                    }, false);
                }

                //通知公告模块跳转 notice_btn
                /*panel.find('.notice_btn').click(function () {
                    var url = Config.ContextPath + "modules/sjcj/notice/notice.jsp";
                    Events.trigger('open.MenuTab', {
                        id: 'taskList_b',
                        text: '通知公告',
                        url: url,
                        closable: true
                    }, false);
                });*/


                //统计分析模块
                Core.ajax(Config.ContextPath + 'service/common/getCurrentUnitInfo', {//获取当前用户信息
                    method: 'get'
                }).then(function (rlt) {
                   var  unitCode = rlt.unitCode;//获取当前机构编码
                    userType = rlt.unitType;
                    var url = 'service/sjcj/farmhousejbxx/statisticsNf?t=t';
                    if(userType != 4){
                        if(unitCode!=undefined){
                            url += "&city=" + unitCode;
                            url += "&year="+'2019';
                        }
                        Core.ajax(Config.ContextPath + url, {
                            type: 'json',
                            method: 'get'
                        }).then(function(data) {
                            echartsHjs(data);
                            echartsBqqk(data);
                            echartsNhs(data);
                            echartsFws(data);
                        });
                    }

                });


                //流程待办模块跳转
                panel.on('click', '.nli1', function () {
                    var url = Config.ContextPath + "modules/sjcj/vprocess/vprocess.jsp";
                    Events.trigger('open.MenuTab', {
                        id: 'taskList_b',
                        text: '待受理流程',
                        url: url,
                        closable: true
                    }, false);
                });

                //查看待办流程信息
                panel.off('click', '.nli2');
                panel.on('click', '.nli2', function (e) {
                    var str = this.id;
                    var status = str.substr(str.length - 2, 2);
                    var mkbm = str.substr(str.length - 3, 1);
                    var mid = str.substr(0, str.length - 3);
                    /*var queryparam;
                    var controllerquers;
                    var _controllerquers;*/
                    var title = $(e.target).html();//标题
                    var title_name;
                    var tName;
                    var SelectUser;
                    var url;
                    var id;
                    /* if (mkbm == '1') {*/
                    id = "farmHouseStatistics";
                    SelectUser = require('modules/sjcj/farmHouseStatistics/ctrl/farmHouseStatistics');
                    url = "modules/sjcj/farmHouseStatistics/farmHouseStatistics.jsp";
                    /* } else if (mkbm == '2') {
                         id = "farmHouseStatistics2";
                         SelectUser = require('modules/sjcj/farmHouseStatistics2/ctrl/farmHouseStatistics2');
                         url = "modules/sjcj/farmHouseStatistics2/farmHouseStatistics2.jsp";
                     }*/ /*else if (mkbm == '3') {
                    id = "workloadStatisticsid";
                    SelectUser = require('modules/sjcj/workloadStatistics/ctrl/workloadStatistics.view');
                    url = "modules/sjcj/workloadStatistics/workloadStatistics-view.jsp";
                } else if (mkbm == '4') {
                    id = "workloadStatistics2";
                    SelectUser = require('modules/sjcj/workloadStatistics2/ctrl/workloadStatistics2.view');
                    url = "modules/sjcj/workloadStatistics2/workloadStatistics2-view.jsp";
                }*/
                    var _SelectUser = new SelectUser(id);
                    _self.controllers[id] = _SelectUser;
                    _SelectUser.parent = _self;
                    Dialog.open({
                        id: id,
                        title: title,
                        href: url,
                        width: 1300,
                        height: 570
                    }, {'wid': mid, closeFlag: true}, _self.controllers[id]);
                    /*  if(mkbm=='1'){
                          queryparam=Config.ContextPath + "modules/sjcj/farmHouseStatistics/farmHouseStatistics_1.jsp?sid="+mid+'&dqzRoleCode='+roleCode+'&status='+status;
                          tests="计划改善农民群众住房条件信息统计表";
                          controllerquers=require('modules/sjcj/farmHouseStatistics/ctrl/farmHouseStatistics');
                      }else if(mkbm=='2'){
                          queryparam= Config.ContextPath +"modules/sjcj/farmHouseStatistics2/farmHouseStatistics2.jsp?sid="+mid+'&dqzRoleCode='+roleCode+'&status='+status;
                          tests="实际改善农民群众住房条件信息统计表";
                          controllerquers=require('modules/sjcj/farmHouseStatistics2/ctrl/farmHouseStatistics2');
                      }else if(mkbm=='3'){
                          queryparam= Config.ContextPath + 'modules/sjcj/workloadStatistics/workloadStatistics-view.jsp?wid='+mid+'&dqzRoleCode='+roleCode+'&status='+status+'&tjth=1';
                          tests="计划完成改善农民群众住房条件工作量统计表";
                          controllerquers=require('modules/sjcj/workloadStatistics/ctrl/workloadStatistics.view');
                      }else if(mkbm=='4'){
                          queryparam= Config.ContextPath + 'modules/sjcj/workloadStatistics2/workloadStatistics-view2.jsp?wid='+mid+'&dqzRoleCode='+roleCode+'&status='+status+'&tjth=1';
                          tests="实际完成改善农民群众住房条件工作量统计表";
                          controllerquers=require('modules/sjcj/workloadStatistics2/ctrl/workloadStatistics2.view');
                      }*/
                    /*       Events.trigger('open.MenuTab', {
                               id: mid,
                               text: tests,
                               url: queryparam,
                               closable: true
                           }, false);*/

                });


            };

            //echart1 省定农改目标任务完成情况
            function echartsHjs(list) {
                //数据处理
                var xData = new Array();
                var wgsData = new Array();
                var ygsData = new Array();
                var gslData = new Array();
                var index=0;
                for(var i=0;i<list.length-1;i++){
                    var obj = list[i];
                  if(yhjb == "1" ){//如果为省级用户
                      if(obj.sjbm == '小计'){
                          xData[index] = obj.city;//x轴数据
                          wgsData[index] = obj.target;//目标数
                          ygsData[index] = obj.totalNumber;//实际完成数
                          if(obj.finishProportion != null && obj.finishProportion != 0 && obj.finishProportion.length > 0){
                              gslData[index] = obj.finishProportion.replace(/%/g, '');//百分比
                          } else {
                              gslData[index] = 0;
                          }

                          index++;
                  }}else{
                      if(obj.sjbm != '小计'){
                          xData[i]=obj.sjbm;
                          wgsData[i] = obj.target;//目标数
                          ygsData[i] = obj.totalNumber;//实际完成数
                          if(obj.finishProportion != null && obj.finishProportion != 0 && obj.finishProportion.length > 0){
                              gslData[i] = obj.finishProportion.replace(/%/g, '');//百分比
                          } else {
                              gslData[i] = 0;
                          }
                      }
                  }
                }
                var myChart = echarts.init(document.getElementById('firstPage-cztj-tb'));
                var colors = ['#37A2DA', '#32C5E9', '#E7BCF3'];
                option = {
                    title: {
                        text: '省定农改目标任务完成情况',
                        textStyle: {
                            color: "#737373",
                            fontSize: 15, //字体大小
                        },
                        top: 15,
                        x: 'center'
                    },
                    color: colors,
                    tooltip: {
                        trigger: 'axis',
                        axisPointer: {            // 坐标轴指示器，坐标轴触发有效
                            type: 'shadow'        // 默认为直线，可选为：'line' | 'shadow'
                        }
                    },
                    legend: {
                        data: ['目标数', '完成数', '完成比'],
                        bottom: '70%',
                        right: 10,
                    },
                    grid: {
                        left: '2%',
                        right: '0%',
                        bottom: '3%',
                        height: '50%',
                        containLabel: true
                    },
                    xAxis: [
                        {
                            type: 'category',
                            data: xData,
                            axisLabel: {
                                interval: 0,
                                rotate: -55
                            },
                            axisTick: {
                                alignWithLabel: true
                            }
                        }
                    ],
                    yAxis: [
                        {
                            type: 'value',
                            name: '数量(个)',
                            splitLine: {
                                show: false
                            }
                        },
                        {
                            type: 'value',
                            name: '百分比(%)',
                            min: 0,
                            max: 250,
                            position: 'right',
                            splitLine: {
                                show: false
                            }
                        }
                    ],
                    series: [
                        {
                            name: '目标数',
                            type: 'bar',
                            barWidth: 15,
                            stack: 'k',
                            data: wgsData,
                        },
                        {
                            name: '完成数',
                            type: 'bar',
                            stack: 'k',
                            data: ygsData,
                        },
                        {
                            name: '完成比',
                            type: 'line',
                            data: gslData,
                            yAxisIndex: 1,
                        }
                    ]
                };
                myChart.setOption(option);
            }

            //echart4 各地计划新建项目
            function echartsBqqk(list) {
                var index=0;
                var xData = new Array();//x轴
                var proNumbers = new Array();//y轴
                for(var i=0;i<list.length-1;i++){
                    var obj = list[i];
                    if(yhjb == "1" ){//如果为省级用户
                        if(obj.sjbm == '小计'){
                            xData[index] = obj.city;//x轴数据
                            proNumbers[index] = obj.proNumbers;//项目总数
                            index++;
                        }}else{
                        if(obj.sjbm != '小计'){
                            xData[i]=obj.sjbm;
                            proNumbers[i] = obj.proNumbers;//项目总数
                        }
                    }
                }
                var myChart = echarts.init(document.getElementById('firstPage-bqtj-tb'));
                option = {
                    title: {
                        text: '各地计划新建项目',
                        textStyle: {
                            color: "#737373",
                            fontSize: 15, //字体大小
                        },
                        top: 15,
                        x: 'center'
                    },
                    color: ['#3398DB'],
                    tooltip: {
                        trigger: 'axis',
                        axisPointer: {            // 坐标轴指示器，坐标轴触发有效
                            type: 'shadow'        // 默认为直线，可选为：'line' | 'shadow'
                        }
                    },
                    grid: {
                        left: '3%',
                        right: '8%',
                        bottom: '3%',
                        containLabel: true
                    },
                    xAxis: [
                        {
                            axisLabel: {
                                interval: 0,
                                rotate: -55
                            },
                            type: 'category',
                            data:xData ,
                            axisTick: {
                                alignWithLabel: true
                            }
                        }
                    ],
                    yAxis: [
                        {
                            type: 'value'
                        }
                    ],
                    series: [
                        {
                            name: '项目总数',
                            type: 'bar',
                            barWidth: '50%',
                            data: proNumbers
                        }
                    ]
                };
                myChart.setOption(option);
            }

            // echart3 规划发展村庄就地新建翻建改善（户）
            function echartsNhs(list) {
                var index=0;
                var xData = new Array();//x轴
                var overHouse = new Array();//y轴
                for(var i=0;i<list.length-1;i++){
                    var obj = list[i];
                    if(yhjb == "1" ){//如果为省级用户
                        if(obj.sjbm == '小计'){
                            xData[index] = obj.city;//x轴数据
                            overHouse[index] = obj.overHouse;//就地翻建项目
                            index++;
                        }
                    }else{
                        if(obj.sjbm != '小计'){
                            xData[i]=obj.sjbm;
                            overHouse[i] = obj.overHouse;//项目总数
                        }
                    }
                }
                var myChart = echarts.init(document.getElementById('firstPage-nhtj-tb'));
                option = {
                    title: {
                        text: '规划发展村庄就地新建翻建改善（户）',
                        textStyle: {
                            color: "#737373",
                            fontSize: 15, //字体大小
                        },
                        top: 15,
                        x: 'center'
                    },
                    tooltip: {
                        trigger: 'axis',
                        axisPointer: {            // 坐标轴指示器，坐标轴触发有效
                            type: 'shadow'        // 默认为直线，可选为：'line' | 'shadow'
                        }
                    },
                    grid: {
                        left: '3%',
                        right: '8%',
                        bottom: '3%',
                        containLabel: true
                    },
                    xAxis: {
                        type: 'category',
                        axisLabel: {
                            interval: 0,
                            rotate: -55
                        },
                        data: xData
                    },
                    yAxis: {
                        type: 'value'
                    },
                    series: [{
                        data: overHouse,
                        type: 'line'
                    }]
                };
                myChart.setOption(option);
            }

            // echart2 省定各市目标任务各市分解
            function echartsFws(list) {
                var index=0;
                var targetList = new Array();//y轴
                for(var i=0;i<list.length-1;i++){
                    var obj = list[i];
                    if(yhjb == "1" ){//如果为省级用户
                        if(obj.sjbm == '小计'){
                            var pieObject={'value':obj.target,'name':obj.city};
                            targetList.push(pieObject);
                            index++;
                        }
                    }else{
                        if(obj.sjbm != '小计'){
                            var pieObject={'value':obj.target,'name':obj.sjbm};
                            targetList.push(pieObject);
                        }
                    }
                }
                var myChart = echarts.init(document.getElementById('firstPage-fwtj-tb'));
                option = {
                    color: ['#37A2DA', '#32C5E9', '#71F6F9', '#AEFDCA', '#FFF065', '#FFAE8B', '#FF7DA1', '#F66BBF', '#E690D1', '#FECEFF', '#ACA5FF', '#9084FF', '#A5D2FF'],
                    title: {
                        text: '省定各市目标任务各市分解',
                        textStyle: {
                            color: "#737373",
                            fontSize: 15, //字体大小
                        },
                        top: 15,
                        x: 'center'
                    },
                    tooltip: {
                        trigger: 'item',
                        formatter: "{a} <br/>{b} : {c} ({d}%)"

                    },
                    series: [
                        {
                            name: '省定各市目标任务分解',
                            type: 'pie',
                            radius: '40%',
                            center: ['55%', '60%'],
                            data: targetList,
                            itemStyle: {
                                emphasis: {
                                    shadowBlur: 10,
                                    shadowOffsetX: 0,
                                    shadowColor: 'rgba(0, 0, 0, 0.5)'
                                }
                            }
                        }
                    ]
                };
                myChart.setOption(option);
            }

            // 地图 - 绘制区划边界
            function loadBoundary() {
                var subMap = $("#home_map_iframe")[0].contentWindow;
                if (subMap.markBoundary != null && subMap.map != null) {
                    subMap.markBoundary(curSelectXzqhName);
                } else {
                    setTimeout(loadBoundary, 500);
                }
            }

            // 地图 - 清除区划边界
            function clearBoundary() {
                var subMap = $("#home_map_iframe")[0].contentWindow;
                if (subMap.clearBoundary != null && subMap.map != null) {
                    subMap.clearBoundary();
                } else {
                    setTimeout(clearBoundary, 500);
                }
            }

            // 地图 - 获取农改户数
            function getHouseCount() {
                Core.ajax(Config.ContextPath + 'service/sjcj/farmhousejbxx/getHouseCnt/' + curSelectXzqhCode, {
                    type: 'json',
                    method: 'get'
                }).then(function (rlt) {
                    var rltsj = new Array();
                    var index1 = 0;
                    var city = $("#home_city_combobox").val();
                    if (yhjb == "1") {
                        if ("" != city) {
                            loadHouseCntLabel(rlt);
                        } else {
                            for (var i = 0; i < rlt.length; i++) {
                                var obj1 = rlt[i];
                                if (obj1.name == "徐州市" || obj1.name == "连云港市" || obj1.name == "淮安市" || obj1.name == "盐城市" || obj1.name == "宿迁市") {
                                    rltsj[index1] = obj1;
                                    index1++;
                                }
                            }
                            loadHouseCntLabel(rltsj);
                        }
                    } else {
                        loadHouseCntLabel(rlt);
                    }

                });
            }

            // 地图 - 添加农改户数标注
            function loadHouseCntLabel(rlt) {
                var subMap = $("#home_map_iframe")[0].contentWindow;
                if (subMap.markHouseCount != null && subMap.map != null) {
                    subMap.markHouseCount(rlt, curSelectXzqhName);
                } else {
                    setTimeout(function () {
                        loadHouseCntLabel(rlt)
                    }, 500);
                }
            }

            // 地图 - 获取热力图所需数据
            function getHeatData() {
                Core.ajax(Config.ContextPath + 'service/sjcj/farmhousejbxx/getListForHeatmap/' + curSelectXzqhCode, {
                    method: 'get'
                }).then(function (rlt) {
                    drawHeatMap(rlt);
                });
            }

            // 地图 - 绘制热力图
            function drawHeatMap(rlt) {
                var subMap = $("#home_map_iframe")[0].contentWindow;
                if (subMap.drawHeatMap != null && subMap.map != null) {
                    subMap.drawHeatMap(rlt);
                } else {
                    setTimeout(function () {
                        drawHeatMap(rlt)
                    }, 500);
                }
            }

            // 地图 - 热力图显示、隐藏
            function toggleHeat() {
                var subMap = $("#home_map_iframe")[0].contentWindow;
                if ($("#heat_map_btn").linkbutton("options").selected) {
                    if (subMap.showHeatMap != null && subMap.map != null) {
                        subMap.showHeatMap();
                    } else {
                        setTimeout(toggleHeat, 500);
                    }
                } else {
                    if (subMap.hideHeatMap != null && subMap.map != null) {
                        subMap.hideHeatMap();
                    } else {
                        setTimeout(toggleHeat, 500);
                    }
                }
            }

            // 地图 - 跳转至农改列表
            this.toFarmhouseList = function (vid, unitcode, unitname) {
                var url = Config.ContextPath + "modules/sjcj/farmhousejbxx/farmhousejbxx.jsp";
                if (vid != null && vid != "" && vid != "undefined") {
                    url += "?vid=" + vid;
                } else if (unitcode != null && unitcode != "" && unitcode != "undefined") {
                    url += "?unitcode=" + unitcode;
                }
                Events.trigger('open.MenuTab', {
                    id: 'taskList_m',
                    text: unitname + '农房改善信息',
                    url: url,
                    closable: true
                }, false);
            }

            //获取系统时间并格式化时间
            function getXtsj() {
                var date = new Date();
                var weekArray = ["星期日", "星期一", "星期二", "星期三", "星期四", "星期五", "星期六"];
                var xtsj = date.getFullYear() + "年" + (date.getMonth() + 1) + "月" + date.getDate() + "日&nbsp;&nbsp;" + weekArray[date.getDay()];
                return xtsj;
            }

            function getXtsj1() {
                var date = new Date();
                var weekArray = ["星期日", "星期一", "星期二", "星期三", "星期四", "星期五", "星期六"];
                var xtsj = date.getFullYear() + "年" + (date.getMonth() + 1) + "月" + date.getDate() + "日 " + weekArray[date.getDay()];
                return xtsj;
            }

            /*
                * 参数说明
                * obj : 动画的节点，本例中是ul
                * top : 动画的高度，本例中是-35px;注意向上滚动是负数
                * time : 动画的速度，即完成动画所用时间，本例中是500毫秒，即marginTop从0到-35px耗时500毫秒
                * function : 回调函数，每次动画完成，marginTop归零，并把此时第一条信息添加到列表最后;
                *
            */
            function noticeUp() {
                var ul = _self.panel.find('.top_tzgg ul');
                ul.css({marginTop: "0"}).find(":first").appendTo(ul);
                _self.panel.find('.top_tzgg ul').animate({
                    marginTop: "-35px"
                }, 500)
            }

            var tzggxx;//通知公告列表
            var tzggindex;//通知公告展示标数
            var tzggNum;//通知公告列表个数
            //定时任务函数，定时更新通知公告内容
            var changeTzgg = function () {
                Core.ajax(Config.ContextPath + 'service/sjcj/notice?sort=updateTime&order=desc&rows=5', {
                    method: 'get'
                }).then(function (rlt) {
                    var tzggul = _self.panel.find("#tzgg_ul");
                    rlt = rlt.objList;
                    if (rlt != null && rlt.length > 0) {
                        for (var i = 0; i < rlt.length; i++) {
                            var obj = rlt[i];
                            var tzggtest = "通知公告：" + obj.ntitle + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + obj.createTime.substring(0, 10) + "" + "</font> ";
                            $('<li class="top_tzggnr" id="' + obj.nid + '">' + tzggtest + '</li>').appendTo(tzggul);
                        }
                    }
                    // 调用 公告滚动函数
                    setInterval(noticeUp, 4000);

                    //查看通知公告信息
                    _self.panel.find('.top_tzggnr').click(function (arg1) {
                        var tid = arg1.currentTarget.id;
                        var url = Config.ContextPath + "modules/sjcj/notice/notice-view2.jsp?id=" + tid;
                        Events.trigger('open.MenuTab', {
                            id: 'taskList_b',
                            text: '查看公告',
                            url: url,
                            closable: true
                        }, false);
                    });

                    /*tzggxx = rlt.objList;
                    tzggNum = rlt.objList.length;
                    tzggindex = 0;
                    changeTzgg1();*/
                });

            }

            //通知公告展示-弃用
            var changeTzgg1 = function () {
                if (tzggindex > tzggNum) {
                    tzggindex = 0;
                }
                var title = tzggxx[tzggindex].ntitle;
                var createTime = tzggxx[tzggindex].createTime;
                var time = createTime.substring(0, 10);
                var noticeid = tzggxx[tzggindex].nid;
                var tzggtest = "通知公告：" + title + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + time + "" + "</font> ";
                $(".top_tzggnr").html(tzggtest);
                $(".nid").val(noticeid);
                setTimeout(changeTzgg1, 5000);
                tzggindex++;
            }

            //代办模块加载
            function dai_ban() {
                //我的待办
                Core.ajax(Config.ContextPath + 'service/common/getLoginUserRoles', {
                    method: 'get'
                }).then(function (rlt) {
                    var isZj = false;
                    var isck = false;
                    for (var i = 0; i < rlt.length; i++) {
                        roleCode = rlt[1].roleCode;//赋值，传给待办的页面
                        if (rlt[i].roleCode == '0013') {
                            roleCode = rlt[i].roleCode;
                            isZj = true;
                            break;
                        }
                        if(rlt[i].roleCode == '0015'){
                            isck = true;
                        }
                    }
                    if(isck){
                        _self.panel.find("#firstPage_db").hide();
                    }
                    if (!isZj) {
                        Core.ajax(Config.ContextPath + 'service/utils/process?sort=updatetime&order=desc', {
                            method: 'get'
                        }).then(function (rlt) {
                            var data = rlt.objList;
                            var count = 0;
                            var ul = $("#firstPage_vprocess");
                            if (data == null) {
                                ul.append('<li class="nli1" ><span style="display:inline-block;position: relative;overflow: hidden; margin: 0;padding: 0;"> <span class="tb"></span><span class="sz">' + 0 + '</span><div class="wdtz"><div class="wdtz1">待办事宜</div><div class="wdtz2">' + getXtsj() + '</div></div></span></li>');
                            } else {
                                ul.append('<li class="nli1" ><span style="display:inline-block;position: relative;overflow: hidden; margin: 0;padding: 0;"> <span class="tb"></span><span class="sz">' + data.length + '</span><div class="wdtz"><div class="wdtz1">待办事宜</div><div class="wdtz2">' + getXtsj() + '</div></div></span></li>');
                                var div = $('<div id="homePage_tzgg"></div>').appendTo(ul);
                                $(data).each(function () {
                                    var mkbm = this.mkbm;
                                    div.append('<div>' + this.updatetime + '</div>');
                                    div.append('<div class="nli2"  id="' + this.mid + this.mkbm + this.status + '"><span class="redC"></span><span>' + this.title + '</span></div>');
                                    if (count++ > 2)
                                        return false;
                                });

                            }
                            //村庄数量统计加时间
                            //$('<div class="wdtz2">' + getXtsj() + '</div>').appendTo($('#firstPage-cztj-title'));
                        });
                    } else {//如果是村庄则统计无农房改善的信息
                        var codes;
                        Core.ajax(Config.ContextPath + 'service/common/getLoginUser', {
                            method: 'get'
                        }).then(function (rlt) {
                            codes = rlt.userInfo.primaryUnit;
                            /*      alert(codes);*/
                            Core.ajax(Config.ContextPath + 'service/utils/process/searchUnfarms?towncode=' + codes, {
                                method: 'get'
                            }).then(function (rlt) {
                                var data = rlt;
                                var count = 0;
                                var ul = $("#firstPage_vprocess");
                                if (data == null) {
                                    ul.append('<li class="nlitl" ><span style="display:inline-block;position: relative;overflow: hidden; margin: 0;padding: 0;"> <span class="tb"></span><span class="sz">' + 0 + '</span><div class="wdtz"><div class="wdtz1">我的待办</div><div class="wdtz2">' + getXtsj() + '</div></div></span></li>');
                                } else {
                                    ul.append('<li class="nlit1" ><span style="display:inline-block;position: relative;overflow: hidden; margin: 0;padding: 0;"> <span class="tb"></span><span class="sz">' + data.length + '</span><div class="wdtz"><div class="wdtz1">我的待办</div><div class="wdtz2">' + getXtsj() + '</div></div></span></li>');
                                    var div = $('<div id="homePage_tzgg"></div>').appendTo(ul);
                                    $(data).each(function () {
                                        var title = data.title;
                                        div.append('<div class="nlit2" ><span class="redC"></span><span>' + this.title + '</span></div>');
                                        if (count++ > 2)
                                            return false;
                                    });
                                }
                            });
                        });
                    }
                });
            }

        });

        return HomePage;
    });
});
