<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<div class="easyui-layout" fit="true" id="fundsummary-info-main">
    <div region="north" border="false" style="height: 60px; padding: 4px;">
        <div class="easyui-panel search-body" cls="search" style="width: 100%; margin-bottom: 0;">
            <form class="clearFromValue" id="fundsummary_search_form">
                <div class="search-item">
                    <label>年份</label>
                    <input type="text" class="easyui-combobox" name="fsyear" style="width: 80px"
                           url="service/common/getYearList/10" method="get"
                           data-options="valueField:'year',textField:'year'"/>
                </div>
                <div class="search-item">
                    <label>行政区划</label>
                    <!--江苏省-->
                 <%--   <input type="text" class="easyui-combobox" name="first"
                           data-options="valueField: 'value',textField: 'label', data: [{label: '江苏省',value: '320000000000'}]"
                           method="get" prompt="省" value="320000000000" validType="true"/>--%>
                    &nbsp;
                    <input type="text" class="easyui-combobox" data-options="valueField:'unitCode',textField:'unitName'"
                           name="second" id="fundsummary_second" method="get" prompt="市"/>
                    &nbsp;
                    <input type="text" class="easyui-combobox" data-options="valueField:'unitCode',textField:'unitName'"
                           name="third" id="fundsummary_third" method="get" prompt="县区"/>
                </div>
                <a class="easyui-linkbutton btn-search" iconCls="icon-search"><p id="e@btn.search">搜索</p></a>
                <input type="hidden" id="fundsummary_roleCode">
                <a class="warnSelf">说明：19年统计数据包括了18年的数据。宿迁市湖滨新区数据统一汇总到宿豫区，经济开发区和洋河新区数据统一汇总到宿城区。盐城市经济开发区和盐南高新区数据统一汇总到亭湖区。</a>
            </form>
        </div>
    </div>

    <div data-options="region:'center'" border="false" style="padding: 4px;">
        <table idField="id" treeField="text" url="${ctx}service/sjcj/fundsummary" id="fundsummary_table"
               toolbar=".temp-toolbar" layoutH="0" pagination="false" search=".search">
            <thead>
            <tr>
                <th data-options="field:'status',align:'center'" rowspan="2" format="Dictionary:FUNDSUMSTATUS">状态</th>
                <th data-options="field:'unitName',align:'center'" rowspan="2">县（市、区）</th>
                <th colspan="6">结算年度内完成改善人口（人）</th>
                <th colspan="4">农房建筑面积（万㎡）</th>
                <th colspan="4">公共服务设施建筑面积（万㎡）</th>
                <th colspan="4">基础设施实际投入额（万元）</th>
                <th colspan="4">公共服务设施实际投入额（万元）</th>
            </tr>
            <tr>
                <th data-options="field:'t1',align:'center',formatter:rkFormatAll">小计</th>
                <th data-options="field:'t2',align:'center',formatter:rkFormatJc">进城购房<br>改善</th>
                <th data-options="field:'t3',align:'center',formatter:rkFormatRz">入镇购房<br>改善</th>
                <th data-options="field:'t4',align:'center',formatter:rkFormatNcsq">新型农村<br>社区改善</th>
                <th data-options="field:'t5',align:'center',formatter:rkFormatCzaz">小城镇集<br>中安置区<br>改善</th>
                <th data-options="field:'t6',align:'center',formatter:rkFormatXj">规划发展<br>村庄就地<br>新建翻建<br>改善</th>

                <th data-options="field:'t7',align:'center',formatter:mjFormatAll">小计</th>
                <th data-options="field:'t8',align:'center',formatter:mjFormatNcsq">新型农村<br>社区</th>
                <th data-options="field:'t9',align:'center',formatter:mjFormatCzaz">小城镇集<br>中安置区</th>
                <th data-options="field:'t10',align:'center',formatter:mjFormatXj">规划发展<br>村庄新建<br>翻建</th>

                <th data-options="field:'t11',align:'center',formatter:ggFormatAll">小计</th>
                <th data-options="field:'t12',align:'center',formatter:ggFormatNcsq">新型农村<br>社区</th>
                <th data-options="field:'t13',align:'center',formatter:ggFormatCzaz">小城镇集<br>中安置区</th>
                <th data-options="field:'t14',align:'center',formatter:ggFormatXj">规划发展<br>村庄新建<br>翻建</th>

                <th data-options="field:'t15',align:'center',formatter:jcFormatAll">小计</th>
                <th data-options="field:'t16',align:'center',formatter:jcFormatNcsq">新型农村<br>社区</th>
                <th data-options="field:'t17',align:'center',formatter:jcFormatCzaz">小城镇集<br>中安置区</th>
                <th data-options="field:'t18',align:'center',formatter:jcFormattXj">规划发展<br>村庄新建<br>翻建</th>

                <th data-options="field:'t19',align:'center',formatter:ggFormatAll">小计</th>
                <th data-options="field:'t20',align:'center',formatter:ggFormatNcsq">新型农村<br>社区</th>
                <th data-options="field:'t21',align:'center',formatter:ggFormatCzaz">小城镇集<br>中安置区</th>
                <th data-options="field:'t22',align:'center',formatter:ggFormatXj">规划发展<br>村庄新建<br>翻建</th>
            </tr>
            </thead>
        </table>

        <div class="temp-toolbar">
            <a iconCls="icon-edit" trigger="single" id="fundsummary_tj_btn"
               target="confirm" rel="fundsummary_tj" title="是否确定提交？">提交</a>
            <hr>
            <a iconCls="icon-base icon-sl" trigger="single" id="fundsummary_sl_btn"
               target="confirm" rel="fundsummary_opinion_sl" title="是否确定受理？">受理</a>
            <hr>
   <%--         <a iconCls="icon-base icon-th" trigger="single" id="fundsummary_th_btn"
               target="confirm" rel="fundsummary_opinion_th" title="是否确定退回？">退回</a>
            <hr>--%>

            <a iconCls="icon-edit" href="modules/sjcj/fundsummary/fundsummary-opinion.jsp" trigger="single" id="fundsummary_th_btn"
               target="dialog" rel="fundsummary_opinion_th" title="退回 {{text}}" width="500" height="400"  buttons="[{method:'submit',text:'退回'}]" >退回</a>
            <hr>
            <a iconCls="icon-edit" href="modules/sjcj/fundsummary/fundsummary-view.jsp" trigger="single"
               target="dialog" rel="fundsummary_view" title="查看  " width="1300" height="700" btnValue="查看">查看</a>
            <hr>
            <%--<a iconCls="icon-base icon-sl" trigger="single"
               href="modules/sjcj/fundsummary/fundsummary-opinion.jsp"
               target="dialog" rel="fundsummary_opinion_sl" title="受理  {{unitName}}" width="550" height="300"
               id="fundsummary_sl_btn">受理</a>
            <hr>
            <a iconCls="icon-base icon-th" trigger="single"
               href="modules/sjcj/fundsummary/fundsummary-opinion.jsp"
               target="dialog" rel="fundsummary_opinion_th" title="退回 {{unitName}}" width="550" height="300"
               id="fundsummary_th_btn">退回</a>
            <hr>--%>
            <a iconCls="icon-redo" trigger="none" target="custom" rel="fundsummary_exp" id="fundsummary_exp_btn">导出</a>
        </div>

    </div>
</div>
<script>
    $.parser.onComplete = function (panel) {
        $.parser.onComplete = $.noop;
        requirejs([
            'modules/sjcj/fundsummary/ctrl/fundsummary', 'core/filter/filter.dictionary'
        ], function (Fundsummary, FilterDictionary) {
            FilterDictionary.add([
                'FUNDSUMSTATUS', 'BetterType']
            ).then(function () {
                window.Fundsummary = new Fundsummary('fundsummary', panel);
                window.Fundsummary.load(panel);
            });

        });
    };
</script>
