define(function(require) {
    var Config = require('config');
    var Core = require('core/core');
    var Page = require('core/page');
    var Dialog = require('centit/centit.dialog');
    
    var FundsummarySl = require('./fundsummary.opinion.sl');
    var FundsummaryTh = require('./fundsummary.opinion.th');
    var FundsummaryTj = require('./fundsummary.opinion.tj');
    var FundsummaryExp = require('./fundsummary.exp');
    var FundsummaryView = require('./fundsummary.view');

    var _self;
    //人口弹框
    this.rkFormatAll = function (value,row) {
        var content = value;
        if (value != undefined && value != '0.00' && value != 0) {
            content = '<a  href="#" style="color:blue;" onclick="openWindow(\''+row.year+'\',\'' + row.unitCode + '\',\'nf\',\'rk\',\'all\',' + value + ')">' +value + '</a>';
        }
        return content;
    }
    this.rkFormatJc = function (value,row) {
        var content = value;
        if (value != undefined && value != '0.00' && value != 0) {
            content = '<a  href="#" style="color:blue;" onclick="openWindow(\''+row.year+'\',\'' + row.unitCode + '\',\'nf\',\'rk\',\'jc\',' + value + ')">' +value + '</a>';
        }
        return content;
    }
    this.rkFormatRz = function (value,row) {
        var content = value;
        if (value != undefined && value != '0.00' && value != 0) {
            content = '<a  href="#" style="color:blue;" onclick="openWindow(\''+row.year+'\',\'' + row.unitCode + '\',\'nf\',\'rk\',\'rz\',' + value + ')">' +value + '</a>';
        }
        return content;
    }
    this.rkFormatNcsq = function (value,row) {
        var content = value;
        if (value != undefined && value != '0.00' && value != 0) {
            content = '<a  href="#" style="color:blue;" onclick="openWindow(\''+row.year+'\',\'' + row.unitCode + '\',\'nf\',\'rk\',\'ncsq\',' + value + ')">' +value + '</a>';
        }
        return content;
    }
    this.rkFormatCzaz = function (value,row) {
        var content = value;
        if (value != undefined && value != '0.00' && value != 0) {
            content = '<a  href="#" style="color:blue;" onclick="openWindow(\''+row.year+'\',\'' + row.unitCode + '\',\'nf\',\'rk\',\'czaz\',' + value + ')">' +value + '</a>';
        }
        return content;
    }
    this.rkFormatXj = function (value,row) {
        var content = value;
        if (value != undefined && value != '0.00' && value != 0) {
            content = '<a  href="#" style="color:blue;" onclick="openWindow(\''+row.year+'\',\'' + row.unitCode + '\',\'nf\',\'rk\',\'xj\',' + value + ')">' +value + '</a>';
        }
        return content;
    }
    //农房面积弹框
    this.mjFormatAll = function (value,row) {
        var content = value;
        if (value != undefined && value != '0.00' && value != 0) {
            content = '<a  href="#" style="color:blue;" onclick="openWindow(\''+row.year+'\',\'' + row.unitCode + '\',\'nf\',\'mj\',\'all\',' + value + ')">' +value + '</a>';
        }
        return content;
    }
    this.mjFormatNcsq = function (value,row) {
        var content = value;
        if (value != undefined && value != '0.00' && value != 0) {
            content = '<a  href="#" style="color:blue;" onclick="openWindow(\''+row.year+'\',\'' + row.unitCode + '\',\'nf\',\'mj\',\'ncsq\',' + value + ')">' +value + '</a>';
        }
        return content;
    }
    this.mjFormatCzaz = function (value,row) {
        var content = value;
        if (value != undefined && value != '0.00' && value != 0) {
            content = '<a  href="#" style="color:blue;" onclick="openWindow(\''+row.year+'\',\'' + row.unitCode + '\',\'nf\',\'mj\',\'czaz\',' + value + ')">' +value + '</a>';
        }
        return content;
    }
    this.mjFormatXj = function (value,row) {
        var content = value;
        if (value != undefined && value != '0.00' && value != 0) {
            content = '<a  href="#" style="color:blue;" onclick="openWindow(\''+row.year+'\',\'' + row.unitCode + '\',\'nf\',\'mj\',\'xj\',' + value + ')">' +value + '</a>';
        }
        return content;
    }
    //公共设施
    this.ggFormatAll = function (value,row) {
        var content = value;
        if (value != undefined && value != '0.00' && value != 0) {
            content = '<a  href="#" style="color:blue;" onclick="openWindow(\''+row.year+'\',\'' + row.unitCode + '\',\'ss\',\'gg\',\'all\',' + value + ')">' +value + '</a>';
        }
        return content;
    }
    this.ggFormatNcsq = function (value,row) {
        var content = value;
        if (value != undefined && value != '0.00' && value != 0) {
            content = '<a  href="#" style="color:blue;" onclick="openWindow(\''+row.year+'\',\'' + row.unitCode + '\',\'ss\',\'gg\',\'ncsq\',' + value + ')">' +value + '</a>';
        }
        return content;
    }
    this.ggFormatCzaz = function (value,row) {
        var content = value;
        if (value != undefined && value != '0.00' && value != 0) {
            content = '<a  href="#" style="color:blue;" onclick="openWindow(\''+row.year+'\',\'' + row.unitCode + '\',\'ss\',\'gg\',\'czaz\',' + value + ')">' +value + '</a>';
        }
        return content;
    }
    this.ggFormatXj = function (value,row) {
        var content = value;
        if (value != undefined && value != '0.00' && value != 0) {
            content = '<a  href="#" style="color:blue;" onclick="openWindow(\''+row.year+'\',\'' + row.unitCode + '\',\'ss\',\'gg\',\'xj\',' + value + ')">' +value + '</a>';
        }
        return content;
    }
    //基础设施
    this.jcFormatAll = function (value,row) {
        var content = value;
        if (value != undefined && value != '0.00' && value != 0) {
            content = '<a  href="#" style="color:blue;" onclick="openWindow(\''+row.year+'\',\'' + row.unitCode + '\',\'ss\',\'jc\',\'all\',' + value + ')">' +value + '</a>';
        }
        return content;
    }
    this.jcFormatNcsq = function (value,row) {
        var content = value;
        if (value != undefined && value != '0.00' && value != 0) {
            content = '<a  href="#" style="color:blue;" onclick="openWindow(\''+row.year+'\',\'' + row.unitCode + '\',\'ss\',\'jc\',\'ncsq\',' + value + ')">' +value + '</a>';
        }
        return content;
    }
    this.jcFormatCzaz = function (value,row) {
        var content = value;
        if (value != undefined && value != '0.00' && value != 0) {
            content = '<a  href="#" style="color:blue;" onclick="openWindow(\''+row.year+'\',\'' + row.unitCode + '\',\'ss\',\'jc\',\'czaz\',' + value + ')">' +value + '</a>';
        }
        return content;
    }
    this.jcFormattXj = function (value,row) {
        var content = value;
        if (value != undefined && value != '0.00' && value != 0) {
            content = '<a  href="#" style="color:blue;" onclick="openWindow(\''+row.year+'\',\'' + row.unitCode + '\',\'ss\',\'jc\',\'xj\',' + value + ')">' +value + '</a>';
        }
        return content;
    }
    this.openWindow = function (year,unitCode,type1,type2,type3,value) {
        if(type1 == "nf"){//农房
            var bettertypes = null;
            if(type2 == "rk" && type3 == "all"){
                bettertypes = "12345";
            } else if( type3 == "jc"){
                bettertypes = "1";
            } else if( type3 == "rz"){
                bettertypes = "2";
            } else if( type3 == "ncsq"){
                bettertypes = "3";
            } else if( type3 == "czaz"){
                bettertypes = "5";
            } else if( type3 == "xj"){
                bettertypes = "4";
            } else if( type2 == "mj" && type3 == "all"){
                bettertypes = "345";
            }
            var SelectUser = require('modules/sjcj/farmhousejbxx/ctrl/farmhousejbxxDetail');
            var _SelectUser = new SelectUser("registerDetail");
            _self.controllers["registerDetail"] = _SelectUser;
            _SelectUser.parent = _self;
            var title = "农户详情(汇总数据："+(value)+")";
            var url = 'modules/sjcj/farmhousejbxx/farmhousejbxxDetail.jsp';
            var buttons = [{method: 'onClose', text: '关闭'}];
            var dialogId = "_sfzcwxx";
            Dialog.open({
                id: dialogId,
                title: title,
                href: url,
                width: 1250,
                height: 600,
                buttons: buttons
            }, {unitCode: unitCode, bettertype: bettertypes,year:year}, _self.controllers["registerDetail"]);
        } else if(type1 == "ss"){//设施
            var ftype = type2;
            var relation = null;
            var htype = null;
            if(type3 == "ncsq"){
                relation = "1";
                htype = "3";
            } else if(type3 == "czaz"){
                relation = "2";
                htype = "5";
            } else if(type3 == "xj"){
                relation = "3";
            }
            var SelectUser = require('modules/sjcj/facility/ctrl/facilityDetail');
            var _SelectUser = new SelectUser("registerDetail");
            _self.controllers["registerDetail"] = _SelectUser;
            _SelectUser.parent = _self;
            var title = "设施详情(汇总数据："+(value)+")";
            var url = 'modules/sjcj/facility/facilityDetail.jsp';
            var buttons = [{method: 'onClose', text: '关闭'}];
            var dialogId = "_sfzcwxx";
            Dialog.open({
                id: dialogId,
                title: title,
                href: url,
                width: 1250,
                height: 600,
                buttons: buttons
            }, {unitCode: unitCode, year:year,ftype: ftype,relation: relation,htype: htype}, _self.controllers["registerDetail"]);
        }
    }


    // 业务信息
    var Fundsummary = Page.extend(function() {
    	
    	this.injecte([
          new FundsummarySl('fundsummary_opinion_sl'),
          new FundsummaryTh('fundsummary_opinion_th'),
          new FundsummaryTj('fundsummary_tj'),
            new FundsummaryExp('fundsummary_exp'),
            new FundsummaryView('fundsummary_view'),
    	]);

    	// @override
    	this.load = function(panel) {
    	    _self = this;
            this.$autoHeight('north', $('#fundsummary-info-main', panel));
            var table = this.table = panel.find('table');
            table.cdatagrid({
                controller: this
            });

            //根据权限设置操作按钮
            Core.ajax(Config.ContextPath+'service/common/getLoginUserRoles', {
                method: 'get'
            }).then(function(rlt) {
                //0013-镇，0012-县区，0011-市，0010-省
                var roleCode;
                for(var i = 0 ; i < rlt.length ; i++){
                    if(rlt[i].roleCode == '0010'){
                        roleCode = rlt[i].roleCode;
                        break;
                    } else if(rlt[i].roleCode == '0011'){
                        roleCode = rlt[i].roleCode;
                        break;
                    } else if(rlt[i].roleCode == '0012'){
                        roleCode = rlt[i].roleCode;
                        break;
                    } else if(rlt[i].roleCode == '0013'){
                        roleCode = rlt[i].roleCode;
                        break;
                    }
                }
                panel.find("#fundsummary_roleCode").val(roleCode);
                if(roleCode == "0012"){
                    panel.find('#fundsummary_sl_btn').parent('td').next().remove();
                    panel.find('#fundsummary_sl_btn, #fundsummary_sl_btn + hr', panel).remove();
                    panel.find('#fundsummary_th_btn').parent('td').next().remove();
                    panel.find('#fundsummary_th_btn, #fundsummary_th_btn + hr', panel).remove();
                } else if(roleCode == "0010"){
                    panel.find('#fundsummary_tj_btn').parent('td').next().remove();
                    panel.find('#fundsummary_tj_btn, #fundsummary_tj_btn + hr', panel).remove();
                } else if(roleCode == "0011"){
                    panel.find('#fundsummary_sl_btn').parent('td').next().remove();
                    panel.find('#fundsummary_sl_btn, #fundsummary_sl_btn + hr', panel).remove();
                }

            });

            //行政区划初始化
            panel.find('#fundsummary_second').combobox({
                url: Config.ContextPath + "service/userinfo2/getUnitsByLoginAndUnitCode/2/320000000000",
                valueField: 'unitCode',
                textField: 'unitName',
                onLoadSuccess: function (list) {
                    if(list != null && list.length == 1){
                        $('#fundsummary_second').combobox('select', list[0]["unitCode"]);
                        panel.find('#fundsummary_third').combobox({
                            url: Config.ContextPath + "service/userinfo2/getUnitsByLoginAndUnitCode/3/"+list[0]["unitCode"] ,
                            valueField: 'unitCode',
                            textField: 'unitName',
                            onLoadSuccess: function (list2) {
                                if(list2 != null && list2.length == 1){
                                    $('#fundsummary_third').combobox('select', list2[0]["unitCode"]);
                                }
                            }
                        });
                    }
                }
            });

            //行政区划联动
            panel.find('#fundsummary_second').combobox({
                onChange: function(newValue,oldValue) {
                    panel.find('#fundsummary_third').combobox('clear');
                    panel.find('#fundsummary_fourth').combobox('clear');
                    // 重新获取数据
                    if(newValue != null){
                        panel.find('#fundsummary_third').combobox('reload', Config.ContextPath + "service/userinfo2/getUnitsByLoginAndUnitCode/3/"+newValue);
                    }
                }
            });
    	};







        function _createDataList(table, data) {
            table.cdatagrid({
                controller : _self,
            }).datagrid('loadData', data);
        };
    	
    });

    return Fundsummary;
});