define(function(require) {
	var Config = require('config');
	var Core = require('core/core');
	var FarmhousereturnlistAdd = require('./farmhousereturnlist.add');

	var FarmhousereturnlistEdit = FarmhousereturnlistAdd.extend(function() {
		var _self;
		
		// @override
		this.load = function(panel, data) {
			_self = this;
			var form = panel.find('form');
			
			Core.ajax(Config.ContextPath+'service/facility/farmhousereturnlist/'+data.friid, {
				type: 'json',
				method: 'get' 
			}).then(function(data) {
				_self.data = data;
				
				form.form('load', data)
					.form('disableValidation')
					.form('readonly', 'friid')
					.form('focus');
			});
		};
		
		// @override
		this.submit = function(panel, data, closeCallback) {
			var form = panel.find('form');
			
			// 开启校验
			form.form('enableValidation');
			var isValid = form.form('validate');
			
			if (isValid) {
				form.form('ajax', {
					url: Config.ContextPath + 'service/facility/farmhousereturnlist/' + data.friid,
					method: 'put',
					data: data 
				}).then(closeCallback);
			}

			return false;
		};
		
		// @override
		this.onClose = function(table) {
			table.datagrid('reload');
		};
	});

	return FarmhousereturnlistEdit;
});