define(function(require) {
	var Config = require('config');
	var Page = require('core/page');
	var Core = require('core/core');

	var FarmhousereturnlistAdd = Page.extend(function() {
		var _self;
		var _table;
		var fryear;
		var frtype;
		var frid;
		// @override
		this.load = function(panel, data) {
			_self = this;
			fryear = _self.parent.panel.find("#farmhousereturn_edit_fryear").val();
			frtype = _self.parent.panel.find("#farmhousereturn_edit_frtype").val();
			frid = _self.parent.panel.find("#farmhousereturn_edit_frid").val();
			var frtypestr = null;
			if(frtype == 0){
				frtypestr = "删除";
			} else if(frtype == 1){
				frtypestr = "退回计划中";
			}
			panel.siblings("div").eq(0).find(".panel-title").text("添加需要“" + frtypestr + "的农户”");
			var form = panel.find('form');
			// 
			form.form('disableValidation')
			.form('focus');

			_table = panel.find('table');
			_table.cdatagrid({
				controller: _self,
			});

			// 行政村、自然村、表单联动
			panel.find('#farmhousereturnlist_administrativevillage').combobox({//行政村
				onChange: function (newValue, oldValue) {
					panel.find('#farmhousereturnlist_vid').combobox("clear");
					if (newValue != null && newValue != ''){
						panel.find('#farmhousereturnlist_vid').combobox('reload', Config.ContextPath + 'service/sjcj/villagejbxx/list2?administrativevillage=' + newValue);
					}
				}
			});


			//查询列表
			panel.off('click', '#farmhousereturnlist_search_btn');
			panel.find('#farmhousereturnlist_search_btn').click(function () {
				var url = Config.ContextPath+'service/sjcj/farmhousejbxx/list2?isbetters=S&realityyear=' + fryear;
				var administrativevillage = _self.panel.find('#farmhousereturnlist_administrativevillage').val();
				var vid = _self.panel.find('#farmhousereturnlist_vid').val();
				var fname = _self.panel.find('#farmhousereturnlist_fname').val();
				if(administrativevillage == null || administrativevillage == ''){
					$.messager.alert('提醒', '请先选择行政村！','warning');
				} else {
					url += "&administrativevillage=" + administrativevillage;
					if(vid != null && vid.length > 0){
						url += "&vid=" + vid;
					}
					if(fname != null && fname.length > 0){
						url += "&fname=" + fname;
					}
					_table.cdatagrid({
						controller: _self,
						url:url,
					});
				}

			});

		};
		
		// @override
		this.submit = function(panel, data, closeCallback) {
			var table = panel.find('#farmhousereturnlist_table');
			var rows = table.datagrid('getSelections');
			if(rows == null || rows.length < 1){
				$.messager.alert('提醒', '未勾选农房信息！','warning');
				return false;
			}
			var json = JSON.stringify(rows);
			Core.ajax(Config.ContextPath+'service/facility/farmhousereturnlist/addFarmhousereturnlists/' + frid, {
				type: 'json',
				method: 'post',
				traditional: true,
				data:{"json":json},
			}).then(function(rlt){
				$.messager.alert('提醒', '添加农户总数：' + rlt.total
					            + '<br>新增农户数：' + rlt.suAdd
				                + '<br>重复农户更新：' + rlt.suUpdate
				                + '<br>添加异常农户数：' + rlt.lose);
				closeCallback();
			});
			return false;
		};
		
		// @override 
		this.onClose = function(table, data) {
			table.datagrid('reload');
		};
	});
	
	return FarmhousereturnlistAdd;
});