<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<div class="easyui-layout" data-options="fit:true">
	<div data-options="region:'center'" border="false" style="padding: 4px;">
		<div class="easyui-layout" fit="true" id="farmhousereturn-info-main">
			<div region="north" class="search-body" cls="search" style="height: auto;">
				<form class="clearFromValue" id="farmhousereturn_search_form">
					<div class="search-item">
						<label>行政区划</label>
						<input type="text" class="easyui-combobox" data-options="valueField:'unitCode',textField:'unitName'" name="second" id="fr_second" method="get" prompt="市"/>
						&nbsp;
						<input type="text" class="easyui-combobox" data-options="valueField:'unitCode',textField:'unitName'" name="third" id="fr_third" method="get" prompt="县区"/>
						&nbsp;
						<input type="text" class="easyui-combobox" data-options="valueField:'unitCode',textField:'unitName'" name="fourth" id="fr_fourth" method="get" prompt="镇"/>
					</div>
					<div class="search-item">
						<label>状态</label>
						<input class="easyui-combobox" name="status" style="width: 120px" id="farmhousereturn_status"
							   target="dictionary"
							   key="sjcjStatusType"/>
					</div>

					<div class="search-item">
						<label>改善年份</label>
						<input type="text" class="easyui-combobox" name="fryear" style="width: 80px"
							   url="service/common/getYearList/2" method="get"
							   data-options="valueField:'year',textField:'year'"/>
					</div>
					<div style="display: none">
						<input type="text" name="reSearch" value="reSearch">
					</div>

					<a class="easyui-linkbutton btn-search" iconCls="icon-search" id="farmhousereturn_search">查询</a>
					<br>
					<a class="warnSelf" id="farmhousereturn_tx">
						&nbsp;<br>
						&nbsp;<br>
						&nbsp;<br>
						&nbsp;<br>
					</a>
				</form>
			</div>

			<div region="center" border="false" style="padding: 4px; height: 100%">
				<table
					   idField="id"
					   treeField="text"
					   rownumbers="false"
					   search=".search"
					   sortName="updatetime"
					   sortOrder="desc"
					   toolbar=".temp-toolbar"
					   layoutH="0">
					<thead>
					<tr>
						<th data-options="field:'statusName'" width="10%" align="center" >状态</th>
						<th data-options="field:'fryear'" width="10%" align="center" >改善年份</th>
						<th data-options="field:'userName'" width="10%" align="center" >申请人</th>
						<th data-options="field:'num'" width="10%" align="center" >农户数</th>
						<th data-options="field:'unitCodeName'"  width="25%" align="center" >行政区划</th>
						<th data-options="field:'createtime'" width="15%" align="center" >申请时间</th>
						<th data-options="field:'updatetime'" width="15%" align="center" >更新时间</th>
					</tr>
					</thead>
				</table>
				<div class="temp-toolbar">
					<a iconCls="icon-add" href="modules/sjcj/farmhousereturn/farmhousereturn-info.jsp" trigger="none" id="farmhousereturn_add_btn"
					   target="dialog" rel="farmhousereturn_add" title="新增申请表" width="350" height="300" btnValue="添加">1.新增申请单</a>
					<hr>

					<a iconCls="icon-edit" href="modules/sjcj/farmhousereturn/farmhousereturn-edit.jsp?vtype=edit" trigger="single" id="farmhousereturn_edit_btn"
					   target="dialog" rel="farmhousereturn_edit" title="添加农户清单并提交(年份：{{fryear}}，行政区划：{{unitCodeName}})" width="1300" height="600"
					   buttons="[{method:'submit',text:'暂存并退出'},{method:'submitTj',text:'确认并提交'}]" >2.添加农户清单并提交</a>
					<hr>

					<a iconCls="icon-edit" href="modules/sjcj/farmhousereturn/farmhousereturn-edit.jsp?vtype=check" trigger="single" id="farmhousereturn_check_btn"
					   target="dialog" rel="farmhousereturn_check" title="查看（年份：{{fryear}}，申请人：{{userName}}）" width="1300" height="600"
					   buttons="[{method:'submitSl',text:'受理'},{method:'submitTh',text:'退回'}]">2.审核</a>
					<hr>

					<a iconCls="icon-edit" href="modules/sjcj/farmhousereturn/farmhousereturn-edit.jsp?vtype=view" trigger="single" id="farmhousereturn_view_btn"
					   target="dialog" rel="farmhousereturn_view" title="查看（年份：{{fryear}}，申请人：{{userName}}）" width="1300" height="600"
					   buttons="[{method:'submit',text:'关闭'}]">3.查看</a>
					<hr>

					<a iconCls="icon-base icon-base-ban" trigger="single" id="farmhousereturn_remove_btn"
					   target="confirm" rel="farmhousereturn_remove" title="是否确定删除申请单(年份：{{fryear}}，行政区划：{{unitCodeName}})？">4.删除</a>
				</div>
				<%--隐藏信息值--%>
				<div style="display: none">
					<input id="farmhousereturn_frtype" >
					<input id="farmhousereturn_role" >
				</div>
			</div>
		</div>
	</div>
</div>


<script>
	$.parser.onComplete = function(panel) {
		$.parser.onComplete = $.noop;
		var frtype = '<%=request.getParameter("frtype")%>';
		/*requirejs([
			'modules/sjcj/farmhousereturn/ctrl/farmhousereturn'
		], function(Farmhousereturn) {
			window.Farmhousereturn = new Farmhousereturn('farmhousereturn', panel);
			window.Farmhousereturn.load(panel,frtype);
		});*/
		requirejs([
					'core/filter/filter.dictionary',
					'modules/sjcj/farmhousereturn/ctrl/farmhousereturn',
					'css!plugins/viewer/viewer.min.css'],
				function (FilterDictionary, Farmhousereturn) {
					FilterDictionary.add([
						'PersonType', 'BetterType', 'isBetter', 'HouseType','housingStructure','sjcjStatusType']
					).then(function () {
						window.Farmhousereturn = new Farmhousereturn('farmhousereturn', panel);
						window.Farmhousereturn.load(panel,frtype);
					});
				});

	};
</script>
