define(function(require) {
	var Config = require('config');
	var Core = require('core/core');
	var Page = require('core/page');
	
	// 删除数据字典
	var FarmhousereturnRemove = Page.extend(function() {
		//设置可操作权限
		this.renderButton = function (btn, data) {
			var flag = false;
			var role = this.parent.panel.find("#farmhousereturn_role").val();
			if(role == "sysadmin"){
				flag = true;
			} else if((data.status == "01" || data.status == "04") && data.num < 1){
				flag = true;
			}
			return flag;
		};
		// @override
		this.submit = function(table, data) {
			Core.ajax(Config.ContextPath+'service/facility/farmhousereturn/'+data.frid, {
            	type: 'json',
                method: 'post',
                data: {
                    _method: 'delete'
                }
			}).then(function(rlt) {
				if(rlt.isOk){
					$.messager.alert('提醒', '删除成功！');
				} else {
					$.messager.alert('提醒', rlt.msg);
				}

				table.datagrid('reload');
            });
		}
	});
	
	return FarmhousereturnRemove;
});