define(function(require) {
    var Config = require('config');
    var Core = require('core/core');
    var Page = require('core/page');

    
    var FarmhousereturnAdd = require('./farmhousereturn.add');
    var FarmhousereturnEdit = require('./farmhousereturn.edit');
    var FarmhousereturnRemove = require('./farmhousereturn.remove');

    // 业务信息
    var Farmhousereturn = Page.extend(function() {
    	
    	this.injecte([
          new FarmhousereturnAdd('farmhousereturn_add'),
          new FarmhousereturnEdit('farmhousereturn_edit'),
          new FarmhousereturnEdit('farmhousereturn_view'),
          new FarmhousereturnEdit('farmhousereturn_check'),
          new FarmhousereturnRemove('farmhousereturn_remove')
    	]);
    	var _self;
    	// @override
    	this.load = function(panel,frtype) {
    	    _self = this;
            panel.find("#farmhousereturn_frtype").val(frtype);
    		var table = this.table = panel.find('table');

    		table.cdatagrid({
    			controller: this,
    		});
    		var frtypestr = null;
    		if(frtype == 0){
                frtypestr = "删除";
            } else if(frtype == 1){
    		    frtypestr = "退回计划中";
            }
    		var  htmlstr = "说明：此模块为确认改善农户" + frtypestr + "模块，针对确认改善的农户，如想" + frtypestr +"，可由镇级用户新增申请表，添加需要" + frtypestr +
                "的农户后提交，再由县区、市、省审核通过后系统自动将农户批量" + frtypestr +
                "<br>第一步：新增申请表；<br>" +
                "第二步：添加农户清单并提交（此处还需上传已盖章的申请文件，请写明申请数据变更的详细原因、申请变更的农户总数、申请单位信息等）<br>" +
                "第三步：县区、市、省逐级审核，省审核通过后状态为“已生效”，表示申请表中农户数据已被" + frtypestr;
            panel.find("#farmhousereturn_tx").html(htmlstr);
            this.$autoHeight('north', panel.find('#farmhousereturn-info-main', panel));

            //行政区划初始化
            panel.find('#fr_second').combobox({
                url: Config.ContextPath + "service/userinfo2/getUnitsByLoginAndUnitCode/2/320000000000",
                valueField: 'unitCode',
                textField: 'unitName',
                onLoadSuccess: function (list) {
                    if(list != null && list.length == 1){
                        $('#fr_second').combobox('select', list[0]["unitCode"]);
                        panel.find('#fr_third').combobox({
                            url: Config.ContextPath + "service/userinfo2/getUnitsByLoginAndUnitCode/3/"+list[0]["unitCode"] ,
                            valueField: 'unitCode',
                            textField: 'unitName',
                            onLoadSuccess: function (list2) {
                                if(list2 != null && list2.length == 1){
                                    $('#fr_third').combobox('select', list2[0]["unitCode"]);
                                    panel.find('#fr_fourth').combobox({
                                        url: Config.ContextPath + "service/userinfo2/getUnitsByLoginAndUnitCode/4/"+list2[0]["unitCode"] ,
                                        valueField: 'unitCode',
                                        textField: 'unitName',
                                        onLoadSuccess: function (list3) {
                                            if(list3 != null && list3.length == 1){
                                                $('#fr_fourth').combobox('select', list3[0]["unitCode"]);
                                            }
                                        }
                                    });
                                }
                            }
                        });
                    }
                }
            });

            //行政区划联动
            panel.find('#fr_second').combobox({
                onChange: function(newValue,oldValue) {
                    panel.find('#fr_third').combobox('clear');
                    panel.find('#fr_fourth').combobox('clear');
                    // 重新获取数据
                    if(newValue != null){
                        panel.find('#fr_third').combobox('reload', Config.ContextPath + "service/userinfo2/getUnitsByLoginAndUnitCode/3/"+newValue);
                    }
                }
            });
            //行政区划联动
            panel.find('#fr_third').combobox({
                onChange: function(newValue,oldValue) {
                    panel.find('#fr_fourth').combobox('clear');
                    // 重新获取数据
                    if(newValue != null){
                        panel.find('#fr_fourth').combobox('reload', Config.ContextPath + "service/userinfo2/getUnitsByLoginAndUnitCode/4/"+newValue);
                    }
                }
            });

            //根据权限设置操作按钮
            Core.ajax(Config.ContextPath+'service/common/getLoginUserMainRole', {
                method: 'get'
            }).then(function(role) {
                //["sysadmin","0010","0011","0012","0013","0015"];//管理员、省、市、县区、镇、审计
                panel.find("#farmhousereturn_role").val(role);
                //初始化为代办状态，模拟点击“查询”按钮
                var status = null;
                if(role == "0012"){
                    status = "02";
                } else if(role == "0011"){
                    status = "06";
                } else if(role == "0010" || role == "sysadmin"){
                    status = "07";
                }
                _self.panel.find('#farmhousereturn_status').combobox('select', status);
                var url = "service/facility/farmhousereturn?frtype=" + frtype;
                if(status != null){
                    url += "&intStatus=" + status;
                }
                table.cdatagrid({
                    controller: this,
                    url: url,
                    rowStyler:function (index,rowData){
                        if((role == "0013" && (rowData.status == "01" || rowData.status == "04"))
                           || (role == "0012" && rowData.status == "02")
                           || (role == "0011" && rowData.status == "06")
                           || ((role == "0010" || role == "sysadmin") && rowData.status == "07")){
                            return 'color:#EE2C2C';
                        }
                        if(rowData.status == "05"){//已生效
                            return 'color:#224b8f';
                        }
                    },
                });

                if(role == "sysadmin"){
                    panel.find("#farmhousereturn_add_btn").parent("td").next().remove();
                    panel.find("#farmhousereturn_add_btn").remove();
                    panel.find("#farmhousereturn_edit_btn").parent("td").next().remove();
                    panel.find("#farmhousereturn_edit_btn").remove();
                } else if(role == "0010" || role == "0011" || role == "0012"){
                    panel.find("#farmhousereturn_add_btn").parent("td").next().remove();
                    panel.find("#farmhousereturn_add_btn").remove();
                    panel.find("#farmhousereturn_edit_btn").parent("td").next().remove();
                    panel.find("#farmhousereturn_edit_btn").remove();
                    panel.find("#farmhousereturn_remove_btn").parent("td").next().remove();
                    panel.find("#farmhousereturn_remove_btn").remove();
                } else if(role == "0013"){
                    panel.find("#farmhousereturn_check_btn").parent("td").next().remove();
                    panel.find("#farmhousereturn_check_btn").remove();
                } else {
                    panel.find("#farmhousereturn_add_btn").parent("td").next().remove();
                    panel.find("#farmhousereturn_add_btn").remove();
                    panel.find("#farmhousereturn_edit_btn").parent("td").next().remove();
                    panel.find("#farmhousereturn_edit_btn").remove();
                    panel.find("#farmhousereturn_check_btn").parent("td").next().remove();
                    panel.find("#farmhousereturn_check_btn").remove();
                    panel.find("#farmhousereturn_remove_btn").parent("td").next().remove();
                    panel.find("#farmhousereturn_remove_btn").remove();
                }
            });
    	};
    	
    });

    return Farmhousereturn;
});