define(function(require) {
	var Config = require('config');
	var Core = require('core/core');
	var Dialog = require('centit/centit.dialog');
	var ajaxSubmit = require('plugins/jquery.form');
	var FarmhousereturnAdd = require('./farmhousereturn.add');

	var FarmhousereturnlistAdd = require('modules/sjcj/farmhousereturnlist/ctrl/farmhousereturnlist.add');
	var FarmhousereturnlistRemove = require('modules/sjcj/farmhousereturnlist/ctrl/farmhousereturnlist.remove');


	var FarmhousereturnEdit = FarmhousereturnAdd.extend(function() {

		this.injecte([
			new FarmhousereturnlistAdd('farmhousereturnlist_add'),
			new FarmhousereturnlistRemove('farmhousereturnlist_remove')
		]);


		var _self = this;
		var frtype;//类别：退回/删除

		//设置可操作权限
		this.renderButton = function (btn, data) {
			var flag = false;
            var rel = this.id;
            if(rel == "farmhousereturn_edit"){
            	if(data.status == "01" || data.status == "04"){
            		flag = true;
				}
			} else if(rel == "farmhousereturn_view"){
            	flag = true;
			} else if(rel == "farmhousereturn_check"){
            	var role = this.parent.panel.find("#farmhousereturn_role").val();
            	if((role == "sysadmin" || role == "0010") && data.status == "07"){//管理员或省审核“市已受理”
            		flag = true;
				}
            	if(role == "0011" && data.status == "06"){//市审核“县区已受理”
					flag = true;
				}
            	if(role == "0012" && data.status == "02"){//县区审核“镇提交”
					flag = true;
				}
			}
			return flag;
		};

		// @override
		this.load = function(panel, data) {
			//农户列表初始化
			_self = this;
			var tablesub = panel.find('#farmhousereturnlist_table');
			var url = "service/facility/farmhousereturnlist?frid="+data.frid;
			tablesub.cdatagrid({
				controller: this,
				url:url,
			});
			//查看和审核界面隐藏可操作元素
			var vtype = panel.find("#farmhousereturn_edit_vtype").val();
			if(vtype != "edit"){
				panel.find("#farmhousereturn_edit_fjdiv").hide();
				panel.find("#farmhousereturnlist_add_btn").hide();
				panel.find("#farmhousereturnlist_remove_btn").hide();
			}


			var tableLc = panel.find("#farmhousereturn_edit_lc_table");
			tableLc.cdatagrid({
				controller: this,
				url:Config.ContextPath + 'service/utils/pmpWfRecord?s_wmodule=8&s_wid=' + data.frid,
			});

			//修改标题
			frtype = this.parent.panel.find("#farmhousereturn_frtype").val();
			panel.find("#farmhousereturn_edit_frtype").val(frtype);
			var frtypestr = null;
			if(frtype == 0){
				frtypestr = "农户删除";
			} else if(frtype == 1){
				frtypestr = "农户退回计划中";
			}
			var operation = "";
			if(vtype == "edit"){
				operation = "添加“" + frtypestr + "清单”并提交";
			} else if(vtype == "view"){
				operation = "查看“" + frtypestr + "申请单”详情";
			} else if(vtype == "check"){
				operation = "审核“" + frtypestr + "申请单”";
			}
			panel.siblings("div").eq(0).find(".panel-title").text(operation + "(改善年份:" + data.fryear +
				",行政区划:" + data.unitCodeName +",申请时间:" + data.createtime + ")");
			var form = panel.find('form');
			_self.data = data;
			form.form('load', data)
					.form('disableValidation')
					.form('readonly', 'frid')
					.form('focus');



			//加载已上传附件
			Core.ajax(Config.ContextPath+'service/attachment/getAttachments/3/'+data.frid, {
				type: 'json',
				method: 'get'
			}).then(function(resdata) {
				var list = resdata.fjlist;
				panel.find('#pcinfo_fj_div').empty();//其他家庭成员初始化清空
				var j = 0;
				if(list != null && list.length > 0){
					for(var i = 0; i < list.length ;i++){
						j = i+1;
						var obj = list[i];
						var container = panel.find('#farmhousereturn_fj_div');
						var html = '<a href="'+Config.ContextPath+'service/attachment/downloadFJ/'+obj.iid+'" style="color: blue;" id="tzgg_fj">'+j+'、'+obj.ename+'--'+obj.userName+'</a><br>';
						container.append(html);
					}
				}
			});


			//添加附件
			panel.off('click', '#farmhousereturn_edit_fj_btn');
			panel.find('#farmhousereturn_edit_fj_btn').click(function () {
				var SelectUser = require('modules/sjcj/farmhousereturn/ctrl/farmhousereturn.fj');
				var _SelectUser = new SelectUser("farmhousereturnFj");
				_self.controllers["farmhousereturnFj"] = _SelectUser;
				_SelectUser.parent = _self;
				Dialog.open({
					id : 'farmhousereturnFj',
					title : '附件上传',
					href : "modules/sjcj/farmhousereturn/farmhousereturn-fj.jsp",
					width : 900,
					height : 570
				}, {'id':_self.data.frid,'emodoule':'3','type1':frtype}, _self.controllers["farmhousereturnFj"]);
			});
		};
		
		// @override
		this.submit = function(panel, data, closeCallback) {
			closeCallback();
		};

		this.submitTj = function(panel, data, closeCallback) {
			$.messager.confirm("操作提示","是否确认提交申请单？",function(b) {
				if (b) {
					var form = panel.find('form');
					var status = _self.panel.find("#farmhousereturn_edit_status").val();
					if(status == "01" || status == "04"){
						//校验附件是否上传
						Core.ajax(Config.ContextPath+'service/attachment/getAttachments/3/'+data.frid, {
							type: 'json',
							method: 'get'
						}).then(function(resdata) {
							var list = resdata.fjlist;
							if(list != null && list.length > 0){
								var table = panel.find('#farmhousereturnlist_table');
								var rows = table.datagrid('getData');
								if(rows != null && rows.rows.length > 0){
									_self.panel.find("#farmhousereturn_edit_status").val("02");
									form.form('ajax', {
										url: Config.ContextPath + 'service/facility/farmhousereturn',
										method: 'post',
									}).then(closeCallback);
								} else {
									$.messager.alert('提醒', '未添加需要处理的农户清单！不可提交！','warning');
								}

							} else {
								$.messager.alert('提醒', '请先上传申请单附件！','warning');
							}
						});

					} else {
						$.messager.alert('提醒', '申请单已提交，请勿重复提交！','warning');
					}
				}
			});

			return false;
		};
		//受理
		this.submitSl = function(panel, data, closeCallback) {
			$.messager.confirm("操作提示","是否确认受理此申请单？",function(b) {
				if (b) {
					var form = panel.find('form');
					//校验是否可以受理,受理后的状态确定
					var status = _self.panel.find("#farmhousereturn_edit_status").val();
					var role = _self.parent.panel.find("#farmhousereturn_role").val();
					var newStatus = null;
					if((role == "sysadmin" || role == "0010") && data.status == "07"){//管理员或省审核“市已受理”
						newStatus = "05";
					}
					if(role == "0011" && data.status == "06"){//市审核“县区已受理”
						newStatus = "07";
					}
					if(role == "0012" && data.status == "02"){//县区审核“镇提交”
						newStatus = "06";
					}
					if(newStatus != null){
						_self.panel.find("#farmhousereturn_edit_status").val(newStatus);
						form.form('ajax', {
							url: Config.ContextPath + 'service/facility/farmhousereturn',
							method: 'post',
						}).then(closeCallback);
					}

				}
			});

			return false;
		};
		//退回
		this.submitTh = function(panel, data, closeCallback) {
			$.messager.confirm("操作提示","是否确认退回此申请单？",function(b) {
				if (b) {
					var form = panel.find('form');
					var status = _self.panel.find("#farmhousereturn_edit_status").val();
					var role = _self.parent.panel.find("#farmhousereturn_role").val();
					var newStatus = null;
					if((role == "sysadmin" || role == "0010") && data.status == "07"){//管理员或省审核“市已受理”
						newStatus = "04";
					}
					if(role == "0011" && data.status == "06"){//市审核“县区已受理”
						newStatus = "04";
					}
					if(role == "0012" && data.status == "02"){//县区审核“镇提交”
						newStatus = "04";
					}
					if(newStatus != null){
						_self.panel.find("#farmhousereturn_edit_status").val(newStatus);
						form.form('ajax', {
							url: Config.ContextPath + 'service/facility/farmhousereturn',
							method: 'post',
						}).then(closeCallback);
					}
				}
			});

			return false;
		};
		
		// @override
		this.onClose = function(table) {
			table.datagrid('reload');
		};
	});

	return FarmhousereturnEdit;
});