define(function(require) {
	var Config = require('config');
	var Page = require('core/page');
	var Core = require('core/core');

	var FarmhousereturnAdd = Page.extend(function() {
		var frtype;
		// @override
		this.load = function(panel, data) {
			frtype = this.parent.panel.find("#farmhousereturn_frtype").val();
			panel.find("#farmhousereturn_info_frtype").val(frtype);
			var frtypestr = null;
			if(frtype == 0){
				frtypestr = "农户删除";
			} else if(frtype == 1){
				frtypestr = "农户退回计划中";
			}
			panel.siblings("div").eq(0).find(".panel-title").text("新增申请表-" + frtypestr);
			var form = panel.find('form');
			// 
			form.form('disableValidation')
			.form('focus');
			//获取登录用户行政区划信息
			Core.ajax(Config.ContextPath + 'service/common/getLoginUserUnitInfo', {
				method: 'get'
			}).then(function (rlt) {
				if(rlt != null ){
					panel.find("#farmhousereturn_info_district").html(rlt.district);
				}
			});

		};
		
		// @override
		this.submit = function(panel, data, closeCallback) {
			var form = panel.find('form');
			
			// 开启校验
			form.form('enableValidation');
			var isValid = form.form('validate');
			
			if (isValid) {
				form.form('ajax', {
					url: Config.ContextPath + 'service/facility/farmhousereturn',
					method: 'post',
				}).then(closeCallback);
			}
			
			return false;
		};
		
		// @override 
		this.onClose = function(table, data) {
			table.datagrid('reload');
		};
	});
	
	return FarmhousereturnAdd;
});