<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<div class="easyui-layout" data-options="fit:true">
    <div data-options="region:'center'" border="false" style="padding: 4px;">
        <div class="easyui-layout" fit="true" id="farmhouse-info-main">
            <div region="north" class="search-body" cls="search" style="height: auto;">
                <input id="s_farmhouse_fullpath" type="hidden"/>
                <form class="clearFromValue" id="farmhouse_search_form">
                    <input name="s_vid" id="s_farmhouse_vid" type="hidden"/>
                    <input name="s_unitcode" id="s_farmhouse_unitcode" type="hidden"/>
                    <div class="search-item">
                        <label>行政区划</label>
                        <input type="text" class="easyui-combobox" name="s_second" id="sjsecond" method="get" style="width: 120px"/>
                        &nbsp;
                        <input type="text" class="easyui-combobox" name="s_districtcode" id="sjthird" method="get" style="width: 120px"/>
                        &nbsp;
                        <input type="text" class="easyui-combobox" name="s_town" id="sjfourth" method="get" style="width: 120px"/>

                        <input type="text" class="easyui-combobox" name="s_administrativevillage" id="sjfive" method="get" style="width: 120px"  data-options="valueField:'unitCode',textField:'unitName'"/>
                    </div>
                    <div class="search-item">
                        <label>自然村</label>
                        <input class="easyui-textbox" name="s_naturalvillage" style="width: 90px"/>
                    </div>
                    <div class="search-item">
                        <label>改善类型</label>
                        <input class="easyui-combobox" name="s_bettertype" style="width: 150px" id="s_bettertype"
                               target="dictionary"
                               key="BetterType"/>
                    </div>
                    <div class="search-item">
                        <label>录入年份</label>
                        <input type="text" class="easyui-combobox" name="s_year" style="width: 80px"
                               url="service/common/getYearList/10" method="get"
                               data-options="valueField:'year',textField:'year'"/>
                    </div>
                    <div class="search-item">
                        <label>改善进度</label>
                        <input class="easyui-combobox" name="s_isbetter" style="width: 120px"
                               target="dictionary"
                               key="isBetter"/>
                    </div>
                    <div class="search-item">
                        <label>四类人群</label>
                        <input class="easyui-combobox" name="s_persontype" style="width: 180px"
                               target="dictionary"
                               key="PersonType"/>
                    </div>
                    <div class="search-item">
                        <label>户主姓名</label>
                        <input class="easyui-textbox" name="s_fname" style="width: 90px"/>
                    </div>
                    <div class="search-item">
                        <label>身份证</label>
                        <input class="easyui-textbox" name="s_pid" style="width: 90px"/>
                    </div>
                    <a class="easyui-linkbutton btn-search" iconCls="icon-search">查询</a>
                    <a class="easyui-linkbutton btn-reset" iconcls="icon-reload" id="farmhousejbxx_reset_btn">清空查询条件</a>
                    <%--<a href="../../templatefile/农房基础信息导入模板.xlsx" style="display: none" id="farmhousejbxx_load_a">下载导入模板</a>--%>
                    <%--<a class="easyui-linkbutton cy-btn cy-btn-forward" >上一步</a>
                    <a class="easyui-linkbutton cy-btn cy-btn-next" >下一步</a>--%>
                    <br>
                    <a class="warnSelf">说明：农房基础信息录入即农房档案录入，为后续做农房改善管理做基础数据支撑，新录入系统的农房默认改善进度为未改善，后面在农房改善管理模块改善进度会发生变化，具体如下：<br>
                        计划中:列入计划的农户，改善中:改善过程跟踪里编辑或新增的农户，确认改善:镇级确认改善的农户，已改善:实际改善信息推送到省厅同意后。只有进度为未改善的农房信息可删除！</a>
                </form>
            </div>
            <div class="cy-btn-position" id="farmhouse_cy-btn-position">
                <a class="easyui-linkbutton cy-btn cy-btn-forward" id="farmhousejbxx_prev">上一步：村庄基础信息录入</a>
                <a class="easyui-linkbutton cy-btn cy-btn-next"  id="farmhousejbxx_next">下一步：改善项目信息录入</a>
            </div>
            <input type="hidden" id="fh_isAdmin">
            <div region="center" border="false" style="padding: 4px; height: 100%">
                <table
                        fitColumns="true"
                        fit="true"
                        id="farmhouse_table"
                        idField="fid"
                        sortName="updatetime"
                        sortOrder="desc"
                        search=".search"
                        <%--nowrap="false"--%>
                        toolbar=".temp-toolbar" action="farmhousejbxx_view">
                    <thead data-options="frozen:true">
                    <tr>
                        <th data-options="field:'isbetter'" format="Dictionary:isBetter" align="center" width="80px">改善进度</th>
                        <th data-options="field:'districtcode'" align="center" width="100px">行政区划</th>
                        <th data-options="field:'town'" align="center" align="center" width="80px">乡镇</th>
                        <th data-options="field:'administrativevillage'" align="center" width="80px">行政村</th>
                        <th data-options="field:'naturalvillage'" align="center" width="80px">自然村</th>
                        <th data-options="field:'fname'" align="center" width="80px">户主姓名</th>
                        <th data-options="field:'pid'" align="center"width="180px">户主身份证号</th>
                        <th data-options="field:'bettertype'" format="Dictionary:BetterType" align="center">改善类型</th>
                    </tr>
                    </thead>
                    <thead>
                    <tr>
                        <th data-options="field:'tel'" align="center"width="10%">户主联系电话</th>
                        <th data-options="field:'familyNum'" align="center">家庭人口</th>
                        <th data-options="field:'persontype'" format="Dictionary:PersonType" align="center">四类人群</th>
                        <th data-options="field:'housingarea'" align="center">改善前住房面积（㎡）</th>
                        <th data-options="field:'housingstructure'" format="Dictionary:housingStructure" align="center">改善前房屋结构</th>
                        <th data-options="field:'layernum'" align="center">改善前层数</th>
                        <th data-options="field:'oldarea'" align="center">协议拆除旧房面积（㎡）</th>
                        <th data-options="field:'outarea'" align="center">协议退出宅基地面积（㎡）</th>
                        <th data-options="field:'userName'" align="center">录入用户</th>
                        <th data-options="field:'updatetime'" format="Date:yyyy-MM-dd" width="10%" align="center">更新时间</th>
                    </tr>
                    </thead>
                </table>
                <div class="temp-toolbar">
                    <a iconCls="icon-add" href="modules/sjcj/farmhousejbxx/farmhousejbxx-info.jsp?bettertype=F" trigger="none"
                       id="farmhousejbxx_add_btn"
                       target="dialog" rel="farmhousejbxx_add" title="新增农房基本信息" width="1100" height="570"
                       <%--btnValue="添加"--%> buttons="[{method:'submitNext',text:'保存并新增'},
                       {method:'submit',text:'保存并退出'}]">新增</a>
                    <hr>

                    <a iconCls="icon-edit" href="modules/sjcj/farmhousejbxx/farmhousejbxx-info.jsp" trigger="single"
                       id="farmhousejbxx_edit_btn"
                       target="dialog" rel="farmhousejbxx_edit" title="修改农房 {{districtcode}}-{{town}}-{{administrativevillage}}-{{naturalvillage}}-{{fname}}" width="1100" height="570"
                       buttons="[{method:'submit',text:'保存'}]">修改</a>
                    <hr>
                    <a iconCls="icon-edit" href="modules/sjcj/farmhousejbxx/farmhousejbxx-view.jsp" trigger="single"
                       target="dialog" rel="farmhousejbxx_view" title="查看农房详情 {{districtcode}}-{{town}}-{{administrativevillage}}-{{naturalvillage}}-{{fname}}" width="1100" height="570"
                       buttons="[{method:'viewPrev',text:'查看上一户'},{method:'viewNext',text:'查看下一户'}]">查看</a>
                    <hr>
                    <a iconCls="icon-base icon-base-ban" trigger="single" id="farmhousejbxx_remove_btn"
                       target="confirm" rel="farmhousejbxx_remove" title="是否确定删除 {{text}}？">删除</a>
                    <hr>
                    <a iconCls="icon-redo" trigger="none" target="custom" rel="farmhousejbxx_load" id="farmhousejbxx_load_btn">下载导入模板</a>

                    <hr>
                    <a iconCls="icon-edit" href="modules/sjcj/farmhousejbxx/farmhousejbxx-imp.jsp" trigger="none" width="800"
                       height="540"
                       target="dialog" rel="farmhousejbxx_imp" id="farmhousejbxx_imp_btn" title="导入" btnValue="确定">导入</a>
                    <hr>
                    <a iconCls="icon-redo" trigger="none" target="custom" rel="farmhousejbxx_exp" id="farmhousejbxx_exp_btn">导出</a>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    $.parser.onComplete = function (panel) {
        $.parser.onComplete = $.noop;
        var vid = '<%=request.getParameter("vid")%>';
        var unitcode = '<%=request.getParameter("unitcode")%>';
        var fullpath = '<%=request.getParameter("fullpath")%>';
        var _sjs = Math.random();
        requirejs([
                'core/filter/filter.dictionary',
                'modules/sjcj/farmhousejbxx/ctrl/farmhousejbxx',
                'css!plugins/viewer/viewer.min.css'],
            function (FilterDictionary, Farmhousejbxx) {
                FilterDictionary.add([
                    'PersonType', 'BetterType', 'isBetter', 'HouseType','housingStructure']
                ).then(function () {
                    new Farmhousejbxx('farmhousejbxx' + _sjs, panel).load(panel, vid, unitcode, fullpath);
                });
            });
    };
</script>
