<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<div class="easyui-layout" data-options="fit:true">
    <div data-options="region:'center'" border="false" style="padding: 4px;">
        <div class="easyui-layout" fit="true" id="farmhouse-info-main">
            <div region="north" class="search-body" cls="search" style="height: auto;">
                <input id="s_farmhouse_fullpath" type="hidden"/>
                <input id="realityyears" type="hidden"/>
                <input id="persontypes" type="hidden"/>

                <form class="clearFromValue" id="farmhouse_search_form">
                    <input name="s_vid" id="s_farmhouse_vid" type="hidden"/>
                    <input name="s_unitcode" id="s_farmhouse_unitcode" type="hidden"/>
                    <div class="search-item">
                        <label>行政区划</label>
                        <input type="text" class="easyui-combobox" name="s_second" id="sjsecond" method="get" style="width: 90px"/>
                        &nbsp;
                        <input type="text" class="easyui-combobox" name="s_districtcode" id="sjthird" method="get" style="width: 100px"/>
                        &nbsp;
                        <input type="text" class="easyui-combobox" name="s_town" id="sjfourth" method="get" style="width: 120px"/>
                    </div>
                    <div class="search-item">
                        <label>计划改善年份</label>
                        <input type="text" class="easyui-combobox" name="s_planyear" style="width: 90px"
                               url="service/common/getYearList/10" method="get"
                               data-options="valueField:'year',textField:'year'" id="s_planyear"/>
                    </div>
                    <div class="search-item">
                        <label>实际改善年份(多选)</label>

                        <input type="text" class="easyui-combobox" name="s_realityyear" style="width: 200px" id="s_realityyear"
                               url="service/common/getYearList/10" method="get"
                               data-options="valueField:'year',textField:'year',multiple:true"/>
                    </div>
                    <div class="search-item">
                        <label>改善进度</label>
                        <select class="easyui-combobox" name="s_isbetter" style="width: 100px" id="s_isbetter">
                            <option value=""></option>
                            <option value="P">计划中</option>
                            <option value="B">改善中</option>
                            <option value="S">确认改善</option>
                            <option value="T">已改善</option>
                        </select>
                        <%-- <input
                                target="dictionary"valueField="id",textField="name"
                                data="[{{id: 194, name: '绑定'},{id: 200, name: '星标组'},{id: 196, name: 'Pukn'},{id: 198, name: 'QiTi'}
                         }]" />--%>
                    </div>
                    <div class="search-item">
                        <label>四类人群(多选)</label>
                        <input class="easyui-combobox" name="s_persontype" style="width: 200px"
                               target="dictionary" id="s_persontype"
                               key="PersonType"  data-options="multiple:true"/>
                    </div>
                    <div class="search-item">
                        <label>改善类型</label>
                        <input class="easyui-combobox" name="s_bettertype" style="width: 150px" id="s_bettertype"
                               target="dictionary"
                               key="BetterType"/>
                    </div>
                    <div class="search-item ">
                        <label>危房等级</label>
                        <input type="text" class="easyui-combobox" target="dictionary" key="FarmhouseLevel"
                               name="s_dangerlevel" id="s_dangerlevel" style="width: 120px"/>
                    </div>
                    <div class="search-item">
                        <label>户主姓名</label>
                        <input class="easyui-textbox" name="s_fname" style="width: 70px" id="s_fname"/>
                    </div>
                    <div class="search-item">
                        <label>身份证</label>
                        <input class="easyui-textbox" name="s_pid" style="width: 120px" id="s_pid"/>
                    </div>
                    <%--  <a class="easyui-linkbutton btn-search" iconCls="icon-search" id="tableListSearch">查询</a>--%>
                    <button  type="button"class="easyui-linkbutton btn-search" iconCls="icon-search" id="tableListSearch">搜索</button>
                    <br>
                    <a class="warnSelf">说明：默认显示进度为计划中、改善中和确认改善的信息，计划中:列入计划的农户，改善中:此界面编辑或新增的农户，确认改善:镇级确认改善的农户，已改善:实际改善信息推送到省厅同意后。<br>
                        新增计划外改善农房为已完成计划表，但在实际改善中又增加的农房信息，此农房无计划年份。计划中、改善中和确认改善的农户信息均可修改信息，已改善不可修改信息!</a>
                </form>
            </div>
            <div class="cy-btn-position" >
                <a class="easyui-linkbutton cy-btn cy-btn-forward" id="farmhousejbxx_gs_prev">上一步：改善计划编制</a>
                <a class="easyui-linkbutton cy-btn cy-btn-next"  id="farmhousejbxx_gs_next">下一步：实际改善推送</a>
            </div>
            <div region="center" border="false" style="padding: 4px; height: 100%">
                <table
                        fitColumns="true"
                        fit="true"
                        id="farmhouse_table"
                        idField="fid"
                        sortName="updatetime"
                        sortOrder="desc"

                <%--nowrap="false"--%>
                        toolbar=".temp-toolbar" action="farmhousejbxx_view">
                    <thead data-options="frozen:true">
                    <tr>
                        <th data-options="field:'isbetter'" format="Dictionary:isBetter" align="center" width="80px">改善进度</th>
                        <th data-options="field:'districtcode'" align="center" width="100px">行政区划</th>
                        <th data-options="field:'town'" align="center" align="center" width="80px">乡镇</th>
                        <th data-options="field:'administrativevillage'" align="center" width="80px">行政村</th>
                        <th data-options="field:'naturalvillage'" align="center" width="80px">自然村</th>
                        <th data-options="field:'fname'" align="center" width="80px">户主姓名</th>
                        <th data-options="field:'pid'" align="center" width="180px">户主身份证号</th>
                    </tr>
                    </thead>
                    <thead>
                    <tr>

                        <th data-options="field:'tel'" align="center" width="130px">户主联系电话</th>
                        <th data-options="field:'bettertype'" format="Dictionary:BetterType" align="center">改善类型</th>
                        <th data-options="field:'planyear'"  align="center">计划改善年份</th>
                        <th data-options="field:'realityyear'"  align="center">实际改善年份</th>



                        <th data-options="field:'familyNum'" align="center">家庭人口</th>
                        <th data-options="field:'cost'" align="center" >补贴费用</th>
                        <th data-options="field:'persontype'" format="Dictionary:PersonType" align="center">四类人群</th>
                        <th data-options="field:'housingarea'" align="center">改善前住房面积（㎡）</th>
                        <th data-options="field:'housingstructure'" format="Dictionary:housingStructure" align="center">改善前房屋结构</th>
                        <th data-options="field:'layernum'" align="center">改善前层数</th>
                        <th data-options="field:'oldarea'" align="center">协议拆除旧房面积(㎡)</th>
                        <th data-options="field:'outarea'" align="center">协议退出宅基地面积(㎡)</th>

                        <th data-options="field:'oldarea2'" align="center">已拆除旧房面积(㎡)</th>
                        <th data-options="field:'outarea2'" align="center">已退出宅基地面积(㎡)</th>
                        <th data-options="field:'housingarea2'" align="center">改善后住房面积（㎡）</th>
                        <th data-options="field:'housingaddress'" align="center">改善后居住地详址</th>
                        <th data-options="field:'dangerlevel'" format="Dictionary:FarmhouseLevel" align="center">危房等级</th>
                        <th data-options="field:'userName'" align="center">录入用户</th>
                        <th data-options="field:'updatetime'" format="Date:yyyy-MM-dd" align="center"width="8%">更新时间</th>
                    </tr>
                    </thead>
                </table>
                <div class="temp-toolbar">
                    <a iconCls="icon-edit" href="modules/sjcj/farmhousejbxx/farmhousejbxx-info.jsp?bettertype=B" trigger="single"
                       id="farmhousejbxx_edit_btn"
                       target="dialog" rel="farmhousejbxx_edit" title="维护农房改善过程信息 {{districtcode}}-{{town}}-{{administrativevillage}}-{{naturalvillage}}-{{fname}}" width="1100" height="570"
                       buttons="[{method:'submit',text:'暂存并退出'},{method:'submitBetter',text:'确认改善'}]" >维护农房改善过程信息</a>
                    <hr>
                    <a iconCls="icon-add" href="modules/sjcj/farmhousejbxx/farmhousejbxx-info.jsp?bettertype=B" trigger="none"
                       id="farmhousejbxx_add_btn"
                       target="dialog" rel="farmhousejbxx_add" title="新增改善农房" width="1100" height="570"
                    <%--btnValue="添加"--%> buttons="[{method:'submit',text:'保存'}]">新增计划外改善农房</a>
                    <hr>

                    <a iconCls="icon-edit" href="modules/sjcj/farmhousejbxx/farmhousejbxx-view.jsp" trigger="single"
                       target="dialog" rel="farmhousejbxx_view" title="查看农房详情 {{districtcode}}-{{town}}-{{administrativevillage}}-{{naturalvillage}}-{{fname}}" width="1100" height="570"
                       buttons="[{method:'viewPrev',text:'查看上一户'},{method:'viewNext',text:'查看下一户'}]">查看</a>
                    <hr>
                    <a iconCls="icon-base icon-sl" trigger="single" id="farmhousejbxx_back"
                       target="confirm" rel="farmhousejbxx_back" title="是否确定将其退回至计划中">确认改善退回至计划中</a>
                    <hr>
                    <a iconCls="icon-redo" trigger="none" target="custom" rel="farmhousejbxx_exp" id="farmhousejbxx_gs_exp">导出</a>

                </div>
            </div>
        </div>
    </div>
</div>

<script>
    $.parser.onComplete = function (panel) {
        $.parser.onComplete = $.noop;
        var vid = '<%=request.getParameter("vid")%>';
        var unitcode = '<%=request.getParameter("unitcode")%>';
        var fullpath = '<%=request.getParameter("fullpath")%>';
        var _sjs = Math.random();
        requirejs([
                'core/filter/filter.dictionary',
                'modules/sjcj/farmhousejbxx/ctrl/farmhousejbxx.gs',
                'css!plugins/viewer/viewer.min.css'],
            function (FilterDictionary, Farmhousejbxx) {
                FilterDictionary.add([
                    'PersonType', 'BetterType', 'isBetter', 'HouseType','housingStructure','YesOrNo','FarmhouseLevel']
                ).then(function () {
                    new Farmhousejbxx('farmhousejbxx' + _sjs, panel).load(panel, vid, unitcode, fullpath);
                });
            });
    };
</script>
