define(function(require) {
	var Config = require('config');
	var Page = require('core/page');
	var Core = require('core/core');
	var $ = require('jquery');
    var viewer = require('plugins/viewer/viewer.min');

	var FarmhousejbxxViewpic = Page.extend(function() {
		var _self = this;	
		var _data;
		// @override
		this.load = function(panel, data) {
			_data = data;

            Core.ajax(Config.ContextPath+'service/utils/images/getAttachmentsBTY/1/' + _data.fid, {
                type: 'json',
                method: 'get'
            }).then(function(data) {
                panel.find('#viewpic_beforein').empty();
                panel.find('#viewpic_beforeout').empty();
                panel.find('#viewpic_afterin').empty();
                panel.find('#viewpic_afterout').empty();
                $.each(data.fjList, function(index, item) {
                    $('<img>', {
                        src : "data:image/jpg;base64,"+item.efj,
                    }).css({
                        height : "100px",
                        margin : "3px"
                    }).appendTo(panel.find('#viewpic_' + item.type1));
                });
                panel.find('#viewpic_beforein').viewer({
                    zIndex : 9999
                });
                panel.find('#viewpic_beforeout').viewer({
                    zIndex : 9999
                });
                panel.find('#viewpic_afterin').viewer({
                    zIndex : 9999
                });
                panel.find('#viewpic_afterout').viewer({
                    zIndex : 9999
                });
            });
		};
	});
	
	return FarmhousejbxxViewpic;
});