define(function(require) {
	var Config = require('config');
	var Core = require('core/core');
	var Page = require('core/page');
    var viewer = require('plugins/viewer/viewer.min');
	var FarmhousejbxxView = Page.extend(function() {

		var _self;
        var gsShow;
		// @override
		this.load = function(panel, ldata) {
		    var isbetter;
		    if(ldata.isbetter !=undefined){
                isbetter=ldata.isbetter;
            }else{
                isbetter=$("#isbetter").val();
            }
			var form = panel.find('form');
            _self = this;
            if(isbetter == 'P' || isbetter == 'B' || isbetter == 'S' || isbetter == 'T'){//计划中或已改善可编辑改善信息
                gsShow = true;
            } else {
                gsShow = false;
            }
            Core.ajax(Config.ContextPath+'service/sjcj/farmhousejbxx/'+ldata.fid, {
                type: 'json',
                method: 'get'
            }).then(function(data) {
              if(data.persontype != null && data.persontype != ""){
                data.isPersontype = "T";
              } else {
                data.isPersontype = "F";
              }
                _self.data = data;
                _self.data.memberCnt = 0;
                //自然村下拉列表初始化
                if(data.administrativeVillage != null && data.administrativeVillage.length > 0){
                    panel.find('#farmhouse_vid').combobox('reload', Config.ContextPath + 'service/sjcj/villagejbxx/list2?administrativevillage=' + data.administrativeVillage);
                }

                //地图是否定位
                if(data.longit != null && data.longit != '' && data.lat != null && data.lat != ''){
                    $("#farmhouse_located").show();
                    $("#farmhouse_unlocated").hide();
                }
                panel.find('#farmhouseinfo_member_div').empty();
                for(var i = 0; i < data.householdregisterjbxxList.length; i++) {
                    var householdregisterjbxx = data.householdregisterjbxxList[i];
                    if(householdregisterjbxx.isHz === 'T') {//户主信息显示
                        data.fname = householdregisterjbxx.fname;
                        data.pid = householdregisterjbxx.pid;
                        data.familyIncome = householdregisterjbxx.familyIncome;
                        data.tel = householdregisterjbxx.tel;
                        data.familyNum = householdregisterjbxx.familyNum;
                        data.hid = householdregisterjbxx.hid;
                    } else {//非户主动态展示
                        loadOtherFamily(householdregisterjbxx);
                    }
                }
                panel.siblings("div").eq(0).find(".panel-title").text("查看农房详情" + data.dz + '-' +  data.fname);
                if(gsShow){
                    panel.find("#farmhouse_view_gsxx").show();
                    //改善后-地图是否定位
                    if(data.longit2 != null && data.longit2 != '' && data.lat2 != null && data.lat2 != ''){
                        panel.find("#farmhouse2_located").show();
                        panel.find("#farmhouse2_unlocated").hide();
                    }

                }
                form.form('load', data)
                    .form('disableValidation')
                    .form('focus');
                //加载图片
                reloadImage();

                //地图定位功能-经纬度为空时取页面选择的自然村经纬度
                panel.find('#farmhouse_location').click(function() {
                    var lng = panel.find('#farmhouse_input_lng').val();
                    var lat = panel.find('#farmhouse_input_lat').val();
                    if(lng != null && lng != '' && lat != null && lat != ''){
                        $('#map_iframe_farmhouse').attr("src","../../modules/sjcj/map/locationmap.jsp?dialogname=farmhouse_map_dialog&module=readonly&lng=" + lng + "&lat=" + lat);
                        $('#farmhouse_map_dialog').dialog({
                            title: '农房地点',
                            width: 900,
                            height: 600
                        });
                    }
                });

                //改善后-地图定位功能-经纬度为空时先取改善前经纬度
                panel.find('#farmhouse2_location').click(function() {
                    var lng2 = panel.find('#farmhouse2_input_lng').val();
                    var lat2 = panel.find('#farmhouse2_input_lat').val();
                    if(lng2 != null && lng2 != '' && lat2 != null && lat2 != ''){
                        $('#map_iframe_farmhouse2').attr("src","../../modules/sjcj/map/locationmap.jsp?dialogname=farmhouse2_map_dialog&module=readonly&lng=" + lng2 + "&lat=" + lat2);
                        $('#farmhouse2_map_dialog').dialog({
                            title: '改善后农房地点',
                            width: 900,
                            height: 600
                        });
                    } else {
                        $.messager.alert('提醒', '未获取位置信息！','warning');
                    }
                });
            });
		};

    //上一户
		this.viewPrev = function (panel, data,closeCallback) {
		      table = _self.parent.panel.find("#farmhouse_table");
		      var rows = table.datagrid("getRows");
          for(var i = 0 ; i < rows.length ; i++){
            var row = rows[i];
            if(row.fid == data.fid){
              if(i == 0){
                $.messager.alert('提醒', '已经是第一条数据！');
              } else {
                var showobj = rows[i-1];
                var form = panel.find('form');
                form.form('clear').form('disableValidation');
                this.load(panel,showobj);
              }
              break;
            }
          }
          return false;
    }

    //下一户
    this.viewNext = function (panel, data,closeCallback) {
      table = _self.parent.panel.find("#farmhouse_table");
      var rows = table.datagrid("getRows");
      for(var i = 0 ; i < rows.length ; i++){
        var row = rows[i];
        if(row.fid == data.fid){
          if(i == (rows.length -1)){
            $.messager.alert('提醒', '已经是最后一条数据！');
          } else {
            var showobj = rows[i+1];
            var form = panel.find('form');
            form.form('clear').form('disableValidation');
            this.load(panel,showobj);
          }
          break;
        }
      }
      return false;
    }

        function markLocated(id) {
            $("#" + id + "_located").show();
            $("#" + id + "_unlocated").hide();
        }
        function markUnlocated(id) {
            $("#" + id + "_located").hide();
            $("#" + id + "_unlocated").show();
        }

        //加载其他家庭成员信息-同时增加
        function loadOtherFamily(householdregisterjbxx){
            var container = _self.panel.find('#farmhouseinfo_member_div');
            var fname = '';
            if(householdregisterjbxx != null && householdregisterjbxx.fname != null){
                fname = householdregisterjbxx.fname;
            }
            var pid = '';
            if(householdregisterjbxx != null && householdregisterjbxx.pid != null){
                pid = householdregisterjbxx.pid;
            }
            var tel = '';
            if(householdregisterjbxx != null && householdregisterjbxx.tel != null){
                tel = householdregisterjbxx.tel;
            }
            var html =      '<div class="field required"><label>其他家庭成员姓名</label><input type="text" class="easyui-textbox" readonly="readonly"  style="width: 250px" id="farmhouseinfo_fname-'
                + _self.data.memberCnt + '" name="fname_' + _self.data.memberCnt + '" value="' + fname + '" required/>' +
                '            </div>' +
                '            <div class="field required">' +
                '                <label>其他家庭成员身份证号</label>' +
                '                <input type="text" class="easyui-textbox"  readonly="readonly" style="width: 250px" id="farmhouseinfo_pid-' + _self.data.memberCnt + '"' +
                '                       name="pid_' + _self.data.memberCnt + '" value="' + pid + '" required/>' +
                '            </div>' +
                '            <div class="field">' +
                '                <label>其他家庭成员联系电话</label>' +
                '                <input type="text" class="easyui-textbox" readonly="readonly"  style="width: 250px" id="farmhouseinfo_tel-' + _self.data.memberCnt + '"' +
                '                       name="tel_' + _self.data.memberCnt + '" value="' + tel + '" />' +
                '            </div>';
            var itemdiv = $('<div>', {
                id: 'farmhouseinfo_member_div-' + _self.data.memberCnt,
                class: 'four fields'
            }).css({
                'margin-left': '0px'
            }).html(html).appendTo(container);
            $.parser.parse(container);
            _self.data.memberCnt++;
        }

        function reloadImage() {
            Core.ajax(Config.ContextPath + 'service/utils/images/getAttachmentsBTY/1/' + _self.data.fid, {
                type: 'json',
                method: 'get'
            }).then(function (data) {
                $('#imgcontainer_beforein').empty();
                $('#imgcontainer_beforeout').empty();
                $('#imgcontainer_afterin').empty();
                $('#imgcontainer_afterout').empty();
                $.each(data.fjList, function (index, item) {
                    $('<img>', {
                        src : "data:image/jpg;base64,"+item.efj,
                    }).css({
                        height : "100px",
                        margin : "3px"
                    }).appendTo(_self.panel.find('#imgcontainer_' + item.type1));
                });
                _self.panel.find('#imgcontainer_beforein').viewer({
                    zIndex : 9999
                });
                _self.panel.find('#imgcontainer_beforeout').viewer({
                    zIndex : 9999
                });
                _self.panel.find('#imgcontainer_afterin').viewer({
                    zIndex : 9999
                });
                _self.panel.find('#imgcontainer_afterout').viewer({
                    zIndex : 9999
                });
            });
        }
        // @override
        this.onClose = function(table) {
            table.datagrid('reload');
        };
	});

	return FarmhousejbxxView;
});
