define(function (require) {
    var Config = require('config');
    var Core = require('core/core');
    var Page = require('core/page');
    var Events = require('core/events');

    var FarmhousejbxxEdit = require('../ctrl/farmhousejbxx.edit');
    /*var FarmhousejbxxBetter = require('../ctrl/farmhousejbxx.better');*/
    var FarmhousejbxxView = require('../ctrl/farmhousejbxx.view');
    var FarmhousejbxxExp = require('../ctrl/farmhousejbxx.exp');
    var FarmhousejbxxAdd = require('../ctrl/farmhousejbxx.add');
    var FarmhousejbxxBack = require('../ctrl/farmhousejbxx.back');
    var Farmhousejbxx = Page.extend(function () {
        this.injecte([
            new FarmhousejbxxEdit('farmhousejbxx_edit'),
            /*new FarmhousejbxxBetter('farmhousejbxx_better'),*/
            new FarmhousejbxxView('farmhousejbxx_view'),
            new FarmhousejbxxExp('farmhousejbxx_exp'),
            new FarmhousejbxxAdd('farmhousejbxx_add'),
            new FarmhousejbxxBack('farmhousejbxx_back'),
        ]);

        // @override
        this.load = function (panel, vid, unitcode, fullpath) {
            var table = this.table = panel.find('table');
            table.cdatagrid({
                controller: this
            });
            this.$autoHeight('north', panel.find('#farmhouse-info-main', panel));

            //上一页
            panel.find("#farmhousejbxx_gs_prev").on("click",function(){
                var url = Config.ContextPath + 'modules/sjcj/statisticsList/statisticsList.jsp?stype=1'
                Events.trigger('open.MenuTab', {
                    id: 'aa',
                    text: '改善计划编制',
                    url: url,
                    closable: true
                });
            });

            //下一页
            panel.find("#farmhousejbxx_gs_next").on("click",function(){
                var url = Config.ContextPath + 'modules/sjcj/statisticsList/statisticsList.jsp?stype=2'
                Events.trigger('open.MenuTab', {
                    id: 'aa',
                    text: '实际改善推送',
                    url: url,
                    closable: true
                });
            });

            loadTable(table,panel,vid,unitcode,fullpath);

            panel.find('#tableListSearch').click(function() {
                loadTable(table,panel,vid,unitcode,fullpath);
            });

            panel.find('#sjsecond').combobox({
                url: Config.ContextPath + "service/jhgswork/getUnitInfoSecond?code=320000000000",
                valueField: 'unitCode',
                textField: 'unitName',
                onLoadSuccess: function (data) {
                    var da = data[0];
                    if (da != undefined) {
                        if (da["yhjb"] == "fsj") {
                            $('#sjsecond').combobox('select', da["unitCode"]);
                            $("#sjsecond").combobox('readonly', true);
                        }
                    }

                }
            });
            panel.find('#sjthird').combobox({
                url: Config.ContextPath + "service/jhgswork/getUnitInfothird",
                valueField: 'unitCode',
                textField: 'unitName',
                onLoadSuccess: function (data) {
                    var da = data[0];
                    if (da != undefined) {
                        if (da["yhjb"] == "fsj") {
                            $('#sjthird').combobox('select', da["unitCode"]);
                            $("#sjthird").combobox('readonly', true);
                        }
                    }

                }
            });
            panel.find('#sjfourth').combobox({
                url: Config.ContextPath + "service/jhgswork/getUnitInfofourth",
                valueField: 'unitCode',
                textField: 'unitName',
                onLoadSuccess: function (data) {
                    var da = data[0];
                    if (da != undefined) {
                        if (da["yhjb"] == "fsj") {
                            $('#sjfourth').combobox('select', da["unitCode"]);
                            $("#sjfourth").combobox('readonly', true);
                        }
                    }

                }
            });

            panel.find('#sjsecond').combobox({
                onChange: function() {
                    var code = panel.find('#sjsecond').combobox('getValue');
                    panel.find('#sjthird').combobox('clear');
                    // 重新获取数据
                    panel.find('#sjthird').combobox('reload', Config.ContextPath+'service/jhgswork/getUnitInfothird?code=' + code);
                }
            });
            panel.find('#sjthird').combobox({
                onChange: function() {
                    var code = panel.find('#sjthird').combobox('getValue');
                    panel.find('#sjfourth').combobox('clear');
                    // 重新获取数据
                    panel.find('#sjfourth').combobox('reload', Config.ContextPath+'service/jhgswork/getUnitInfofourth?code=' + code);
                }
            });




            // 重置按钮 - 重新填充被清空的隐藏条件
            panel.find('#farmhousejbxx_reset_btn').click(function() {
                if(vid != null && vid != undefined && vid != 'undefined' && vid != '' && vid != 'null'){
                    panel.find("#s_farmhouse_vid").val(vid);
                } else if(unitcode != null && unitcode != undefined && unitcode != 'undefined' && unitcode != '' && unitcode != 'null'){
                    panel.find("#s_farmhouse_unitcode").val(unitcode);
                }
            });
        };
        function loadTable(table,panel,vid,unitcode,fullpath){
            //根据权限设置操作按钮
            Core.ajax(Config.ContextPath+'service/common/getLoginUserRoles', {
                method: 'get'
            }).then(function(rlt) {
                var isZj = false;
                var isSj = false;
                var isck = false;//仅有查看功能
                for(var i = 0 ; i < rlt.length ; i++){
                    if(rlt[i].roleCode == '0013'){
                        isZj = true;
                        break;
                    }else if(rlt[i].roleCode =="0010"){
                        isSj = true;
                        break;
                    }

                    if(rlt[i].roleCode == '0015'){
                        isck = true;
                    }
                }

                // 非镇级用户 或 无村庄id时 没有修改权限
                if(!isZj){
                    panel.find("#farmhousejbxx_add_btn").parent("td").next().remove();
                    panel.find("#farmhousejbxx_add_btn").remove();
                    panel.find("#farmhousejbxx_edit_btn").parent("td").next().remove();
                    panel.find("#farmhousejbxx_edit_btn").remove();
                    panel.find("#farmhousejbxx_better_btn").parent("td").next().remove();
                    panel.find("#farmhousejbxx_better_btn").remove();
                    panel.find("#farmhousejbxx_imp_btn").parent("td").next().remove();
                    panel.find("#farmhousejbxx_imp_btn").remove();
                    panel.find("#farmhousejbxx_remove_btn").parent("td").next().remove();
                    panel.find("#farmhousejbxx_remove_btn").remove();
                    panel.find(".cy-btn-position").hide();
                }
                if(!isSj){
                    panel.find("#farmhousejbxx_back").parent("td").next().remove();
                    panel.find("#farmhousejbxx_back").remove();
                }

                if(isck){
                    $("#farmhousejbxx_gs_exp").parent("td").next().remove();
                    $('#farmhousejbxx_gs_exp, #farmhousejbxx_gs_exp + hr', panel).remove();

                }
            });

            var url = "service/utils/farmhousejbxxHouseVillage?isbetters=PBS";
            if(vid != null && vid != undefined && vid != 'undefined' && vid != '' && vid != 'null'){
                panel.find("#s_farmhouse_vid").val(vid);
                url += '&vid='+vid;
            } else if(unitcode != null && unitcode != undefined && unitcode != 'undefined' && unitcode != '' && unitcode != 'null'){
                panel.find("#s_farmhouse_unitcode").val(unitcode);
                url += '&unitcode='+unitcode;
            }

            if(fullpath != null && fullpath != undefined && fullpath != 'undefined' && fullpath != '' && fullpath != 'null'){
                panel.find("#s_farmhouse_fullpath").val(fullpath);
            }

            var year = panel.find("#s_realityyear").combobox('getValues');
            if(year != null && year.length > 0){
                url += "&realityyears=";
                for(var i = 0 ; i < year.length ; i++){
                    url += year[i] + "a";
                }
                url = url.substring(0,url.length - 1);
            }
            var persontypes = panel.find("#s_persontype").combobox('getValues');
            if(persontypes != null && persontypes.length > 0){
                url += "&persontypes=";
                for(var i = 0 ; i < persontypes.length ; i++){
                    url += persontypes[i] + "a";
                }
                url = url.substring(0,url.length - 1);
            }
            var sjfourth = panel.find("#sjfourth").combobox('getValue');
            var sjthird = panel.find("#sjthird").combobox('getValue');
            var sjsecond = panel.find("#sjsecond").combobox('getValue');

            if(sjfourth != ''){
                url += '&s_town='+sjfourth;
            }else   if(sjthird != ''){
                url += '&s_districtcode='+sjthird;
            }else   if(sjsecond != ''){
                url += '&s_second='+sjsecond;
            }

            var s_planyear = panel.find("#s_planyear").combobox('getValue');
            if(s_planyear != ''){
                url += '&s_planyear='+s_planyear;
            }

            var s_isbetter = panel.find("#s_isbetter").combobox('getValue');
            if(s_isbetter != ''){
                url += '&s_isbetter='+s_isbetter;
            }
            var s_bettertype = panel.find("#s_bettertype").combobox('getValue');
            if(s_bettertype != ''){
                url += '&s_bettertype='+s_bettertype;
            }
            var s_fname = panel.find("#s_fname").val();
            if(s_fname != ''){
                url += '&s_fname='+s_fname;
            }
            var s_pid = panel.find("#s_pid").val();
            if(s_pid != ''){
                url += '&s_pid='+s_pid;
            }
            var s_dangerlevel = panel.find("#s_dangerlevel").combobox('getValue');
            if(s_dangerlevel != ''){
                url += '&s_dangerlevel='+s_dangerlevel;
            }

            table.cdatagrid({
                controller: this,
                url: url,
                rowStyler:function (index,rowData){
                    if(rowData && rowData.isbetter == 'F'){
                        return 'color:#EE2C2C';
                    } if(rowData && (rowData.isbetter == 'P' || rowData.isbetter == 'B' || rowData.isbetter == 'S')){
                        return 'color:#FF7F00';
                    } if(rowData && rowData.isbetter == 'T'){
                        return 'color:#224b8f';
                    }
                },
                pageList:[10,20,50,100,500],
            });
        }

    });

    return Farmhousejbxx;
});
