define(function (require) {
    var Config = require('config');
    var Core = require('core/core');
    var Page = require('core/page');
    var Events = require('core/events');

    var FarmhousejbxxAdd = require('../ctrl/farmhousejbxx.add');
    var FarmhousejbxxEdit = require('../ctrl/farmhousejbxx.edit');
    /*var FarmhousejbxxBetter = require('../ctrl/farmhousejbxx.better');*/
    var FarmhousejbxxView = require('../ctrl/farmhousejbxx.view');
    var FarmhousejbxxRemove = require('../ctrl/farmhousejbxx.remove');
    var FarmhousejbxxFj = require('../ctrl/farmhousejbxx.fj');
    var FarmhousejbxxViewpic = require('../ctrl/farmhousejbxx.viewpic');
    var FarmhousejbxxImp = require('../ctrl/farmhousejbxx.imp');
    var FarmhousejbxxExp = require('../ctrl/farmhousejbxx.exp');

  var FarmhousejbxxLoad = require('../ctrl/farmhousejbxx.load');

    var Farmhousejbxx = Page.extend(function () {
        this.injecte([
            new FarmhousejbxxAdd('farmhousejbxx_add'),
            new FarmhousejbxxEdit('farmhousejbxx_edit'),
            /*new FarmhousejbxxBetter('farmhousejbxx_better'),*/
            new FarmhousejbxxView('farmhousejbxx_view'),
            new FarmhousejbxxRemove('farmhousejbxx_remove'),
            new FarmhousejbxxFj('farmhousejbxx_fj'),
            new FarmhousejbxxViewpic('farmhousejbxx_viewpic'),
            new FarmhousejbxxImp('farmhousejbxx_imp'),
            new FarmhousejbxxExp('farmhousejbxx_exp'),
            new FarmhousejbxxLoad('farmhousejbxx_load')
        ]);
        var administrativevillage;//行政村
        var _self;
        // @override
        this.load = function (panel, vid, unitcode, fullpath) {
            var table = this.table = panel.find('table');
            administrativevillage = null;//初始化
            _self = this;
            this.$autoHeight('north', panel.find('#farmhouse-info-main', panel));
            var url = "service/utils/farmhousejbxxHouseVillage";

            if(vid != null && vid != undefined && vid != 'undefined' && vid != '' && vid != 'null'){
                panel.find("#s_farmhouse_vid").val(vid);
                url += '?vid='+vid;
              Core.ajax(Config.ContextPath + 'service/sjcj/villagejbxx/' + vid, {
                type: 'json',
                method: 'get'
              }).then(function (data) {
                if(data != null ){
                  administrativevillage = data.administrativevillage;
                }
              });
            } else if(unitcode != null && unitcode != undefined && unitcode != 'undefined' && unitcode != '' && unitcode != 'null'){
                panel.find("#s_farmhouse_unitcode").val(unitcode);
                url += '?parentUnitCode='+unitcode;
            }
            if(fullpath != null && fullpath != undefined && fullpath != 'undefined' && fullpath != '' && fullpath != 'null'){
                panel.find("#s_farmhouse_fullpath").val(fullpath);
            }
            table.cdatagrid({
                controller: this,
                url: url,
                rowStyler:function (index,rowData){
                    if(rowData && rowData.isbetter == 'F'){
                        return 'color:#EE2C2C';
                    } if(rowData && (rowData.isbetter == 'P' || rowData.isbetter == 'B' || rowData.isbetter == 'S')){
                        return 'color:#FF7F00';
                    } if(rowData && rowData.isbetter == 'T'){
                        return 'color:#224b8f';
                    }
                },
                pageList:[10,20,50,100,500],
            });

            //第一次加载
            panel.find('#sjsecond').combobox({
                url: Config.ContextPath + "service/jhgswork/getUnitInfoSecond?code=320000000000",
                valueField: 'unitCode',
                textField: 'unitName',
                onLoadSuccess: function (data) {
                    var da = data[0];
                    if (da != undefined) {
                        if (da["yhjb"] == "fsj") {
                            $('#sjsecond').combobox('select', da["unitCode"]);
                            $("#sjsecond").combobox('readonly', true);
                        }
                    }

                }
            });
            panel.find('#sjthird').combobox({
                url: Config.ContextPath + "service/jhgswork/getUnitInfothird",
                valueField: 'unitCode',
                textField: 'unitName',
                onLoadSuccess: function (data) {
                    var da = data[0];
                    if (da != undefined) {
                        if (da["yhjb"] == "fsj") {
                            $('#sjthird').combobox('select', da["unitCode"]);
                            $("#sjthird").combobox('readonly', true);
                        }
                    }

                }
            });
            panel.find('#sjfourth').combobox({
                url: Config.ContextPath + "service/jhgswork/getUnitInfofourth",
                valueField: 'unitCode',
                textField: 'unitName',
                onLoadSuccess: function (data) {
                    var da = data[0];
                    if (da != undefined) {
                        if (da["yhjb"] == "fsj") {
                            $('#sjfourth').combobox('select', da["unitCode"]);
                            $("#sjfourth").combobox('readonly', true);
                        }
                    }

                }
            });


            panel.find('#sjsecond').combobox({
                onChange: function() {
                    var code = panel.find('#sjsecond').combobox('getValue');
                    panel.find('#sjthird').combobox('clear');
                    // 重新获取数据
                    panel.find('#sjthird').combobox('reload', Config.ContextPath+'service/jhgswork/getUnitInfothird?code=' + code);
                }
            });
            panel.find('#sjthird').combobox({
                onChange: function() {
                    var code = panel.find('#sjthird').combobox('getValue');
                    panel.find('#sjfourth').combobox('clear');
                    // 重新获取数据
                    panel.find('#sjfourth').combobox('reload', Config.ContextPath+'service/jhgswork/getUnitInfofourth?code=' + code);
                }
            });

            panel.find('#sjfourth').combobox({
                onChange: function() {
                    var code = panel.find('#sjfourth').combobox('getValue');
                    panel.find('#sjfive').combobox('clear');
                    // 重新获取数据
                    panel.find('#sjfive').combobox('reload', Config.ContextPath+'service/userinfo2/getUnitsByLoginAndUnitCode/5/' + code);
                }
            });



            //上一页
          panel.find("#farmhousejbxx_prev").on("click",function(){
                var url = Config.ContextPath + 'modules/sjcj/villagejbxx/villagejbxx.jsp';
                if(administrativevillage == null || administrativevillage == ""){
                  if(vid != null && vid != "" && vid != "null"){
                    Core.ajax(Config.ContextPath + 'service/sjcj/villagejbxx/' + vid, {
                      type: 'json',
                      method: 'get'
                    }).then(function (data) {
                      if(data != null ){
                        administrativevillage = data.administrativevillage;
                      }
                      if(administrativevillage != null && administrativevillage != ""){
                        url  += "?unitCode=" + administrativevillage;
                      }
                      Events.trigger('open.MenuTab', {
                        id: 'aa',
                        text: '村庄基础信息录入',
                        url: url,
                        closable: true
                      });
                    });
                  } else {
                    Events.trigger('open.MenuTab', {
                      id: 'aa',
                      text: '村庄基础信息录入',
                      url: url,
                      closable: true
                    });
                  }

                } else {
                  url  += "?unitCode=" + administrativevillage;
                  Events.trigger('open.MenuTab', {
                    id: 'aa',
                    text: '村庄基础信息录入',
                    url: url,
                    closable: true
                  });
                }


            });

            //下一页
          panel.find("#farmhousejbxx_next").on("click",function(){
                var url = Config.ContextPath + 'modules/sjcj/newhousingjbxx/newhousingjbxx.jsp';
                var tempvid = _self.panel.find("#s_farmhouse_vid").val();
                if(tempvid != null && tempvid != ""){
                  url += "?vid=" + tempvid;
                }
                Events.trigger('open.MenuTab', {
                    id: 'aa',
                    text: '改善项目信息录入',
                    url: url,
                    closable: true
                });
            });

            //根据权限设置操作按钮:镇级有新增、修改和删除按钮，管理员有修改和删除按钮
            Core.ajax(Config.ContextPath+'service/common/getLoginUserRoles', {
                method: 'get'
            }).then(function(rlt) {
                var isZj = false;
                var isAdmin = false;
                var isck = false;//仅保留查看功能
                for(var i = 0 ; i < rlt.length ; i++){
                    if(rlt[i].roleCode == '0013'){
                        isZj = true;
                    }
                    if(rlt[i].roleCode == 'sysadmin'){
                        isAdmin = true;
                    }
                    if(rlt[i].roleCode == '0015'){
                        isck = true;
                    }
                }
                // 非镇级用户 或 无村庄id时 没有修改权限
                if(isAdmin){
                    panel.find("#farmhousejbxx_add_btn").parent("td").next().remove();
                    panel.find("#farmhousejbxx_add_btn").remove();
                    panel.find("#fh_isAdmin").val("T");
                } else if(!isZj){
                    panel.find("#farmhousejbxx_add_btn").parent("td").next().remove();
                    panel.find("#farmhousejbxx_add_btn").remove();
                    panel.find("#farmhousejbxx_edit_btn").parent("td").next().remove();
                    panel.find("#farmhousejbxx_edit_btn").remove();
                    panel.find("#farmhousejbxx_better_btn").parent("td").next().remove();
                    panel.find("#farmhousejbxx_better_btn").remove();
                    panel.find("#farmhousejbxx_imp_btn").parent("td").next().remove();
                    panel.find("#farmhousejbxx_imp_btn").remove();
                    panel.find("#farmhousejbxx_remove_btn").parent("td").next().remove();
                    panel.find("#farmhousejbxx_remove_btn").remove();

                    panel.find("#farmhouse_cy-btn-position").hide();
                }

                if(isck){
                    panel.find("#farmhousejbxx_load_btn").parent("td").next().remove();
                    panel.find("#farmhousejbxx_load_btn").remove();
                    panel.find("#farmhousejbxx_exp_btn").parent("td").next().remove();
                    panel.find("#farmhousejbxx_exp_btn").remove();
                }
            });

            // 重置按钮 - 重新填充被清空的隐藏条件
            panel.find('#farmhousejbxx_reset_btn').click(function() {
                if(vid != null && vid != undefined && vid != 'undefined' && vid != '' && vid != 'null'){
                    panel.find("#s_farmhouse_vid").val(vid);
                } else if(unitcode != null && unitcode != undefined && unitcode != 'undefined' && unitcode != '' && unitcode != 'null'){
                    panel.find("#s_farmhouse_unitcode").val(unitcode);
                }
            });
        };

    });

    return Farmhousejbxx;
});
