define(function(require) {
	var Config = require('config');
	var Page = require('core/page');
	var Core = require('core/core');
	var $ = require('jquery');
    var ajaxSubmit = require('plugins/jquery.form');


    var FarmhousejbxxImp = Page.extend(function() {
		var _self = this;	
		var _data;
		// @override
		this.load = function(panel, data) {
			_data = data;
			var form = panel.find('form');
            form.form('disableValidation');



            // 行政村、自然村联动
            panel.find('#newhousingjbxx_administrativevillage').combobox({
                onChange: function (newValue, oldValue) {
                    if (newValue != null){
                        panel.find('#newhousingjbxx_vid').combobox("clear");
                        panel.find('#newhousingjbxx_vid').combobox('reload', Config.ContextPath + 'service/sjcj/villagejbxx/list2?administrativevillage=' + newValue);
                    }
                }
            });

            panel.find("#farmhouse_imp_btn").click(function() {

                var vid = panel.find("#newhousingjbxx_vid").val();
                if(vid==''||vid==null ||vid==undefined){
                    $.messager.alert('警告', '请先选择自然村', 'warning');
                    return false;
                }
                var form = panel.find('form');

                form.form('enableValidation');
                var isValid = form.form('validate');

                if (isValid) {
                    panel.find("#farmhouse_imp_form").ajaxSubmit({
                        url: Config.ContextPath + 'service/sjcj/farmhousejbxx/imp',
                        type: 'post',

                        error: function () {
                            $.messager.alert('警告', '导入失败！', 'warning');
                        },
                        success: function (rlt) {
                            if (rlt.code == 0) {
                                panel.find("#succ_div").html(rlt.data.succCnt);

                                var failedHtml = '共' + rlt.data.failedArr.length + '条<br>';
                                $.each(rlt.data.failedArr, function (index, item) {
                                    failedHtml += ' 行号:' + item.rowNo;
                                    failedHtml += ' &nbsp;&nbsp;失败原因:【' + item.colName + '】';
                                    if (item.value != null && !item.value == '') {
                                        failedHtml += '("' + item.value + '") ';
                                    }
                                    failedHtml += item.errMsg;
                                    if (item.validValue != null && !item.validValue == '') {
                                        failedHtml += ' &nbsp;&nbsp;可选值 [' + item.validValue + ']';
                                    }
                                    failedHtml += '<br>';
                                });
                                panel.find("#fail_div").html(failedHtml);
                            } else {
                                $.messager.alert('警告', rlt.message, 'warning');
                            }
                        }
                    });
                }
            });
		};

		// @override
		this.submit = function(panel, data, closeCallback) {
            closeCallback();
			return false;
		};
		
		// @override 
		this.onClose = function(table, data) {
			table.datagrid('reload');
		};
	});
	
	return FarmhousejbxxImp;
});