define(function (require) {
    var Config = require('config');
    var Page = require('core/page');
    var Core = require('core/core');
    var $ = require('jquery');

    var FarmhousejbxxFj = Page.extend(function () {
        var _self = this;
        var _data;
        // @override
        this.load = function (panel, data) {
            _data = data;
            var form = panel.find('form');
            form.form('disableValidation')
                .form('focus');

            panel.find('#farmhouse_uploader_beforein').click(function () {
                showUploadDialog('beforein');
            });
            panel.find('#farmhouse_uploader_beforeout').click(function () {
                showUploadDialog('beforeout');
            });
            panel.find('#farmhouse_uploader_afterin').click(function () {
                showUploadDialog('afterin');
            });
            panel.find('#farmhouse_uploader_afterout').click(function () {
                showUploadDialog('afterout');
            });

            reloadImage();
        };

        function showUploadDialog(type1) {
            new BUpload({
                upload_url: Config.ContextPath + 'service/utils/images/uploadFile?type=1&rid=' + _data.fid + '&type1=' + type1,
                ext_allow: "png|jpg|jpeg",
                ext_refuse: "exe|bat",
                max_filesize: 5120, //KB
                max_filenum: 10,
                callback: function () {
                    reloadImage();
                }
            });
        }

        function reloadImage() {
            Core.ajax(Config.ContextPath + 'service/utils/images/getAttachmentsBTY/1/' + _data.fid, {
                type: 'json',
                method: 'get'
            }).then(function (data) {
                $('#imgcontainer_beforein').empty();
                $('#imgcontainer_beforeout').empty();
                $('#imgcontainer_afterin').empty();
                $('#imgcontainer_afterout').empty();
                $.each(data.fjList, function (index, item) {
                    // 主
                    var itemdiv = $('<div>', {}).css({
                        height: '113px',
                        margin: '3px',
                        float: 'left',
                        position: 'relative'
                    }).appendTo($('#imgcontainer_' + item.type1));

                    // 图片
                    var img = $('<img>', {
                        src: 'data:image/jpg;base64,' + item.efj
                    }).css({
                        height: '100%'
                    }).appendTo(itemdiv);

                    // 工具条
                    var toolbar = $('<div>', {}).css({
                        position: 'absolute',
                        background: 'rgba(0, 0, 0, 0.5) none repeat scroll 0% 0%',
                        width: '100%',
                        height: '26px',
                        top: '0px',
                        left: '0px',
                        display: 'none'
                    }).appendTo(itemdiv);

                    // 删除按钮
                    var delBtn = $('<span>', {}).css({
                        width: '24px',
                        height: '24px',
                        display: 'inline',
                        float: 'right',
                        background: 'url("' + Config.ContextPath + 'ui/js/bupload/css/images/icons.png") no-repeat',
                        margin: '5px 1px 1px',
                        cursor: 'pointer',
                        'background-position': '-48px -24px'
                    }).appendTo(toolbar);

                    itemdiv.on('mouseover', function () {
                        toolbar.show();
                    }).on('mouseout', function () {
                        toolbar.hide();
                    });

                    delBtn.on('mouseover', function () {
                        delBtn.css('background-position', '-48px -0px');
                    }).on('mouseout', function () {
                        delBtn.css('background-position', '-48px -24px');
                    });

                    delBtn.click(function () {
                        $.messager.alert('提示', '是否确认删除？', 'question', function () {
                            Core.ajax(Config.ContextPath + 'service/utils/images/' + item.iid, {
                                type: 'json',
                                method: 'post',
                                data: {
                                    _method: 'delete'
                                }
                            }).then(function (rlt) {
                                if (rlt.isOk) {
                                    $.messager.alert('提醒', '删除成功！');
                                    reloadImage();
                                } else {
                                    $.messager.alert('提醒', '删除失败，原因：' + rlt.msg, 'warning');
                                    return false;
                                }
                            });
                        });
                    });
                });
            });
        }

        // @override
        this.submit = function (panel, data, closeCallback) {
            closeCallback();

            return false;
        };

        // @override
        this.onClose = function (table, data) {
            // table.datagrid('reload');
        };
    });

    return FarmhousejbxxFj;
});