define(function(require) {
	var Config = require('config');
	var Core = require('core/core');
    var Dialog = require('centit/centit.dialog');
    var Events = require('core/events');

	var FarmhousejbxxAdd = require('./farmhousejbxx.add');


	var FarmhousejbxxEdit = FarmhousejbxxAdd.extend(function() {
		var _self;
		var gsShow;
        this.renderButton = function (btn, data) {
            var flag = true;
            var fh_isAdmin = this.parent.panel.find("#fh_isAdmin").val();
            if(data.isbetter == "T" && fh_isAdmin != "T"){
                flag = false;
            }
            return flag;
        };
		// @override
		this.load = function(panel, ldata) {
            this.loadSomething(panel,ldata);
		};

		this.loadSomething = function(panel, ldata) {
            var form = panel.find('form');
            _self = this;
            var isbetterYm = panel.find("#farmhouse_isbetter").val();//农房跟踪界面带入参数，为改善和计划中编辑后状态变为改善中
            if(isbetterYm != null && isbetterYm != '' && isbetterYm != 'null' && (ldata.isbetter == "F" || ldata.isbetter == "P")){
                ldata.isbetter = isbetterYm;
            }
            if(ldata.isbetter == 'P' || ldata.isbetter == 'T' || ldata.isbetter == 'B' || ldata.isbetter == 'S'){//计划中或已改善可编辑改善信息
                gsShow = true;
            } else {
                gsShow = false;
            }
            Core.ajax(Config.ContextPath+'service/sjcj/farmhousejbxx/'+ldata.fid, {
                type: 'json',
                method: 'get'
            }).then(function(data) {
                if(isbetterYm != null && isbetterYm != '' && isbetterYm != 'null' && (data.isbetter == "F" || data.isbetter == "P")  ){
                    data.isbetter = isbetterYm;
                }
                if(data.persontype != null && data.persontype != ""){
                  data.isPersontype = "T";
                } else {
                  data.isPersontype = "F";
                }
                _self.data = data;
                _self.data.memberCnt = 0;
                //自然村下拉列表初始化
                if(data.administrativeVillage != null && data.administrativeVillage.length > 0){
                    panel.find('#farmhouse_vid').combobox('reload', Config.ContextPath + 'service/sjcj/villagejbxx/list2?administrativevillage=' + data.administrativeVillage);
                }

                //地图是否定位
                if(data.longit != null && data.longit != '' && data.lat != null && data.lat != ''){
                    panel.find("#farmhouse_located").show();
                    panel.find("#farmhouse_unlocated").hide();
                }

                for(var i = 0; i < data.householdregisterjbxxList.length; i++) {
                    var householdregisterjbxx = data.householdregisterjbxxList[i];
                    if(householdregisterjbxx.isHz === 'T') {//户主信息显示
                        data.fname = householdregisterjbxx.fname;
                        data.pid = householdregisterjbxx.pid;
                        data.familyIncome = householdregisterjbxx.familyIncome;
                        data.tel = householdregisterjbxx.tel;
                        data.familyNum = householdregisterjbxx.familyNum;
                        data.hid = householdregisterjbxx.hid;
                    } else {//非户主动态展示
                        loadOtherFamily(householdregisterjbxx);
                    }
                }


                if(gsShow){
                    panel.find("#farmhouse_gsxx").show();
                    //改善后-地图是否定位
                    if(data.longit2 != null && data.longit2 != '' && data.lat2 != null && data.lat2 != ''){
                        panel.find("#farmhouse2_located").show();
                        panel.find("#farmhouse2_unlocated").hide();
                    }
                }


                form.form('load', data)
                    .form('disableValidation')
                    .form('focus');

                //加载图片
                reloadImage();
            });

            //地图定位功能-经纬度为空时取页面选择的自然村经纬度
            panel.find('#farmhouse_location').click(function() {
                var lng = panel.find('#farmhouse_input_lng').val();
                var lat = panel.find('#farmhouse_input_lat').val();
                if(lng != null && lng != '' && lat != null && lat != ''){
                    mapDialog(lng,lat);
                } else {
                    var administrativevillage = _self.panel.find("#farmhouse_administrativevillage").val();
                    var vid = _self.panel.find("#farmhouse_vid").val();
                    if(administrativevillage == null || administrativevillage.length < 1){
                        $.messager.alert('提醒', '检查行政村未选择！请依次选择行政村自然村再点击“定位”按钮！','warning');
                    } else if(vid == null || vid.length < 1){
                        $.messager.alert('提醒', '检查自然村未选择！请依次选择行政村自然村再点击“定位”按钮！','warning');
                    } else {
                        Core.ajax(Config.ContextPath+'service/sjcj/villagejbxx/' + vid, {
                            type: 'json',
                            method: 'get'
                        }).then(function(rlt) {
                            lng = rlt.longit;
                            lat = rlt.lat;
                            mapDialog(lng,lat);
                        });
                    }
                }
            });

            //重新选择改善项目
            panel.find('#reNewhousingBtn').click(function() {
                var farm_bettertype = _self.panel.find("#farm_bettertype").combobox('getValue');
                if(farm_bettertype == 3 || farm_bettertype == 5){
                    var reid = "reNewhousingBtn";
                    SelectUser = require('modules/sjcj/newhousingjbxx/ctrl/newhousingjbxx.choose');
                    url = "modules/sjcj/newhousingjbxx/newhousingjbxxChoose.jsp";
                    var _SelectUser = new SelectUser(reid);
                    _self.controllers[reid] = _SelectUser;
                    _SelectUser.parent = _self;
                    Dialog.open({
                        id: reid,
                        title: "重新选择改善项目",
                        href: url,
                        width: 600,
                        height: 450
                    }, {'bettertype': farm_bettertype}, _self.controllers[reid]);
                } else {
                    $.messager.alert('提醒', '只有改善类型为新建新型农村社区或者小城镇集中安置区可重新选择改善项目，请先确定农房改善类型！','warning');
                }

            });

            if(gsShow){
                //改善后-地图定位功能-经纬度为空时先取改善前经纬度
                panel.find('#farmhouse2_location').click(function() {
                    var lng2 = panel.find('#farmhouse2_input_lng').val();
                    var lat2 = panel.find('#farmhouse2_input_lat').val();
                    if(lng2 != null && lng2 != '' && lat2 != null && lat2 != ''){
                        mapDialog2(lng2,lat2);
                    } else {
                        var lng = panel.find('#farmhouse_input_lng').val();
                        var lat = panel.find('#farmhouse_input_lat').val();
                        if(lng != null && lng != '' && lat != null && lat != ''){
                            mapDialog2(lng,lat);
                        } else {
                            $.messager.alert('提醒', '请先对农房基础信息定位！','warning');
                        }
                    }
                });
            }

            //动态增加其他家庭成员信息
            panel.find('#add_member_btn').click(function() {
                loadOtherFamily();
            });
            // 行政村、自然村联动
            panel.find('#farmhouse_administrativevillage').combobox({
                onChange: function (newValue, oldValue) {
                    if (newValue != null){
                        panel.find('#farmhouse_vid').combobox("clear");
                        panel.find('#farmhouse_vid').combobox('reload', Config.ContextPath + 'service/sjcj/villagejbxx/list2?administrativevillage=' + newValue);
                    }
                }
            });

            //图片上传
            panel.find('#farmhouse_uploader_beforein').click(function () {
                showUploadDialog('beforein');
            });
            panel.find('#farmhouse_uploader_beforeout').click(function () {
                showUploadDialog('beforeout');
            });
            if(gsShow){
                panel.find('#farmhouse_uploader_afterin').click(function () {
                    showUploadDialog('afterin');
                });
                panel.find('#farmhouse_uploader_afterout').click(function () {
                    showUploadDialog('afterout');
                });
            }
        }

        //打开地图
        function mapDialog(lng,lat){
            $('#map_iframe_farmhouse').attr("src","../../modules/sjcj/map/locationmap.jsp?dialogname=farmhouse_map_dialog&module=farmhouse&lng=" + lng + "&lat=" + lat+"&nfjbxx=1");
            $('#farmhouse_map_dialog').dialog({
                title: '农房地点',
                width: 900,
                height: 600
            });
        }
        //改善后打开地图
        function mapDialog2(lng,lat){
            $('#map_iframe_farmhouse2').attr("src","../../modules/sjcj/map/locationmap.jsp?dialogname=farmhouse2_map_dialog&module=farmhouse2&lng=" + lng + "&lat=" + lat);
            $('#farmhouse2_map_dialog').dialog({
                title: '农房地点',
                width: 900,
                height: 600
            });
        }
		//加载其他家庭成员信息-同时增加
		function loadOtherFamily(householdregisterjbxx){
            var container = _self.panel.find('#farmhouseinfo_member_div');
            var fname = '';
            if(householdregisterjbxx != null && householdregisterjbxx.fname != null){
                fname = householdregisterjbxx.fname;
            }
            var pid = '';
            if(householdregisterjbxx != null && householdregisterjbxx.pid != null){
                pid = householdregisterjbxx.pid;
            }
            var tel = '';
            if(householdregisterjbxx != null && householdregisterjbxx.tel != null){
                tel = householdregisterjbxx.tel;
            }
            var html =      '<div class="field required"><label>其他家庭成员姓名</label><input type="text" class="easyui-textbox" style="width: 250px" id="farmhouseinfo_fname-'
                             + _self.data.memberCnt + '" name="fname_' + _self.data.memberCnt + '" value="' + fname + '" required/>' +
                '            </div>' +
                '            <div class="field required">' +
                '                <label>其他家庭成员身份证号</label>' +
                '                <input type="text" class="easyui-textbox" style="width: 250px" id="farmhouseinfo_pid-' + _self.data.memberCnt + '"' +
                '                       name="pid_' + _self.data.memberCnt + '" value="' + pid + '" required/>' +
                '            </div>' +
                '            <div class="field">' +
                '                <label>其他家庭成员联系电话</label>' +
                '                <input type="text" class="easyui-textbox" style="width: 250px" id="farmhouseinfo_tel-' + _self.data.memberCnt + '"' +
                '                       name="tel_' + _self.data.memberCnt + '" value="' + tel + '" />' +
                '            </div>' +
                '            <div class="field">' +
                '                <label>&nbsp;</label>' +
                '                <a class="selfBtn1 easyui-linkbutton btn-search" style="width: 125px" id="remove_member_btn-' + _self.data.memberCnt + '">删除家庭成员</a>' +
                '            </div>';
            var itemdiv = $('<div>', {
                id: 'farmhouseinfo_member_div-' + _self.data.memberCnt,
                class: 'four fields'
            }).css({
                'margin-left': '0px'
            }).html(html).appendTo(container);
            _self.panel.find('#remove_member_btn-' + _self.data.memberCnt).click(function() {
                var id = this.id.split('-')[1];
                _self.panel.find('#farmhouseinfo_member_div-' + id).remove();
            });
            $.parser.parse(container);
            _self.data.memberCnt++;
        }

		// @override
		this.submit = function(panel, data, closeCallback) {
			var form = panel.find('form');
			// 开启校验
			form.form('enableValidation');
			var isValid = form.form('validate');
			if (isValid) {
                var obj = form.form("value");
                var reg = /(^\d{15}$)|(^\d{18}$)|(^\d{17}(\d|X|x)$)/;
                for(var i = 0; i < data.memberCnt; i++) {
                    if(obj['pid_'+i] != undefined) {
                        if(reg.test(obj['pid_'+i]) == false) {
                            $.messager.alert('提醒', obj['fname_'+i] + ' 身份证号输入不合法！','warning');
                            return false;
                        }
                    }
                }
                if(reg.test(obj.pid) == false) {
                    $.messager.alert('提醒', '户主身份证号输入不合法！','warning');
                    return  false;
                } else if (obj.isbetter === 'T' && (obj.longit2 === "" || obj.longit2 === undefined)) {
                    $.messager.alert('提醒', '请定位现居住地位置！');
                    return false;
                } else if(obj.infrastructure.length > 500) {
                    $.messager.alert('提醒', '周边基础设施不得超过300字！','warning');
                    return false;
                } else if(obj.vid == null || obj.vid.length < 1) {
                    $.messager.alert('提醒', '自然村不可以为空！','warning');
                    return false;
                }  else if(obj.isPersontype == "T" && (obj.persontype == null || obj.persontype == "")){
                    $.messager.alert('提醒', '是四类人群时，需填写四类人群类型！', 'warning');
                    return false;
                }  else {
                    /*if(gsShow){//如果编辑改善信息，增加校验
                        if(obj.bettertype == null || obj.bettertype  == ''){
                            $.messager.alert('提醒', '改善类型不可以为空！','warning');
                            return false;
                        }else if (obj.housingarea === "" || obj.housingarea === undefined) {
                            $.messager.alert('提醒', '房屋改善前面积不可以为空！','warning');
                            return false;
                        } else if (obj.housingstructure === "" || obj.housingstructure === undefined) {
                            $.messager.alert('提醒', '改善前住房结构不可以为空！','warning');
                            return false;
                        } else if (obj.layernum === "" || obj.layernum === undefined) {
                            $.messager.alert('提醒', '改善前层数不可以为空！','warning');
                            return false;
                        }else if (obj.oldarea === "" || obj.oldarea === undefined) {
                            $.messager.alert('提醒', '协议拆除旧房面积不可以为空！','warning');
                            return false;
                        }else if (obj.outarea === "" || obj.outarea === undefined) {
                            $.messager.alert('提醒', '协议退出宅基地面积不可以为空！','warning');
                            return false;
                        }
                    }*/
                    var isbetter = obj.isbetter;
                    if(isbetter == "P"){//计划中第一次保存编辑状态改为改善中
                        panel.find("#farmhouse_isbetter").combobox('setValue', 'B');
                    }
                    form.form('ajax', {
                        url: Config.ContextPath + 'service/sjcj/farmhousejbxx',
                        method: 'post',
                        data: {
                            "memberCnt": data.memberCnt,
                        }
                    }).then(closeCallback);
                }
			}

			return false;
		};

		this.submitBetter = function (panel, data, closeCallback) {
      //如改善类型为“新型农村社区”或“小城镇集中安置区”，检验项目是否竣工交付
      Core.ajax(Config.ContextPath+'service/sjcj/newhousingjbxx/getNewhousingjbxxByFid/'+data.fid, {
        type: 'json',
        method: 'get'
      }).then(function(newh) {
        var b = true;
        if(data.bettertype == 3 || data.bettertype == 5){
          if(newh != null && newh.progress != 6 && newh.progress != 7){
            b = false;
          }
        }
        if(b){
          $.messager.confirm("操作提示","是否确认此农户已改善？",function(b){
            if(b){
              var form = panel.find('form');
              // 开启校验
              form.form('enableValidation');
              var isValid = form.form('validate');
              if (isValid) {
                var obj = form.form("value");
                var reg = /(^\d{15}$)|(^\d{18}$)|(^\d{17}(\d|X|x)$)/;
                for(var i = 0; i < data.memberCnt; i++) {
                  if(obj['pid_'+i] != undefined) {
                    if(reg.test(obj['pid_'+i]) == false) {
                      $.messager.alert('提醒', obj['fname_'+i] + ' 身份证号输入不合法！','warning');
                      return false;
                    }
                  }
                }
                if(reg.test(obj.pid) == false) {
                  $.messager.alert('提醒', '户主身份证号输入不合法！','warning');
                  return  false;
                }  else if (obj.housingarea === "" || obj.housingarea === undefined) {
                  $.messager.alert('提醒', '房屋改善前面积不可以为空！','warning');
                  return false;
                } else if (obj.housingstructure === "" || obj.housingstructure === undefined) {
                  $.messager.alert('提醒', '改善前住房结构不可以为空！','warning');
                  return false;
                } else if (obj.layernum === "" || obj.layernum === undefined) {
                  $.messager.alert('提醒', '改善前层数不可以为空！','warning');
                  return false;
                }else if (obj.oldarea === "" || obj.oldarea === undefined) {
                  $.messager.alert('提醒', '协议拆除旧房面积不可以为空！','warning');
                  return false;
                } else if (obj.outarea === "" || obj.outarea === undefined) {
                  $.messager.alert('提醒', '协议退出宅基地面积不可以为空！','warning');
                  return false;
                } else if (obj.isbetter === 'T' && (obj.longit2 === "" || obj.longit2 === undefined)) {
                  $.messager.alert('提醒', '请定位现居住地位置！');
                  return false;
                } else if(obj.infrastructure.length > 500) {
                  $.messager.alert('提醒', '周边基础设施不得超过300字！','warning');
                  return false;
                } else if(obj.vid == null || obj.vid.length < 1) {
                  $.messager.alert('提醒', '自然村不可以为空！','warning');
                  return false;
                } else if(obj.bettertype == null || obj.bettertype  == ''){//确认改善增加改善信息校验
                  $.messager.alert('提醒', '确认改善时，改善类型不可以为空！','warning');
                  return false;
                } else if(obj.housingaddress == null || obj.housingaddress  == ''){//确认改善增加改善信息校验
                  $.messager.alert('提醒', '确认改善时，改善后-现居住地详址不可以为空！','warning');
                  return false;
                } else if(obj.housingarea2 == null || obj.housingarea2  == ''){//确认改善增加改善信息校验
                  $.messager.alert('提醒', '确认改善时，改善后-住房面积不可以为空！','warning');
                  return false;
                } else if(obj.oldarea2 == null || obj.oldarea2  == ''){//确认改善增加改善信息校验
                  $.messager.alert('提醒', '确认改善时，改善后-已拆除旧房面积不可以为空！','warning');
                  return false;
                }  else if(obj.outarea2 == null || obj.outarea2  == ''){//确认改善增加改善信息校验
                  $.messager.alert('提醒', '确认改善时，改善后-已退出宅基地面积不可以为空！','warning');
                  return false;
                }  else if(obj.longit2 == null || obj.longit2  == '' || obj.lat2 == null || obj.lat2  == ''){//确认改善增加改善信息校验
                  $.messager.alert('提醒', '确认改善时，改善后位置必须定位！','warning');
                  return false;
                } else {
                    Core.ajax(Config.ContextPath + 'service/utils/images/isImages/1/' + obj.fid + "/beforein@beforeout@afterin@afterout", {
                        type: 'json',
                        method: 'get'
                    }).then(function (isData) {//校验图片是否全部上传
                        if(!isData.b){
                            $.messager.alert('提醒', "系统检测到有图片未上传，请先上传全部图片信息再确认改善！",'warning');
                        } else {
                            if(obj.realityyear == null || obj.realityyear == ''){//确认改善时年份为空保存当前年份
                                var day = new Date();
                                panel.find("#fmh_realityyear").combobox('setValue', day.getFullYear());
                                obj.realityyear = day.getFullYear();
                            }
                            //校验：判断此年的实际改善流程主要是否被省厅审核，已审核通过的不可再增加确认改善--》修改，已提交和被审核的不可再添加
                            Core.ajax(Config.ContextPath+'service/common/statisticsList/getStatisticsListByYear/2/' + obj.realityyear + "/" + obj.fid, {
                                type: 'json',
                                method: 'get'
                            }).then(function(st) {
                                if(st != null && st.status != "01" && st.status != "04"){//不在维护者或已退回状态
                                    //$.messager.alert('提醒', "实际改善年份-"+obj.realityyear + '年已实际改善信息已上报并通过省厅审核，不可再增加确认改善信息！','warning');
                                    $.messager.alert('提醒', "实际改善年份-"+obj.realityyear + '年已实际改善信息已上报，不可再增加确认改善信息！','warning');
                                    return false;
                                } else {
                                    //暂时增加设置，不可添加18、19年确认改善数据,allow2019codes:为某些地区开放权限
                                    /*if(obj.realityyear < 2020){
                                        $.messager.alert('提醒', '2018年、2019年确认改善农房清单已锁定，实际改善年份请勿填写2018年或2019年！','warning');
                                        return false;
                                    } else {*/
                                        panel.find("#farmhouse_isbetter").combobox('setValue', 'S');
                                        form.form('ajax', {
                                            url: Config.ContextPath + 'service/sjcj/farmhousejbxx',
                                            method: 'post',
                                            data: {
                                                "memberCnt": data.memberCnt,"allow2019codes2":"320904000000,320923000000"
                                            }
                                        }).then(closeCallback);
                                    //}

                                }
                            });
                        }
                    });

                }
              }
            }
          });
        } else {
          $.messager.alert('提醒', '确认改善失败，系统检测到改善项目未竣工交付，不允许确认改善！请先到改善项目中修改实施情况。','warning');
          return false;
        }
      });
      return false;
    }

		// @override
		this.onClose = function(table) {
			table.datagrid('reload');
		};

        function markLocated(id) {
            $("#" + id + "_located").show();
            $("#" + id + "_unlocated").hide();
        }
        function markUnlocated(id) {
            $("#" + id + "_located").hide();
            $("#" + id + "_unlocated").show();
        }

        function showUploadDialog(type1) {
            new BUpload({
                upload_url: Config.ContextPath + 'service/utils/images/uploadFile?type=1&rid=' + _self.data.fid + '&type1=' + type1,
                ext_allow: "png|jpg|jpeg",
                ext_refuse: "exe|bat",
                max_filesize: 1024, //KB
                max_filenum: 10,
                callback: function () {
                    reloadImage();
                }
            });
        }

        function reloadImage() {
            Core.ajax(Config.ContextPath + 'service/utils/images/getAttachmentsBTY/1/' + _self.data.fid, {
                type: 'json',
                method: 'get'
            }).then(function (data) {
                $('#imgcontainer_beforein').empty();
                $('#imgcontainer_beforeout').empty();
                $('#imgcontainer_afterin').empty();
                $('#imgcontainer_afterout').empty();
                $.each(data.fjList, function (index, item) {
                    // 主
                    var itemdiv = $('<div>', {}).css({
                        height: '113px',
                        margin: '3px',
                        float: 'left',
                        position: 'relative'
                    }).appendTo($('#imgcontainer_' + item.type1));

                    // 图片
                    var img = $('<img>', {
                        src: 'data:image/jpg;base64,' + item.efj
                    }).css({
                        height: '100%'
                    }).appendTo(itemdiv);

                    // 工具条
                    var toolbar = $('<div>', {}).css({
                        position: 'absolute',
                        background: 'rgba(0, 0, 0, 0.5) none repeat scroll 0% 0%',
                        width: '100%',
                        height: '26px',
                        top: '0px',
                        left: '0px',
                        display: 'none'
                    }).appendTo(itemdiv);

                    // 删除按钮
                    var delBtn = $('<span>', {}).css({
                        width: '24px',
                        height: '24px',
                        display: 'inline',
                        float: 'right',
                        background: 'url("' + Config.ContextPath + 'ui/js/bupload/css/images/icons.png") no-repeat',
                        margin: '5px 1px 1px',
                        cursor: 'pointer',
                        'background-position': '-48px -24px'
                    }).appendTo(toolbar);

                    itemdiv.on('mouseover', function () {
                        toolbar.show();
                    }).on('mouseout', function () {
                        toolbar.hide();
                    });

                    delBtn.on('mouseover', function () {
                        delBtn.css('background-position', '-48px -0px');
                    }).on('mouseout', function () {
                        delBtn.css('background-position', '-48px -24px');
                    });

                    delBtn.click(function () {
                        $.messager.alert('提示', '是否确认删除？', 'question', function () {
                            Core.ajax(Config.ContextPath + 'service/utils/images/' + item.iid, {
                                type: 'json',
                                method: 'post',
                                data: {
                                    _method: 'delete'
                                }
                            }).then(function (rlt) {
                                if (rlt.isOk) {
                                    $.messager.alert('提醒', '删除成功！');
                                    reloadImage();
                                } else {
                                    $.messager.alert('提醒', '删除失败，原因：' + rlt.msg, 'warning');
                                    return false;
                                }
                            });
                        });
                    });
                });
            });
        }
	});

	return FarmhousejbxxEdit;
});
