define(function(require) {
	var Config = require('config');
	var Core = require('core/core');
    var $ = require('jquery');
	var FarmhousejbxxEdit = require('./farmhousejbxx.edit');

	var FarmhousejbxxBetter = FarmhousejbxxEdit.extend(function() {
        this.renderButton = function (btn, data) {
            var flag = true;
            if(data.isbetter == "T"){
                flag = false;
            }
            return flag;
        };

        this.load = function(panel, ldata) {
            this.loadSomething(panel,ldata);
            this.panel.find("#fmh_realityyear").combobox('readonly','true');
        }

        // @override
        this.submit = function(panel, data, closeCallback) {
            //如改善类型为“新型农村社区”或“小城镇集中安置区”，检验项目是否竣工交付
            Core.ajax(Config.ContextPath+'service/sjcj/newhousingjbxx/getNewhousingjbxxByFid/'+data.fid, {
                type: 'json',
                method: 'get'
            }).then(function(newh) {
                var b = true;
                if(data.bettertype == 3 || data.bettertype == 5){
                    if(newh != null && newh.progress != 6 && newh.progress != 7){
                        b = false;
                    }
                }
                if(b){
                    $.messager.confirm("操作提示","是否确认此农户已改善？",function(b){
                        if(b){
                            var form = panel.find('form');
                            // 开启校验
                            form.form('enableValidation');
                            var isValid = form.form('validate');
                            if (isValid) {
                                var obj = form.form("value");
                                var reg = /(^\d{15}$)|(^\d{18}$)|(^\d{17}(\d|X|x)$)/;
                                for(var i = 0; i < data.memberCnt; i++) {
                                    if(obj['pid_'+i] != undefined) {
                                        if(reg.test(obj['pid_'+i]) == false) {
                                            $.messager.alert('提醒', obj['fname_'+i] + ' 身份证号输入不合法！','warning');
                                            return false;
                                        }
                                    }
                                }
                                if(reg.test(obj.pid) == false) {
                                    $.messager.alert('提醒', '户主身份证号输入不合法！','warning');
                                    return  false;
                                }  else if (obj.housingarea === "" || obj.housingarea === undefined) {
                                    $.messager.alert('提醒', '房屋改善前面积不可以为空！','warning');
                                    return false;
                                } else if (obj.housingstructure === "" || obj.housingstructure === undefined) {
                                    $.messager.alert('提醒', '改善前住房结构不可以为空！','warning');
                                    return false;
                                } else if (obj.layernum === "" || obj.layernum === undefined) {
                                    $.messager.alert('提醒', '改善前层数不可以为空！','warning');
                                    return false;
                                }else if (obj.oldarea === "" || obj.oldarea === undefined) {
                                    $.messager.alert('提醒', '协议拆除旧房面积不可以为空！','warning');
                                    return false;
                                }else if (obj.outarea === "" || obj.outarea === undefined) {
                                    $.messager.alert('提醒', '协议退出宅基地面积不可以为空！','warning');
                                    return false;
                                }

                                else if (obj.longit === "" || obj.longit === undefined) {
                                    $.messager.alert('提醒', '请定位原居住地位置！');
                                    return false;
                                } else if (obj.isbetter === 'T' && (obj.longit2 === "" || obj.longit2 === undefined)) {
                                    $.messager.alert('提醒', '请定位现居住地位置！');
                                    return false;
                                } else if(obj.infrastructure.length > 500) {
                                    $.messager.alert('提醒', '周边基础设施不得超过300字！','warning');
                                    return false;
                                } else if(obj.vid == null || obj.vid.length < 1) {
                                    $.messager.alert('提醒', '自然村不可以为空！','warning');
                                    return false;
                                } else if(obj.bettertype == null || obj.bettertype  == ''){//确认改善增加改善信息校验
                                    $.messager.alert('提醒', '确认改善时，改善类型不可以为空！','warning');
                                    return false;
                                } else if(obj.housingaddress == null || obj.housingaddress  == ''){//确认改善增加改善信息校验
                                    $.messager.alert('提醒', '确认改善时，改善后-现居住地详址不可以为空！','warning');
                                    return false;
                                } else if(obj.housingarea2 == null || obj.housingarea2  == ''){//确认改善增加改善信息校验
                                    $.messager.alert('提醒', '确认改善时，改善后-住房面积不可以为空！','warning');
                                    return false;
                                } else if(obj.oldarea2 == null || obj.oldarea2  == ''){//确认改善增加改善信息校验
                                    $.messager.alert('提醒', '确认改善时，改善后-已拆除旧房面积不可以为空！','warning');
                                    return false;
                                }  else if(obj.outarea2 == null || obj.outarea2  == ''){//确认改善增加改善信息校验
                                    $.messager.alert('提醒', '确认改善时，改善后-已退出宅基地面积不可以为空！','warning');
                                    return false;
                                }  else if(obj.longit2 == null || obj.longit2  == '' || obj.lat2 == null || obj.lat2  == ''){//确认改善增加改善信息校验
                                    $.messager.alert('提醒', '确认改善时，改善后位置必须定位！','warning');
                                    return false;
                                } else {
                                    if(obj.realityyear == null || obj.realityyear == ''){//确认改善时年份为空保存当前年份
                                        var day = new Date();
                                        panel.find("#fmh_realityyear").combobox('setValue', day.getFullYear());
                                    }
                                    panel.find("#farmhouse_isbetter").combobox('setValue', 'T');
                                    form.form('ajax', {
                                        url: Config.ContextPath + 'service/sjcj/farmhousejbxx',
                                        method: 'post',
                                        data: {
                                            "memberCnt": data.memberCnt,
                                        }
                                    }).then(closeCallback);
                                }
                            }
                        }
                    });
                } else {
                    $.messager.alert('提醒', '确认改善失败，系统检测到改善项目未竣工交付，不允许确认改善！请先到改善项目中修改实施情况。','warning');
                    return false;
                }
            });


            return false;
        };

		// @override
		this.onClose = function(table) {
			table.datagrid('reload');
		};
	});

	return FarmhousejbxxBetter;
});