define(function (require) {
  var Config = require('config');
  var Core = require('core/core');
  var Page = require('core/page');
  var $ = require('jquery');

  var FarmhousejbxxAdd = Page.extend(function () {
    var uuidVal;//此为农房id
    var _self;
    var memberCnt;//其他家庭成员数量计算
    // @override
    this.load = function (panel, data) {
      uuidVal = null;//新增初始化清除缓存
      var form = panel.find('form');
      form.form('disableValidation')
        .form('focus');

      _self = this;
      // 行政村、自然村联动
      panel.find('#farmhouse_administrativevillage').combobox({
        onChange: function (newValue, oldValue) {
          if (newValue != null) {
            panel.find('#farmhouse_vid').combobox("clear");
            panel.find('#farmhouse_vid').combobox('reload', Config.ContextPath + 'service/sjcj/villagejbxx/list2?administrativevillage=' + newValue);
          }

        }
      });

      //获取自然村坐标
      panel.find('#farmhouse_vid').combobox({
        onChange: function () {
          var vid1 = _self.panel.find("#farmhouse_vid").val();
          if (vid1 == null || vid1.length < 1) {

          } else {
            Core.ajax(Config.ContextPath + 'service/sjcj/villagejbxx/' + vid1, {
              type: 'json',
              method: 'get'
            }).then(function (rlt) {
              $("#farmhouse_input_lng").textbox('setValue', rlt.longit);
              $("#farmhouse_input_lat").textbox('setValue', rlt.lat);
            });
          }
        }
      });

      //地图定位-默认自然村位置
      panel.off('click', '#farmhouse_location');
      panel.find('#farmhouse_location').click(function () {
        var lng = _self.panel.find("#farmhouse_input_lng").val();
        var lat = _self.panel.find("#farmhouse_input_lat").val();
        if (lng != null && lng.length > 0 && lat != null && lat.length > 0) {
          mapDialog(lng, lat);
        } else {
          var administrativevillage = _self.panel.find("#farmhouse_administrativevillage").val();
          var vid = _self.panel.find("#farmhouse_vid").val();
          if (administrativevillage == null || administrativevillage.length < 1) {
            $.messager.alert('提醒', '检查行政村未选择！请依次选择行政村自然村再点击“查看定位”按钮！', 'warning');
          } else if (vid == null || vid.length < 1) {
            $.messager.alert('提醒', '检查自然村未选择！请依次选择行政村自然村再点击“查看定位”按钮！', 'warning');
          } else {
            Core.ajax(Config.ContextPath + 'service/sjcj/villagejbxx/' + vid, {
              type: 'json',
              method: 'get'
            }).then(function (rlt) {
              lng = rlt.longit;
              lat = rlt.lat;
              $("#farmhouse_input_lng").textbox('setValue', rlt.longit);
              $("#farmhouse_input_lat").textbox('setValue', rlt.lat);
              mapDialog(lng, lat);
            });
          }
        }
      });

      //打开地图
      function mapDialog(lng, lat) {
        $('#map_iframe_farmhouse').attr("src", "../../modules/sjcj/map/locationmap.jsp?dialogname=farmhouse_map_dialog&module=farmhouse&lng=" + lng + "&lat=" + lat + "&nfjbxx=1");
        $('#farmhouse_map_dialog').dialog({
          title: '农房地点',
          width: 900,
          height: 600
        });
      }

      //添加其他家庭成员
      memberCnt = 0;
      panel.find('#farmhouseinfo_member_div').empty();//其他家庭成员初始化清空
      panel.off('click', '#add_member_btn');
      panel.find('#add_member_btn').click(function () {
        var container = panel.find('#farmhouseinfo_member_div');
        var html = '<div class="field required">' +
          '<label>其他家庭成员姓名</label>' +
          '<input type="text" class="easyui-textbox" style="width: 250px" id="farmhouseinfo_fname-' + memberCnt + '"  name="fname_' + memberCnt + '" required/>' +
          '</div>' +
          '            <div class="field required">' +
          '                <label>其他家庭成员身份证号</label>' +
          '                <input type="text" class="easyui-textbox" style="width: 250px" id="farmhouseinfo_pid-' + memberCnt + '"' +
          '                       name="pid_' + memberCnt + '" required/>' +
          '            </div>' +
          '            <div class="field">' +
          '                <label>其他家庭成员联系电话</label>' +
          '                <input type="text" class="easyui-textbox" style="width: 250px" id="farmhouseinfo_tel-' + memberCnt + '"' +
          '                       name="tel_' + memberCnt + '"/>' +
          '            </div>' +
          '            <div class="field">' +
          '                <label>&nbsp;</label>' +
          '                <a class="selfBtn1 easyui-linkbutton btn-search" style="width: 125px" id="remove_member_btn-' + memberCnt + '">删除家庭成员</a>' +
          '            </div>';

        var itemdiv = $('<div>', {
          id: 'farmhouseinfo_member_div-' + memberCnt,
          class: 'four fields'
        }).css({
          'margin-left': '0px'
        }).html(html).appendTo(container);

        panel.off('click', '#remove_member_btn-' + memberCnt);
        panel.find('#remove_member_btn-' + memberCnt).click(function () {
          var id = this.id.split('-')[1];
          panel.find('#farmhouseinfo_member_div-' + id).remove();
        });

        $.parser.parse(container);
        panel.find('form').form('disableValidation');
        memberCnt++;
      });

      //图片上传
      panel.find('#farmhouse_uploader_beforein').click(function () {
        showUploadDialog('beforein');
      });
      panel.find('#farmhouse_uploader_beforeout').click(function () {
        showUploadDialog('beforeout');
      });
      panel.find('#farmhouse_uploader_afterin').click(function () {
        showUploadDialog('afterin');
      });
      panel.find('#farmhouse_uploader_afterout').click(function () {
        showUploadDialog('afterout');
      });

      //获取自然村编码,初始化
      var vid = this.parent.panel.find("#s_farmhouse_vid").val();
      if (vid != null && vid != "") {
        Core.ajax(Config.ContextPath + 'service/sjcj/villagejbxx/' + vid, {
          type: 'json',
          method: 'get'
        }).then(function (data) {
          var administrativevillage = data.administrativevillage;
          if (administrativevillage != null && administrativevillage != "") {
            panel.find("#farmhouse_administrativevillage").combobox("setValue", administrativevillage);
            panel.find("#farmhouse_vid").combobox("setValue", vid);
          }
        });
      }
    };

    var submitDosomething = function (panel, data, closeCallback, type) {
      var form = panel.find('form');
      // 开启校验
      form.form('enableValidation');
      var isValid = form.form('validate');

      if (isValid) {
        var obj = form.form("value");
        var reg = /(^\d{15}$)|(^\d{18}$)|(^\d{17}(\d|X|x)$)/;
        for (var i = 0; i < memberCnt; i++) {
          if (obj['pid_' + i] != undefined) {
            if (reg.test(obj['pid_' + i]) == false) {
              $.messager.alert('提醒', obj['fname_' + i] + ' 身份证号输入不合法！', 'warning');
              return false;
            }
          }
        }
        if (reg.test(obj.pid) == false) {
          $.messager.alert('提醒', '户主身份证号输入不合法！', 'warning');
          return false;
        } /*else if (obj.longit === "" || obj.longit === undefined) {
                    $.messager.alert('提醒', '请定位农房地点！');
                    return false;
                }*/ else if (obj.infrastructure.length > 500) {
          $.messager.alert('提醒', '周边基础设施不得超过300字！', 'warning');
          return false;
        } else if (obj.vid == null || obj.vid.length < 1) {
          $.messager.alert('提醒', '自然村不可以为空！', 'warning');
          return false;
        } else if(obj.isPersontype == "T" && (obj.persontype == null || obj.persontype == "")){
          $.messager.alert('提醒', '是四类人群时，需填写四类人群类型！', 'warning');
          return false;
        } else {
          form.form('ajax', {
            url: Config.ContextPath + 'service/sjcj/farmhousejbxx',
            method: 'post',
            data: {
              "memberCnt": memberCnt,
            }
          }).then(function (data) {
            if (type == 1) {
              closeCallback();
            } else {
              //保存后新增加：1.提醒保存成功，2.清空form数据，3.重新初始化变量和form数据（有些可使用load，有些需要自定义加载）
              $.messager.alert('提醒', '新增成功！请继续增加！');
              var panel = _self.panel;
              var form = panel.find('form');
              form.form('clear').form('disableValidation');
              uuidVal = null;//新增初始化清除缓存
              memberCnt = 0;
              //获取自然村编码,初始化
              var vid = _self.parent.panel.find("#s_farmhouse_vid").val();
              if (vid != null && vid != "") {
                Core.ajax(Config.ContextPath + 'service/sjcj/villagejbxx/' + vid, {
                  type: 'json',
                  method: 'get'
                }).then(function (data) {
                  var administrativevillage = data.administrativevillage;
                  if (administrativevillage != null && administrativevillage != "") {
                    panel.find("#farmhouse_administrativevillage").combobox("setValue", administrativevillage);
                    panel.find("#farmhouse_vid").combobox("setValue", vid);
                  }
                });
              }
            }
          });
        }
      }

    }

    // @override
    this.submit = function (panel, data, closeCallback) {
      submitDosomething(panel, data, closeCallback, 1);
      return false;
    };

    this.submitNext = function (panel, data, closeCallback) {
      submitDosomething(panel, data, closeCallback, 2);
      return false;
    };
    // @override
    this.onClose = function (table, data) {
      table.datagrid('reload');
    };

    function markLocated(id) {
      $("#" + id + "_located").show();
      $("#" + id + "_unlocated").hide();
    }

    function markUnlocated(id) {
      $("#" + id + "_located").hide();
      $("#" + id + "_unlocated").show();
    }

    function showUploadDialog(type1) {
      if (uuidVal == null) {
        uuidVal = uuid();
        _self.panel.find("#fid").val(uuidVal);
      }

      new BUpload({
        upload_url: Config.ContextPath + 'service/utils/images/uploadFile?type=1&rid=' + uuidVal + '&type1=' + type1,
        ext_allow: "png|jpg|jpeg",
        ext_refuse: "exe|bat",
        max_filesize: 1024, //KB
        max_filenum: 10,
        callback: function () {
          reloadImage();
        }
      });
    }

    function uuid() {
      function S4() {
        return (((1 + Math.random()) * 0x10000) | 0).toString(16).substring(1);
      }

      return (S4() + S4() + S4() + S4() + S4() + S4() + S4() + S4());

    }

    function reloadImage() {
      Core.ajax(Config.ContextPath + 'service/utils/images/getAttachmentsBTY/1/' + uuidVal, {
        type: 'json',
        method: 'get'
      }).then(function (data) {
        $('#imgcontainer_beforein').empty();
        $('#imgcontainer_beforeout').empty();
        $('#imgcontainer_afterin').empty();
        $('#imgcontainer_afterout').empty();
        $.each(data.fjList, function (index, item) {
          // 主
          var itemdiv = $('<div>', {}).css({
            height: '113px',
            margin: '3px',
            float: 'left',
            position: 'relative'
          }).appendTo($('#imgcontainer_' + item.type1));

          // 图片
          var img = $('<img>', {
            src: 'data:image/jpg;base64,' + item.efj
          }).css({
            height: '100%'
          }).appendTo(itemdiv);

          // 工具条
          var toolbar = $('<div>', {}).css({
            position: 'absolute',
            background: 'rgba(0, 0, 0, 0.5) none repeat scroll 0% 0%',
            width: '100%',
            height: '26px',
            top: '0px',
            left: '0px',
            display: 'none'
          }).appendTo(itemdiv);

          // 删除按钮
          var delBtn = $('<span>', {}).css({
            width: '24px',
            height: '24px',
            display: 'inline',
            float: 'right',
            background: 'url("' + Config.ContextPath + 'ui/js/bupload/css/images/icons.png") no-repeat',
            margin: '5px 1px 1px',
            cursor: 'pointer',
            'background-position': '-48px -24px'
          }).appendTo(toolbar);

          itemdiv.on('mouseover', function () {
            toolbar.show();
          }).on('mouseout', function () {
            toolbar.hide();
          });

          delBtn.on('mouseover', function () {
            delBtn.css('background-position', '-48px -0px');
          }).on('mouseout', function () {
            delBtn.css('background-position', '-48px -24px');
          });

          delBtn.click(function () {
            $.messager.alert('提示', '是否确认删除？', 'question', function () {
              Core.ajax(Config.ContextPath + 'service/utils/images/' + item.iid, {
                type: 'json',
                method: 'post',
                data: {
                  _method: 'delete'
                }
              }).then(function (rlt) {
                if (rlt.isOk) {
                  $.messager.alert('提醒', '删除成功！');
                  reloadImage();
                } else {
                  $.messager.alert('提醒', '删除失败，原因：' + rlt.msg, 'warning');
                  return false;
                }
              });
            });
          });
        });
      });
    }
  });
  return FarmhousejbxxAdd;
});
