<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

            <table  id="farmHouse2_lc_table"
                    checkbox="true"
                    sortName="wdate" sortOrder="desc" treeField="text"
                    singleSelect="false" checkOnSelect="true"
                    selectOnCheck="true" pagination="false">
                <thead>
                <tr>
                    <th data-options="field:'wmodule'" hidden="true">项目类别</th>
                    <th data-options="field:'wid'" hidden="true">项目ID</th>
                    <th data-options="field:'worder'" hidden="true">记录序号</th>
                    <th data-options="field:'status'" hidden="true">记录状态</th>
                    <th data-options="field:'username'" 　width="100" align="center">提交人</th>
                    <%--   <th data-options="field:'unitcode', width:'10'" >单位</th>--%>
                    <th data-options="field:'wdate'" format="Date:yyyy-MM-dd" 　 width="80" align="center">提交时间</th>
                    <th data-options="field:'ideaCode'" format="Dictionary:operations" width="120" align="center">操作</th>
                    <th data-options="field:'wcontent'" >意见</th>
                </tr>
                </thead>
            </table>

        <div class="easyui-panel search-body" cls="search" style="width: 100%; margin-bottom: 0;">
            <input type="hidden" name="s_sid" id="fh_s_sid2"/>
            <form class="clearFromValue"  id="farmHouseStatistics2_search_form">
                <div class="search-item">
                    <label>改善类型</label>
                    <input class="easyui-combobox" name="s_betterType"
                           target="dictionary"
                           key="BetterType"/>
                </div>
                <div class="search-item">
                    <label>四类人群</label>
                    <input class="easyui-combobox" name="s_personType"
                           target="dictionary"
                           key="PersonType"/>
                </div>
                <div class="search-item">
                    <label>户主姓名</label>
                    <input class="easyui-textbox" name="s_fname"/>
                </div>


                <a class="easyui-linkbutton btn-search" iconCls="icon-search"><p id="e@btn.search">搜索</p></a>
                <a class="easyui-linkbutton btn-reset" iconcls="icon-reload">清空查询条件</a>
                <a class="easyui-linkbutton selfBtn2" iconCls="icon-submit" id="p_tj2"><p >提交</p></a>
                <a class="easyui-linkbutton selfBtn2" iconCls="icon-accept" id="p_sl2"><p >受理</p></a>
                <a class="easyui-linkbutton selfBtn2" iconCls="icon-return" id="p_th2"><p >退回</p></a>
                <input type="hidden" id="dqStatus2" >
                <input type="hidden" id="dqzRoleCode2" >
            </form>
        </div>

        <table pagination="false"
               fit="true"
               fitColumns="true"
               idField="fsid"
               sortName="updateTime"
               sortOrder="desc"
               search=".search"
               toolbar=".temp-toolbar" action="farmHouseStatistics2_view" id="statisticstables2">
            <thead>

            <tr>
                <th data-options="field:'fsid'"  hidden="true"  rowspan="2">fsid</th>
                <th data-options="field:'detailTown',align:'center', width:'7'" rowspan="2">乡镇</th>
                <th data-options="field:'administrativeVillage',align:'center', width:'5'" rowspan="2">行政村</th>
                <th data-options="field:'naturalVillage',align:'center', width:'5'" rowspan="2">自然村</th>
                <th colspan="2">户主</th>
                <th data-options="field:'num',align:'center', width:'4', width:'3'" rowspan="2">家<br>庭<br>人<br>口<br>（人）</th>
                <th  data-options="field:'otherMember',align:'center', width:'14'" rowspan="2">其他家庭成员信息</th>
                <th data-options="field:'personType',align:'center', width:'5'" rowspan="2"  format="Dictionary:PersonType">如属四类<br>人群请勾选<br>ABCD</th>
                <th data-options="field:'oldArea2',align:'center', width:'3'" rowspan="2">已拆<br>除旧<br>房面<br>积<br>（㎡）</th>
                <th data-options="field:'outArea2',align:'center', width:'3'" rowspan="2">已退<br>出宅<br>基地<br>面积<br>（㎡）</th>
                <th data-options="field:'betterType',align:'center', width:'14'" rowspan="2" format="Dictionary:BetterType">改善类型</th>
                <th data-options="field:'housingArea',align:'center', width:'3'"   rowspan="2" >现住<br>房面<br>积<br>（㎡）</th>
                <th data-options="field:'housingAddress',align:'center', width:'8'"  rowspan="2" >现居住地详址</th>
                <th data-options="field:'tel',align:'center', width:'7'" rowspan="2">联系电话</th>
            </tr>
            <tr>
                <th data-options="field:'fname',align:'center', width:'5'">户主姓名</th>
                <th data-options="field:'pid',align:'center', width:'11'">身份证号码</th>
            </tr>
            </thead>
        </table>

        <div class="temp-toolbar">

            <a iconCls="icon-edit" href="modules/sjcj/farmHouseStatistics2/farmHouseStatistics2-info.jsp" trigger="single"
               id="farmHouseStatistics2_edit_btn"
               target="dialog" rel="farmHouseStatistics2_edit" title="编辑 {{text}}" width="1100" height="570"
                buttons="[{method:'submit',text:'保存'}]" >修改</a>
            <hr>

            <a iconCls="icon-edit" href="modules/sjcj/farmHouseStatistics2/farmHouseStatistics2-view.jsp" trigger="single"
               target="dialog" rel="farmHouseStatistics2_view"
               title="查看 {{text}}" width="1100" height="570" buttons="[{method:'submit',text:'查看'}]">查看</a>
            <hr>

            <a iconCls="icon-base icon-base-ban" trigger="single" id="farmHouseStatistics2_remove_btn"
               target="confirm" rel="farmHouseStatistics2_remove" title="是否确定删除 {{text}}？">删除</a>
            <hr>
            <a iconCls="icon-redo" trigger="none" target="custom" rel="farmHouseStatistics2_exp">导出</a>
            <hr>

        </div>

<script>
    $.parser.onComplete = function(panel) {
        $.parser.onComplete = $.noop;
        var id = '<%=request.getParameter("sid")%>';
        var dqzRoleCode = '<%=request.getParameter("dqzRoleCode")%>';
        var status = '<%=request.getParameter("status")%>';
        requirejs([
                'modules/sjcj/farmHouseStatistics2/ctrl/farmHouseStatistics2','core/filter/filter.dictionary'],
            function (FarmHouseStatistics2,FilterDictionary) {
                FilterDictionary.add([
                    'sjcjStatusType','XZQH','BetterType','PersonType','operations']
                ).then(function () {
                    var data = new Object();
                    data.sid = id;
                    data.dqzRoleCode = dqzRoleCode;
                    data.status = status;
                    new FarmHouseStatistics2('FarmHouseStatistics2',panel).load(panel, data);

                });
            });
    };
</script>


