define(function (require) {
    var Config = require('config');
    var Core = require('core/core');
    var Page = require('core/page');


    var FarmHouseStatistics2View = Page.extend(function () {
        var _self = this;
        this.renderButton = function (btn, data) {
            var flag = false;
            var fsid = data.fsid;
            if(fsid!=undefined){
                flag = true;
            }
            return flag;
        };
        // @override
        this.load = function(panel, data) {
            var form = panel.find('form');
            var othmemberTable2 = panel.find("#othmemberTable2");
            othmemberTable2.cdatagrid({
                controller: this,
            });

            Core.ajax(Config.ContextPath+'service/common/farmHouseStatistics2/'+data.fsid, {
                type: 'json',
                method: 'get'
            }).then(function(data) {
                _self.data = data;
                form.form('load', data)
                    .form('disableValidation')
                    .form('focus');
                if(data.otherMember!=undefined){
                    var  otherMember = JSON.parse(data.otherMember);
                    _createDataList(othmemberTable2,otherMember);
                }
            });

        };
        function _createDataList(table, data) {
            table.cdatagrid({
                controller : this
            }).datagrid('loadData', data);
        };
    });
    return FarmHouseStatistics2View;
});