
define(function (require) {
    var Config = require('config');
    var Core = require('core/core');
    var Page = require('core/page');
    var $ = require('jquery');
    var Dialog = require('centit/centit.dialog');
    var FarmHouseStatistics2Add = require('./farmHouseStatistics2.add');
    var FarmHouseStatistics2Edit = require('./farmHouseStatistics2.edit');
    /*   var FarmHouseStatisticsQd = require('./farmHouseStatistics.rd');*/
    /*var FarmHouseStatistics2View = require('./farmHouseStatistics2.view');*/
    var FarmHouseStatistics2Remove = require('./farmHouseStatistics2.remove');
    var FarmHouseStatistics2Exp = require('./farmHouseStatistics2.exp');

    var FarmHouseStatistics2 = Page.extend(function () {
        this.injecte([
          //  new FarmHouseStatistics2Add('farmHouseStatistics2_add'),
            new FarmHouseStatistics2Edit('farmHouseStatistics2_edit'),
            /*new FarmHouseStatistics2View('farmHouseStatistics2_view'),*/
            new FarmHouseStatistics2Remove('farmHouseStatistics2_remove'),
            new FarmHouseStatistics2Exp('farmHouseStatistics2_exp'),
        ]);
        var self;
        var roleCode;
        var status;
        var syear;
        var vid;
        var closeFlag = false;
        // @override
        this.load = function (panel, data) {
            self = this;
            var table =  panel.find('#statisticstables2');
            table.cdatagrid({
                controller: this,
            });
            var sid = data.sid;
            if (sid == null) {
                sid = data.wid;
                closeFlag = data.closeFlag;
            }
            Core.ajax(Config.ContextPath + 'service/common/statisticsList/' + sid, {//重新查询总表
                type: 'json',
                method: 'get'
            }).then(function (data) {
                self.data = data;
                panel.find("#farmHouseStatistics_remind2").html(data.remind);
                var url = "service/common/farmHouseStatistics2";
                panel.find("#dqStatus2").val(data.status);
                if(data!=undefined&&data.sid != null && data.sid != '' && data.sid != 'null'){
                    panel.find("#fh_s_sid2").val(data.sid);
                    url += '?sid='+data.sid ;
                }
                table.cdatagrid({
                    controller: this,
                    url: url,
                });
                var lc_table = panel.find("#farmHouse2_lc_table");
                lc_table.cdatagrid({
                    // 必须要加此项!!
                    controller :self
                });
                Core.ajax(Config.ContextPath+'service/utils/pmpWfRecord?s_wid='+data.sid+'&s_wmodule=4', {
                    type: 'json',
                    method: 'get'
                }).then(function(resData) {
                    var lcList = resData.objList;
                    _createDataList(lc_table,lcList);
                });
                Core.ajax(Config.ContextPath+'service/common/getLoginUserRoles', {
                    method: 'get'
                }).then(function(rlt) {
                    roleCode = rlt[1].roleCode;
                    panel.find("#dqzRoleCode2").val(rlt[1].roleCode);
                    status = data.status;
                    btnShow(status, roleCode);

                    //重新导入
                    panel.find('#p_cxdr2').click(function(){
                        syear = data.syear;
                        vid = data.vid;
                        if(confirm("是否重新导入？")){
                            if(status == "00"||status == "01"||status == "04"){
                                Core.ajax(Config.ContextPath+'service/statist/insert/'+syear+'/2/'+vid+'/true', {
                                    type: 'json',
                                    method: 'get'
                                }).then(function(rlt) {
                                    if(rlt.isOk){
                                        $.messager.alert('提醒', '重新导入数据成功！');
                                    } else{
                                        $.messager.alert('提醒', '重新导入数据失败，原因：'+rlt.msg ,'warning');
                                        return  false;
                                    }
                                    table.datagrid('reload');
                                });
                            }else {
                                $.messager.alert('提醒', '不可重新导入！');
                            }
                        }else{
                            return false;
                        }
                    });
                    //确定数据
                    panel.find('#p_rqsj2').click(function(){
                        status =   panel.find("#dqStatus2").val();
                        if(confirm("是否确定数据？")){
                            if(status == "00"){
                                Core.ajax(Config.ContextPath+'service/common/statisticsList/opinion/04/' + sid+'/01', {
                                    type: 'json',
                                    method: 'post'
                                }).then(function(rlt) {

                                    if(rlt.isOk){
                                        status = "01";
                                        panel.find("#dqStatus2").val(status);
                                        btnShow(status, roleCode);
                                        $.messager.alert('提醒', '确定数据成功！');
                                    } else{
                                        $.messager.alert('提醒', '确定数据失败，原因：'+rlt.msg ,'warning');
                                        return  false;
                                    }
                                });
                            }else {
                                $.messager.alert('提醒', '不可确定数据！');
                            }
                        }else{
                            return false;
                        }
                    });
                    //提交
                    panel.find('#p_tj2').click(function(){
                        status =   panel.find("#dqStatus2").val();
                        if(confirm("是否确定提交？")){
                            if(roleCode=='0013'&&(status=='01'||status=='04')){
                                Core.ajax(Config.ContextPath+'service/common/statisticsList/opinion/04/' + sid +'/02', {
                                    type: 'json',
                                    method: 'post'
                                }).then(function(rlt) {
                                    if(rlt.isOk){
                                        status = "02";
                                        panel.find("#dqStatus2").val(status);
                                        btnShow(status, roleCode);
                                        $.messager.alert('提醒', '提交成功！');
                                    } else{
                                        $.messager.alert('提醒', '提交失败，原因：'+rlt.msg ,'warning');
                                        return  false;
                                    }
                                });
                            }else {
                                $.messager.alert('提醒', '不可提交！');
                            }
                        }else{
                            return false;
                        }
                    });

                    //退回
                    panel.find('#p_th2').click(function(){
                        status = panel.find('#dqStatus2').val();
                        var obj = isDo(status, roleCode,'th');
                        if(obj.flag==true){
                                var SelectUser = require('modules/sjcj/statisticsList2/ctrl/statisticsList2.opinion.th');
                                var _SelectUser = new SelectUser("statisticsListtwoth");
                                self.controllers["statisticsListtwoth"] = _SelectUser;
                                _SelectUser.parent = self;
                                Dialog.open({
                                    id : 'selectuser',
                                    title : '退回',
                                    href : "modules/sjcj/statisticsList2/statisticsList2-opinion.jsp",
                                    width : 550,
                                    height : 300
                                }, {sss:obj.newStatus,sid:data.sid}, self.controllers["statisticsListtwoth"]);
                            }else {
                                $.messager.alert('提醒', '不可退回！');
                            }
                    });

                    //受理
                    panel.find('#p_sl2').click(function(){
                        status = panel.find('#dqStatus2').val();
                        var obj = isDo(status, roleCode,'sl');
                            if(obj.flag==true){
                                var SelectUser = require('modules/sjcj/statisticsList2/ctrl/statisticsList2.opinion.sl');
                                var _SelectUser = new SelectUser("statisticsListtwosl");
                                self.controllers["statisticsListtwosl"] = _SelectUser;
                                _SelectUser.parent = self;
                                Dialog.open({
                                    id : 'selectuser',
                                    title : '受理',
                                    href : "modules/sjcj/statisticsList2/statisticsList2-opinion.jsp",
                                    width : 550,
                                    height : 300
                                }, {sss:obj.newStatus,sid:data.sid}, self.controllers["statisticsListtwosl"]);
                            }else {
                                $.messager.alert('提醒', '不可受理！');
                            }

                    });
                });

            })


        };
        // 创建列表明细
        function _createDataList(table, data) {
            table.cdatagrid({
                // 必须要加此项!!
                controller :self
            }).datagrid('loadData', data);
        };

        //获取系统时间并格式化时间
        function getXtsj() {
            var date = new Date();
            var weekArray = ["星期日", "星期一", "星期二", "星期三", "星期四", "星期五", "星期六"];
            var xtsj = date.getFullYear() + "年" + (date.getMonth() + 1) + "月" + date.getDate() + "日&nbsp;&nbsp;" + weekArray[date.getDay()];
            return xtsj;
        }

        function getXtsj1() {
            var date = new Date();
            var weekArray = ["星期日", "星期一", "星期二", "星期三", "星期四", "星期五", "星期六"];
            var xtsj = date.getFullYear() + "年" + (date.getMonth() + 1) + "月" + date.getDate() + "日 " + weekArray[date.getDay()];
            return xtsj;
        }
        //根据用户角色和事件状态判断操作按钮的隐藏或者显示
        function btnShow(status, roleCode) {
            if (status != '01' && status != '04') {
                $("#farmHouseStatistics2_edit_btn").hide();
                $("#farmHouseStatistics2_remove_btn").hide();
            }else{
                $("#farmHouseStatistics2_edit_btn").show();
                $("#farmHouseStatistics2_remove_btn").show();
            }
            if (roleCode == '0010' && (status == "02" || status == "06" || status == "07")) {//省
                $('#p_sl2').show();
                $('#p_th2').show();
                $('#p_tj2').hide();
            }else if (roleCode == '0011' && status == "06") {//市
                $('#p_sl2').show();
                $('#p_th2').show();
                $('#p_tj2').hide();
            }else if (roleCode == '0012' && status == "02") {//区
                $('#p_sl2').show();
                $('#p_th2').show();
                $('#p_tj2').hide();
            }else if (roleCode == '0013' && (status == '01' || status == '04')) {//镇
                $('#p_tj2').show();
                $('#p_th2').hide();
                $('#p_sl2').hide();
            } else {
                $('#p_tj2').hide();
                $('#p_th2').hide();
                $('#p_sl2').hide();
            }
            //确定数据
            if(status=='00'){
                $('#p_rqsj2').show();
            }else{
                $('#p_rqsj2').hide();
                $('#p_cxdr2').hide();
            }
            //重新导入
            if(status == "00"||status == "01"||status == "04"){
                $('#p_cxdr2').show();
            }else{
                $('#p_rqsj2').hide();
                $('#p_cxdr2').hide();
            }
            if(roleCode == '0010'&&status == "05"){//省级生效也可以退回
                $('#p_th2').show();
            }
        }

        //根据状态和角色代码判断是否可以操作,并返回操作执行后的状态代码
        function isDo(status, roleCode,cz) {
            var obj = new Object();
            var flag = false;
            var newStatus = status ;
            if (roleCode == '0010' && status != '00' && status != '04' && status != '01') {//省,除初始化、维护中和已退回，其他状态都可操作
                flag = true;
                if(cz == 'sl'){
                    newStatus = '05';
                }
            }
            if (roleCode == '0011' && status == '06') {//市,县区已受理可操作
                flag = true;
                if(cz == 'sl'){
                    newStatus = '07';
                }
            }
            if (roleCode == '0012' && status == '02') {//区,镇提交可操作
                flag = true;
                if(cz == 'sl'){
                    newStatus = '06';
                }
            }
            if(cz == 'th'){
                newStatus = '04';
            }
            obj.flag = flag;
            obj.newStatus = newStatus;
            return obj;
        }
        this.onClose = function(table, data) {
            if (table != null) {
                table.datagrid('reload');
            }

            if (this.parent.table != null) {
                this.parent.table.datagrid('reload');
            }

            if (this.parent.panel.find("#vp") != null) {
                this.parent.panel.find("#vp").datagrid('reload');
            }
            if (closeFlag == true) {
                var panel = self.parent.panel;
                var div = parent.document.getElementById("firstPage_vprocess");
                //divall是ul的id
                while (div.hasChildNodes()) //当div下还存在子节点时 循环继续
                {
                    div.removeChild(div.firstChild);
                }

                //我的待办
                Core.ajax(Config.ContextPath + 'service/common/getLoginUserRoles', {
                    method: 'get'
                }).then(function (rlt) {
                    var isZj = false;
                    for (var i = 0; i < rlt.length; i++) {
                        roleCode = rlt[1].roleCode;//赋值，传给待办的页面
                        if (rlt[i].roleCode == '0013') {
                            roleCode = rlt[i].roleCode;
                            isZj = true;
                            break;
                        }
                    }
                    if (!isZj) {
                        Core.ajax(Config.ContextPath + 'service/utils/process?sort=updatetime&order=desc', {
                            method: 'get'
                        }).then(function (rlt) {
                            var data = rlt.objList;
                            var count = 0;
                            var ul = panel.find('#firstPage_vprocess');
                            if (data == null) {
                                ul.append('<li class="nli1" ><span style="display:inline-block;position: relative;overflow: hidden; margin: 0;padding: 0;"> <span class="tb"></span><span class="sz">' + 0 + '</span><div class="wdtz"><div class="wdtz1">我的待办</div><div class="wdtz2">' + getXtsj() + '</div></div></span></li>');
                            } else {
                                ul.append('<li class="nli1" ><span style="display:inline-block;position: relative;overflow: hidden; margin: 0;padding: 0;"> <span class="tb"></span><span class="sz">' + data.length + '</span><div class="wdtz"><div class="wdtz1">我的待办</div><div class="wdtz2">' + getXtsj() + '</div></div></span></li>');
                                var div = $('<div id="homePage_tzgg"></div>').appendTo(ul);
                                $(data).each(function () {
                                    var mkbm = this.mkbm;
                                    div.append('<div>' + this.updatetime + '</div>');
                                    div.append('<div class="nli2"  id="' + this.mid + this.mkbm + this.status + '"><span class="redC"></span><span>' + this.title + '</span></div>');
                                    if (count++ > 2)
                                        return false;
                                });

                            }
                            //村庄数量统计加时间
                            //$('<div class="wdtz2">' + getXtsj() + '</div>').appendTo($('#firstPage-cztj-title'));
                        });
                    } else {//如果是村庄则统计无农房改善的信息
                        var codes;
                        Core.ajax(Config.ContextPath + 'service/common/getLoginUser', {
                            method: 'get'
                        }).then(function (rlt) {
                            codes = rlt.userInfo.primaryUnit;
                            /*      alert(codes);*/
                            Core.ajax(Config.ContextPath + 'service/utils/process/searchUnfarms?towncode=' + codes, {
                                method: 'get'
                            }).then(function (rlt) {
                                var data = rlt;
                                var count = 0;
                                var ul = $("#firstPage_vprocess");
                                if (data == null) {
                                    ul.append('<li class="nlitl" ><span style="display:inline-block;position: relative;overflow: hidden; margin: 0;padding: 0;"> <span class="tb"></span><span class="sz">' + 0 + '</span><div class="wdtz"><div class="wdtz1">我的待办</div><div class="wdtz2">' + getXtsj() + '</div></div></span></li>');
                                } else {
                                    ul.append('<li class="nlit1" ><span style="display:inline-block;position: relative;overflow: hidden; margin: 0;padding: 0;"> <span class="tb"></span><span class="sz">' + data.length + '</span><div class="wdtz"><div class="wdtz1">我的待办</div><div class="wdtz2">' + getXtsj() + '</div></div></span></li>');
                                    var div = $('<div id="homePage_tzgg"></div>').appendTo(ul);
                                    $(data).each(function () {
                                        var title = data.title;
                                        div.append('<div class="nlit2" ><span class="redC"></span><span>' + this.title + '</span></div>');
                                        if (count++ > 2)
                                            return false;
                                    });
                                }
                            });
                        });
                    }
                });
        }
        };
    });

    return FarmHouseStatistics2;
});

