define(function(require) {
    var Config = require('config');
    var Core = require('core/core');
    var FarmHouseStatistics2Add = require('./farmHouseStatistics2.add');
    var Othmember2Add = require('./othmember2.add');
    var Othmember2Remove = require('./othmember2.remove');

    var FarmHouseStatistics2Edit = FarmHouseStatistics2Add.extend(function() {
        var _self = this;
        this.injecte([
            new Othmember2Add('othmember2_add'),
            new Othmember2Remove('othmember2_remove')
        ]);
        this.renderButton = function (btn, data) {
            var flag = false;
            var fsid = data.fsid;
            if(fsid!=undefined){
                flag = true;
            }
            return flag;
        };
        // @override
        this.load = function(panel, data) {
            var othmember_table2 = panel.find("#othmember_table2");
            othmember_table2.cdatagrid({
                controller: this,
            });
            var form = panel.find('form');

            Core.ajax(Config.ContextPath+'service/common/farmHouseStatistics2/'+data.fsid, {
                type: 'json',
                method: 'get'
            }).then(function(data) {
                _self.data = data;

                form.form('load', data)
                    .form('disableValidation')
                    .form('readonly', 'fsid')
                    .form('focus');
                if(data.otherMember!=undefined){
                    var  otherMember = JSON.parse(data.otherMember);
                    _createDataList(othmember_table2,otherMember);
                }

            });
        };
        function _createDataList(table, data) {
            table.cdatagrid({
                controller : this
            }).datagrid('loadData', data);
        };
        // @override
        this.submit = function(panel, data, closeCallback) {
            var form = panel.find('form');

            // 开启校验
            form.form('enableValidation');
            var isValid = form.form('validate');
            var othmember_table2 = panel.find('#othmember_table2');
            if (!othmember_table2.cdatagrid('endEdit')) {
                return;
            }
            var index = othmember_table2.datagrid('getRows').length-1;
            othmember_table2.cdatagrid('endEdit', index, 'dataCode');
            var othmemberdatas2 = othmember_table2.datagrid('getData').rows;
            var n=0;
            if(form.form("value").pid!=''){
                 n=1;
            }
            if(othmemberdatas2!=null &&othmemberdatas2.length>0){
                panel.find("#num").numberbox('setValue',parseInt(othmemberdatas2.length+n));
                for(var i = 0 ; i < othmemberdatas2.length ; i++){
                    var pid= othmemberdatas2[i].id;
                    var reg = /(^\d{15}$)|(^\d{18}$)|(^\d{17}(\d|X|x)$)/;
                    if(reg.test(pid) == false) {
                        $.messager.alert('提醒', '身份证号输入不合法！','warning');
                        return  false;
                    }
                }
            }else{
                panel.find("#num").numberbox('setValue',parseInt(n));
            }
            var otherMemberJsonStr2 =JSON.stringify(othmemberdatas2);
            data.otherMember= otherMemberJsonStr2;
            if (isValid) {
                form.form('ajax', {
                    url: Config.ContextPath + 'service/common/farmHouseStatistics2',
                    method: 'post',
                    data: data
                }).then(function(rlt){
                    if(rlt.isOk){
                        $.messager.alert('提醒', '实际农改信息修改成功！');
                        closeCallback();
                    } else{
                        $.messager.alert('提醒', '实际农改信息修改失败，原因：'+rlt.msg ,'warning');
                        return  false;
                    }
                });
            }
            return false;
        };

        // @override
        this.onClose = function(table) {
            table.datagrid('reload');
        };
    });

    return FarmHouseStatistics2Edit;
});