define(function(require) {
    var Config = require('config');
    var Page = require('core/page');
    var Core = require('core/core');
    var FarmHouseStatistics2Add = Page.extend(function() {

        // @override
        this.load = function(panel, data) {
            var form = panel.find('form');
            var sid = this.parent.panel.find("#fh_s_sid2").val();
            Core.ajax(Config.ContextPath + 'service/common/getXZQHByLoginUser', {
                method: 'get'
            }).then(function(data) {
                panel.find("#fhouse_districtcode2").combobox("setValue",data[0].extraCode);
                panel.find("#fhouse_town2").combobox("setValue",data[0].dataCode);
            });

            panel.find("#farmhousesid2").val(sid);
            form.form('disableValidation')
                .form('focus');
        };

        // @override
        this.submit = function(panel, data, closeCallback) {
            var form = panel.find('form');

            // 开启校验
            form.form('enableValidation');
            var isValid = form.form('validate');

            if (isValid) {
                var obj = form.form("value");
                var reg = /(^\d{15}$)|(^\d{18}$)|(^\d{17}(\d|X|x)$)/;
                if(reg.test(obj.pid) == false) {
                    $.messager.alert('提醒', '身份证号输入不合法！','warning');
                    return  false;
                }else{
                    form.form('ajax', {
                        url: Config.ContextPath + 'service/common/farmHouseStatistics2?type=new',
                        method: 'post'
                    }).then(function(rlt){
                        if(rlt.isOk){
                            $.messager.alert('提醒', '新增实际改善住房条件信息保存成功！');
                            closeCallback();
                        } else{
                            $.messager.alert('提醒', '新增实际改善住房条件信息保存失败，原因：'+rlt.msg ,'warning');
                            return  false;
                        }
                    });
                }
            }

            return false;
        };

        // @override
        this.onClose = function(table, data) {
            table.datagrid('reload');
        };
    });

    return FarmHouseStatistics2Add;
});