<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<table id="farmHouse_lc_table" style="height: auto;"
       checkbox="true"
       sortName="wdate" sortOrder="desc" treeField="text"
       singleSelect="false" checkOnSelect="true"
       selectOnCheck="true" pagination="false">
    <thead>
    <tr>
        <th data-options="field:'wmodule'" hidden="true">项目类别</th>
        <th data-options="field:'wid'" hidden="true">项目ID</th>
        <th data-options="field:'worder'" hidden="true">记录序号</th>
        <th data-options="field:'status'" hidden="true">记录状态</th>
        <th data-options="field:'username'" 　width="100" align="center">提交人</th>
        <%--   <th data-options="field:'unitcode', width:'10'" >单位</th>--%>
        <th data-options="field:'wdate'" format="Date:yyyy-MM-dd" 　 width="80" align="center">提交时间</th>
        <th data-options="field:'ideaCode'" format="Dictionary:operations" width="120" align="center">操作</th>
        <th data-options="field:'wcontent'" >意见</th>
    </tr>
    </thead>
</table>
<div class="easyui-panel search-body" cls="search" style="width: 100%; margin-bottom: 0;">
    <input type="hidden" name="s_sid" id="fh_s_sid"/>
    <form class="clearFromValue" id="farmHouseStatistics_search_form">
        <div class="search-item">
            <label>改善类型</label>
            <input class="easyui-combobox" name="s_betterType"
                   target="dictionary"
                   key="BetterType"/>
        </div>
        <div class="search-item">
            <label>四类人群</label>
            <input class="easyui-combobox" name="s_personType"
                   target="dictionary"
                   key="PersonType"/>
        </div>
        <div class="search-item">
            <label>户主姓名</label>
            <input class="easyui-textbox" name="s_fname"/>
        </div>


        <a class="easyui-linkbutton btn-search" iconCls="icon-search"><p id="e@btn.search">搜索</p></a>
        <a class="easyui-linkbutton btn-reset" iconcls="icon-reload">清空查询条件</a>
        <a class="easyui-linkbutton selfBtn2" iconCls="icon-submit" id="p_tj"><p>提交</p></a>
        <a class="easyui-linkbutton selfBtn2" iconCls="icon-accept" id="p_sl"><p>受理</p></a>
        <a class="easyui-linkbutton selfBtn2" iconCls="icon-return" id="p_th"><p>退回</p></a>
        <input type="hidden" id="dqStatus">
        <input type="hidden" id="dqzRoleCode">
    </form>
</div>
<table fit="true"
       fitColumns="true"
       idField="fsid"
       sortName="updateTime"
       sortOrder="desc"
       search=".search"
       toolbar=".temp-toolbar"
       action="farmHouseStatistics_view"
       id="statisticstables"
       pagination="false">
    <thead>
    <tr>
        <th data-options="field:'fsid'" hidden="true" rowspan="2">fsid</th>
        <th data-options="field:'detailTown',align:'center'" rowspan="2">乡镇</th>
        <th data-options="field:'administrativeVillage',align:'center'" rowspan="2">行政村</th>
        <th data-options="field:'naturalVillage',align:'center'" rowspan="2">自然村</th>
        <th colspan="2">户主</th>
        <th data-options="field:'num',align:'center'" rowspan="2">家庭<br>人口<br>（人）</th>
        <th data-options="field:'otherMember',align:'center'" rowspan="2">其他家庭成员信息</th>
        <th data-options="field:'personType',align:'center'" rowspan="2" format="Dictionary:PersonType">如属四类<br>人群请勾选ABCD
        </th>
        <th data-options="field:'oldArea',align:'center'" rowspan="2">协议拆除<br>旧房面积<br>（㎡）</th>
        <th data-options="field:'outArea',align:'center'" rowspan="2">协议退出<br>宅基地面<br>积（㎡）</th>
        <th data-options="field:'betterType',align:'center'" rowspan="2" format="Dictionary:BetterType">改善类型</th>
        <th data-options="field:'tel',align:'center'" rowspan="2">联系电话</th>
    </tr>
    <tr>
        <th data-options="field:'fname',align:'center'">户主姓名</th>
        <th data-options="field:'pid',align:'center'">身份证号码</th>
    </tr>

    </thead>
</table>

<div class="temp-toolbar">
    <a iconCls="icon-edit" href="modules/sjcj/farmHouseStatistics/farmHouseStatistics-info.jsp" trigger="single"
       id="farmHouseStatistics_edit_btn"
       target="dialog" rel="farmHouseStatistics_edit" title="编辑 {{text}}" width="1100" height="570"
        buttons="[{method:'submit',text:'保存'}]" >修改</a>
    <hr>

    <a iconCls="icon-edit" href="modules/sjcj/farmHouseStatistics/farmHouseStatistics-view.jsp" trigger="single"
       target="dialog" rel="farmHouseStatistics_view"
       title="查看 {{text}}" width="1100" height="570" buttons="[{method:'submit',text:'查看'}]">查看</a>
    <hr>

    <a iconCls="icon-base icon-base-ban" trigger="single" id="farmHouseStatistics_remove_btn"
       target="confirm" rel="farmHouseStatistics_remove" title="是否确定删除 {{text}}？">删除</a>
    <hr>
    <a iconCls="icon-redo" trigger="none" target="custom" rel="farmHouseStatistics_exp">导出</a>
    <hr>
</div>
<script>
    $.parser.onComplete = function(panel) {
        $.parser.onComplete = $.noop;
        var id = '<%=request.getParameter("sid")%>';
        var dqzRoleCode = '<%=request.getParameter("dqzRoleCode")%>';
        var status = '<%=request.getParameter("status")%>';
        requirejs([
                'modules/sjcj/farmHouseStatistics/ctrl/farmHouseStatistics','core/filter/filter.dictionary'],
            function (FarmHouseStatistics,FilterDictionary) {
                FilterDictionary.add([
                    'sjcjStatusType','XZQH','BetterType','PersonType','operations']
                ).then(function () {
                    var data = new Object();
                    data.sid = id;
                    data.dqzRoleCode = dqzRoleCode;
                    data.status = status;//添加状态
                    new FarmHouseStatistics('FarmHouseStatistics',panel).load(panel, data);

                });
            });
    };
</script>


