define(function (require) {
    var Config = require('config');
    var Core = require('core/core');
    var Page = require('core/page');


    var FarmHouseStatisticsView = Page.extend(function () {
        var _self = this;
        this.renderButton = function (btn, data) {
            var flag = false;
            var fsid = data.fsid;
            if(fsid!=undefined){
                flag = true;
            }
            return flag;
        };
        // @override
        this.load = function(panel, data) {
            var form = panel.find('form');
            var othmemberTable = panel.find("#othmemberTable");
            othmemberTable.cdatagrid({
                controller: this,
            });

            Core.ajax(Config.ContextPath+'service/common/farmHouseStatistics/'+data.fsid, {
                type: 'json',
                method: 'get'
            }).then(function(data) {
                _self.data = data;
                form.form('load', data)
                    .form('disableValidation')
                    .form('focus');
                if(data.otherMember!=undefined){
                    var  otherMember = JSON.parse(data.otherMember);
                    _createDataList(othmemberTable,otherMember);
                }
            });

        };
        function _createDataList(table, data) {
            table.cdatagrid({
                controller : this
            }).datagrid('loadData', data);
        };
    });
    return FarmHouseStatisticsView;
});