define(function(require) {
    var Config = require('config');
    var Core = require('core/core');
    var FarmHouseStatisticsAdd = require('./farmHouseStatistics.add');

    var FarmHouseStatisticsEdit = FarmHouseStatisticsAdd.extend(function() {
        var _self;
        var _url;
        var _sid;
        var _table;
        // @override
        this.load = function(panel, data) {
            _self = this;
            _sid = _self.parent.panel.find("#fh_s_sid").val();
            _url = Config.ContextPath+'service/sjcj/farmhousejbxx/list2?isbetters=FPB&planYear=F&sid='+_sid;
            _table = panel.find('table');
            _table.cdatagrid({
                controller: _self,
            });
            tableLoad(_url);
            // 改善类型为3或5时，显新型农村社区
            panel.find('#statisticsList_betterType').combobox({
                onChange: function (newValue, oldValue) {
                    var url = Config.ContextPath+'service/sjcj/newhousingjbxx/list2?notProgress=1&isAddUserCodes=F&htype=' + newValue;
                    if (newValue == '3' || newValue == '5'){
                        _self.panel.find("#stat_hid").combobox({
                            url:url,
                            valueField:'hid',
                            textField:'houseName'
                        });
                        _self.panel.find("#stat_hid_div").show();
                    } else {
                        _self.panel.find("#stat_hid_div").hide();
                    }
                }
            });
            // 行政村、自然村、表单联动
            panel.find('#statisticsList_administrativevillage').combobox({//行政村
                onChange: function (newValue, oldValue) {
                        var url = _url;
                        panel.find('#statisticsList_vid').combobox("clear");
                        if (newValue != null && newValue != ''){
                            url += '&s_administrativevillage=' + newValue;
                            panel.find('#statisticsList_vid').combobox('reload', Config.ContextPath + 'service/sjcj/villagejbxx/list2?administrativevillage=' + newValue);
                        }
                        var fname = _self.panel.find('#s_fname').val();
                        if(fname != null && fname != ""){
                            url += '&fname=' + newValue;
                        }
                        tableLoad(url);
                }
            });

            panel.find('#statisticsList_vid').combobox({//自然村
                onChange: function (newValue, oldValue) {
                        var url = _url;
                        if (newValue != null && newValue != ''){
                            url += '&s_vid=' + newValue;
                        } else {
                            var xzc = _self.panel.find("#statisticsList_administrativevillage").val();
                            if(xzc != null && xzc != ''){
                                url += '&s_administrativevillage=' + xzc;
                            }
                        }
                        var fname = _self.panel.find('#s_fname').val();
                        if(fname != null && fname != ""){
                            url += '&fname=' + newValue;
                        }

                        tableLoad(url);
                }
            });
            //户主页面查询
            panel.find('#s_fname').textbox({
                onChange: function (newValue, oldValue) {
                        var url = _url;
                        var sv = _self.panel.find('#statisticsList_vid').val();
                        if(sv != null && sv != ""){
                            url += '&s_vid=' + sv;
                        } else {
                            var sa = _self.panel.find('#statisticsList_administrativevillage').val();
                            if(sa != null && sa != ""){
                                url += '&s_administrativevillage=' + sa;
                            }
                        }
                        url += '&fname=' + newValue;
                        tableLoad(url);
                }
            });

        };

        var tableLoad = function(url){
            Core.ajax(url, {
                method: 'get'
            }).then(function (resData) {
                _createDataList(_table, resData);
            });
        }

        // 创建列表明细
        function _createDataList(table, data) {
            var fn = _self.panel.find('#s_fname').val();
            table.cdatagrid({
                controller: _self,
            }).datagrid('loadData', data);
        };

        // @override
        this.submit = function(panel, data, closeCallback) {
            var form = panel.find('form');
            var table = panel.find('#stat_farmhouse_table');
            var obj = form.form('value');
            var betterType = obj.s_betterType;
            var hid = obj.s_hid;
            if(betterType == null || betterType == ''){
                $.messager.alert('提醒', '改善类型不能为空！','warning');
                return false;
            } else if(betterType == '3' || betterType == '5'){
                if(hid == null || hid == ''){
                    $.messager.alert('提醒', '改善类型为"新建新型村社区"或“入镇小城镇集中安置”需选择对应改善项目！','warning');
                    return false;
                }
            }
            var rows = table.datagrid('getSelections');
            if(rows == null || rows.length < 1){
                $.messager.alert('提醒', '未勾选农房信息！','warning');
                return false;
            }
            if(_sid == null || _sid == ''){
                $.messager.alert('提醒', '页面数据异常，请刷新页面后重试！','warning');
                return false;
            }
            var json = JSON.stringify(rows);
            Core.ajax(Config.ContextPath+'service/common/farmHouseStatistics/planList', {
                type: 'json',
                method: 'post',
                traditional: true,
                data:{"json":json,"betterType":betterType,"hid":hid,"sid":_sid},
            }).then(function(rlt){
                var tx = '添加农房总数:'+(rlt.success + rlt.lose)+'，成功添加计划改善农房数量：' + rlt.success;
                if(rlt.lose > 1){
                    tx += ",失败添加计划改善农房数量：" + rlt.lose + "<br>原因：" + rlt.error;
                }
                $.messager.alert('提醒', tx);
                closeCallback();
            });
            return false;
        };

        // @override
        this.onClose = function(table) {
            table.datagrid('reload');
        };


    });

    return FarmHouseStatisticsEdit;
});
