<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<div class="easyui-layout" fit="true" id="facility-info-main">
    <div region="north" border="false" style="height: 60px; padding: 4px;">
        <div class="easyui-panel search-body" cls="search" style="width: 100%; margin-bottom: 0;">
            <form class="clearFromValue" id="facility_search_form">
                <div class="search-item">
                    <label>行政区划</label>
                    <!--江苏省-->
                    <input type="text" class="easyui-combobox" name="first"  data-options="valueField: 'value',textField: 'label', data: [{label: '江苏省',value: '320000000000'}]"
                           method="get" prompt="省" value="320000000000" validType="true"/>
                    &nbsp;
                    <input type="text" class="easyui-combobox" data-options="valueField:'unitCode',textField:'unitName'" name="second" id="facility_second" method="get" prompt="市"/>
                    &nbsp;
                    <input type="text" class="easyui-combobox" data-options="valueField:'unitCode',textField:'unitName'" name="third" id="facility_third" method="get" prompt="县区"/>
                    &nbsp;
                    <input type="text" class="easyui-combobox" data-options="valueField:'unitCode',textField:'unitName'" name="fourth" id="facility_fourth" method="get" prompt="镇"/>
                </div>
                <div class="search-item">
                    <label>结算年份</label>
                    <input type="text" class="easyui-combobox" name="fyear" style="width: 80px"
                           url="service/common/getYearList/10" method="get"
                           data-options="valueField:'year',textField:'year'"/>
                </div>
                <div class="search-item">
                    <label>一级分类</label>
                    <input class="easyui-combobox" target="dictionary" key="ftype" name="ftype" />
                </div>

                <div class="search-item">
                    <label>类型</label>
                    <input class="easyui-combobox" target="dictionary" key="associationType" name="relation" />
                </div>
                <div class="search-item">
                    <label>改善项目</label>
                    <input type="text" class="easyui-combobox" method="get"
                           url="service/sjcj/newhousingjbxx/list2?isAddUserCodes=F"
                           name="hid" style="width: 200px;" id="facility_info_hid_val"
                           data-options="valueField:'hid',textField:'houseName'"/>
                </div>
                <a class="easyui-linkbutton btn-search" iconCls="icon-search"><p id="e@btn.search">搜索</p></a>
                <%--<a class="warnSelf">说明：改善项目增加基础设施之前必须补充投资额信息。</a>--%>
            </form>
        </div>
    </div>


    <div data-options="region:'center'" border="false" style="padding: 4px;">
        <table url="${ctx}service/sjcj/facility"
               idField="id" treeField="text"
               sortName="updatetime"
               sortOrder="desc" search=".search"
               toolbar=".temp-toolbar" layoutH="0">
            <thead>
            <tr>
               <%-- <th data-options="field:'fid'" hidden="hidden">主键</th>--%>


				<th data-options="field:'districtcodeName'" align="center"  width="10%">行政区划</th>
                <th data-options="field:'fyear'" align="center"  width="5%" >结算年份</th>
                <th data-options="field:'relationName'" align="center" >类型</th>
                <th data-options="field:'hidName'" align="center" >改善项目</th>
                <th data-options="field:'townName'" align="center"  width="5%" >乡镇</th>
                <th data-options="field:'administrativevillageName'" align="center"   width="6%">行政村</th>
                <th data-options="field:'ftypeName'" align="center"  width="8%" >一级分类</th>
                <th data-options="field:'ftype2Name'" align="center"  width="8%" >二级分类</th>
                <th data-options="field:'fname'" align="center" >设施名称</th>
                <th data-options="field:'builtarea'" align="center"  width="5%" >建筑面积</th>
                <th data-options="field:'facilitylength'" align="center"  width="5%" >长度</th>
                <th data-options="field:'money'" align="center"  width="5%" >投资额</th>

                <th data-options="field:'userName'" align="center" >录入用户</th>
                <th data-options="field:'updatetime'" format="Date:yyyy-MM-dd" align="center">更新时间</th>
            </tr>
            </thead>
        </table>

        <div class="temp-toolbar">
            <a iconCls="icon-add" href="modules/sjcj/facility/facility-info.jsp" trigger="none"
               target="dialog" rel="facility_add"  id="facility_add_btn" title="新增设施表" width="750" height="600" btnValue="添加"
               buttons="[{method:'submitNext',text:'保存并新增'},
                       {method:'submit',text:'保存并退出'}]">新增</a>
            <hr>



            <a iconCls="icon-edit" href="modules/sjcj/facility/facility-info.jsp" trigger="single"
               target="dialog" rel="facility_edit"   title="修改 {{text}}" width="750" height="600" btnValue="更新">修改</a>
            <hr>

            <a iconCls="icon-edit" href="modules/sjcj/facility/facility-view.jsp" trigger="single"
               target="dialog" rel="facility_view" title="查看 {{text}}" width="750" height="600" btnValue="查看">查看</a>
            <hr>

            <a iconCls="icon-base icon-base-ban" trigger="single"
               target="confirm" rel="facility_remove" title="是否确定删除 {{text}}？" id="facility_remove_btn">删除</a>
            <hr>
           <a iconCls="icon-redo" trigger="none" target="custom" rel="facility_exp" id="farmhousejbxx_exp_btn">导出</a>
        </div>

    </div>
</div>
<script>
    $.parser.onComplete = function (panel) {
        $.parser.onComplete = $.noop;
        requirejs([
            'modules/sjcj/facility/ctrl/facility','core/filter/filter.dictionary'
        ], function (Facility,FilterDictionary) {
            FilterDictionary.add([
                'ftype', 'gg','jc','associationType']
            ).then(function () {
                window.Facility = new Facility('facility', panel);
                window.Facility.load(panel);
            });

        });
    };
</script>
