define(function(require) {
	var Config = require('config');
	var Core = require('core/core');
	var Page = require('core/page');
	
	var FacilityView = Page.extend(function() {
		
		var _self;
		// @override
		this.load = function(panel, data) {
			_self = this;
			var form = panel.find('form');

			Core.ajax(Config.ContextPath+'service/sjcj/facility/'+data.fid, {
				type: 'json',
				method: 'get'
			}).then(function(data) {
				_self.data = data;

				if(data.town != null && data.town != ""){
					panel.find('#facility_info_administrativevillage_val').combobox("clear");
					panel.find('#facility_info_administrativevillage_val').combobox('reload', Config.ContextPath + 'service/common/getUnitList?parentUnit=' + data.town);
				}

				form.form('load', data)
					.form('disableValidation')
					.form('focus');

			});


			panel.find('#facility_info_ftype').combobox({
				onChange: function() {
					var code = panel.find('#facility_info_ftype').combobox('getValue');
					panel.find('#facility_info_ftype2').combobox('clear');
					// 重新获取数据
					panel.find('#facility_info_ftype2').combobox('reload', Config.ContextPath+'service/common/getDatasByCatalogCode/' + code);
				}
			});

			panel.find('#facility_info_relation').combobox({
				onChange: function(newv,oldv) {
					if(newv == "1"){
						//清空村庄数据
						_self.panel.find("#facility_info_administrativevillage").hide();
						_self.panel.find("#facility_info_administrativevillage_val").combobox('clear');
						//改善项目数据，重新初始化显示
						if(oldv != null && oldv != ""){
							panel.find('#facility_info_hid_val').combobox('clear');
						}
						_self.panel.find("#facility_info_hid").show();
					} else 	if(newv == "2"){
						//清空村庄数据
						_self.panel.find("#facility_info_administrativevillage").hide();
						_self.panel.find("#facility_info_administrativevillage_val").combobox('clear');
						//改善项目数据，重新初始化显示
						if(oldv != null && oldv != ""){
							panel.find('#facility_info_hid_val').combobox('clear');
						}
						_self.panel.find("#facility_info_hid").show();
					}else {
						_self.panel.find("#facility_info_hid").hide();
						_self.panel.find("#facility_info_administrativevillage").show();
					}

				}
			});

			// 行政村、自然村联动
			panel.find('#facility_info_town_val').combobox({
				onChange: function (newValue, oldValue) {
					if (newValue != null){
						if(oldValue != null && oldValue != ""){
							panel.find('#facility_info_administrativevillage_val').combobox("clear");
						}
						panel.find('#facility_info_administrativevillage_val').combobox('reload', Config.ContextPath + 'service/common/getUnitList?parentUnit=' + newValue);
					}
				}
			});
		};
	});
	
	return FacilityView;
});