define(function(require) {
    var Config = require('config');
    var Core = require('core/core');
    var Page = require('core/page');

    
    var FacilityAdd = require('./facility.add');
    var FacilityEdit = require('./facility.edit');
    var FacilityView = require('./facility.view');
    var FacilityRemove = require('./facility.remove');
    var FacilityExp = require('./facility.exp');

    // 业务信息
    var Facility = Page.extend(function() {
    	
    	this.injecte([
          new FacilityAdd('facility_add'),
          new FacilityEdit('facility_edit'),
          new FacilityView('facility_view'),
          new FacilityRemove('facility_remove'),
          new FacilityExp('facility_exp')
    	]);
    	
    	// @override
    	this.load = function(panel) {
            this.$autoHeight('north', $('#facility-info-main', panel));
    		var table = this.table = panel.find('table');
    		
    		table.cdatagrid({
    			controller: this
    		});

            //获取登录用户信息,设置按钮显示权限，,
            Core.ajax(Config.ContextPath + 'service/common/getLoginUserUnitInfo', {
                method: 'get'
            }).then(function (loginUnitInfo) {
                //省级
                if(loginUnitInfo.unitType == 1 ){
                    panel.find('#facility_add_btn, #facility_add_btn + hr', panel).remove();
                    panel.find('#facility_add_btn').parent('td').next().remove();
                    panel.find('#facility_remove_btn, #facility_remove_btn + hr', panel).remove();
                    panel.find('#facility_remove_btn').parent('td').next().remove();
                }

            });

            //行政区划初始化
            panel.find('#facility_second').combobox({
                url: Config.ContextPath + "service/userinfo2/getUnitsByLoginAndUnitCode/2/320000000000",
                valueField: 'unitCode',
                textField: 'unitName',
                onLoadSuccess: function (list) {
                    if(list != null && list.length == 1){
                        $('#facility_second').combobox('select', list[0]["unitCode"]);
                        panel.find('#facility_third').combobox({
                            url: Config.ContextPath + "service/userinfo2/getUnitsByLoginAndUnitCode/3/"+list[0]["unitCode"] ,
                            valueField: 'unitCode',
                            textField: 'unitName',
                            onLoadSuccess: function (list2) {
                                if(list2 != null && list2.length == 1){
                                    $('#facility_third').combobox('select', list2[0]["unitCode"]);
                                    panel.find('#facility_fourth').combobox({
                                        url: Config.ContextPath + "service/userinfo2/getUnitsByLoginAndUnitCode/4/"+list2[0]["unitCode"] ,
                                        valueField: 'unitCode',
                                        textField: 'unitName',
                                        onLoadSuccess: function (list3) {
                                            if(list3 != null && list3.length == 1){
                                                $('#facility_fourth').combobox('select', list3[0]["unitCode"]);
                                            }
                                        }
                                    });
                                }
                            }
                        });
                    }
                }
            });

            //行政区划联动
            panel.find('#facility_second').combobox({
                onChange: function(newValue,oldValue) {
                    panel.find('#facility_third').combobox('clear');
                    panel.find('#facility_fourth').combobox('clear');
                    // 重新获取数据
                    if(newValue != null){
                        panel.find('#facility_third').combobox('reload', Config.ContextPath + "service/userinfo2/getUnitsByLoginAndUnitCode/3/"+newValue);
                    }
                }
            });
            //行政区划联动
            panel.find('#facility_third').combobox({
                onChange: function(newValue,oldValue) {
                    panel.find('#facility_fourth').combobox('clear');
                    // 重新获取数据
                    if(newValue != null){
                        panel.find('#facility_fourth').combobox('reload', Config.ContextPath + "service/userinfo2/getUnitsByLoginAndUnitCode/4/"+newValue);
                    }
                }
            });

    	};
    	
    });

    return Facility;
});