define(function(require) {
	var Config = require('config');
	var Core = require('core/core');
	var FacilityAdd = require('./facility.add');

	var FacilityEdit = FacilityAdd.extend(function() {
		var _self;
		// @override
		this.load = function(panel, data) {
			_self = this;
			var form = panel.find('form');

			Core.ajax(Config.ContextPath+'service/sjcj/facility/'+data.fid, {
				type: 'json',
				method: 'get'
			}).then(function(data) {
				_self.data = data;
				var fyear = data.fyear;
				if(data.relation=='1'){
					panel.find('#facility_info_hid_val').combobox('clear');
					// 重新获取数据
					panel.find('#facility_info_hid_val').combobox('reload', Config.ContextPath+'service/sjcj/newhousingjbxx/list2?isAddUserCodes=F&htype=3&statuss=05&wyearflag=true&wyear='+fyear);
				}
				if(data.relation=='2'){
					panel.find('#facility_info_hid_val').combobox('clear');
					// 重新获取数据
					panel.find('#facility_info_hid_val').combobox('reload', Config.ContextPath+'service/sjcj/newhousingjbxx/list2?isAddUserCodes=F&htype=5&statuss=05&wyearflag=true&wyear='+fyear);
				}
				if(data.town != null && data.town != ""){
					panel.find('#facility_info_administrativevillage_val').combobox("clear");
					panel.find('#facility_info_administrativevillage_val').combobox('reload', Config.ContextPath + 'service/common/getUnitList?parentUnit=' + data.town);
				}

				form.form('load', data)
					.form('disableValidation')
					.form('focus');

			});


			panel.find('#facility_info_ftype').combobox({
				onChange: function() {
					var code = panel.find('#facility_info_ftype').combobox('getValue');
					panel.find('#facility_info_ftype2').combobox('clear');
					// 重新获取数据
					panel.find('#facility_info_ftype2').combobox('reload', Config.ContextPath+'service/common/getDatasByCatalogCode/' + code);
				}
			});

			panel.find('#facility_info_relation').combobox({
				onChange: function(newv,oldv) {
					if(newv == "1"){//新型农房社区
						//清空村庄数据
						_self.panel.find("#facility_info_administrativevillage").hide();
						_self.panel.find("#facility_info_administrativevillage_val").combobox('clear');
						//改善项目数据，重新初始化显示
						if(oldv != null && oldv != ""){
							var fyear = panel.find("#fyear").val();
							if(fyear == ""){
								panel.find('#facility_info_hid_val').combobox('clear');
							}else{
								panel.find('#facility_info_hid_val').combobox('clear');
								panel.find('#facility_info_hid_val').combobox('reload', Config.ContextPath+'service/sjcj/newhousingjbxx/list2?isAddUserCodes=F&htype=3&statuss=05');
							}

						}
						_self.panel.find("#facility_info_hid").show();


					} else if(newv == "2"){
						//小城镇
						//清空村庄数据
						_self.panel.find("#facility_info_administrativevillage").hide();
						_self.panel.find("#facility_info_administrativevillage_val").combobox('clear');
						//改善项目数据，重新初始化显示
						if(oldv != null && oldv != ""){

							var fyear = panel.find("#fyear").val();
							if(fyear == ""){
								panel.find('#facility_info_hid_val').combobox('clear');
							}else{
								panel.find('#facility_info_hid_val').combobox('clear');
								panel.find('#facility_info_hid_val').combobox('reload', Config.ContextPath+'service/sjcj/newhousingjbxx/list2?isAddUserCodes=F&htype=5&statuss=05');
							}


						}
						_self.panel.find("#facility_info_hid").show();
					}  else {
						_self.panel.find("#facility_info_hid").hide();
						panel.find('#facility_info_hid_val').combobox('clear');
						_self.panel.find("#facility_info_administrativevillage").show();
					}

				}
			});
			panel.find('#fyear').combobox({
				onChange: function(newv,oldv) {
					if(newv != ''){

						var facility_info_relation  =  panel.find("#facility_info_relation").val();
						if(facility_info_relation == ""){
							facility_info_relation = data.relation;
						}
						if(facility_info_relation == "1"){
							//清空村庄数据
							_self.panel.find("#facility_info_administrativevillage").hide();
							_self.panel.find("#facility_info_administrativevillage_val").combobox('clear');
							//改善项目数据，重新初始化显示
							if(oldv != null && oldv != ""){
								panel.find('#facility_info_hid_val').combobox('clear');

								panel.find('#facility_info_hid_val').combobox('reload', Config.ContextPath+'service/sjcj/newhousingjbxx/list2?isAddUserCodes=F&htype=3&statuss=05&wyearflag=true&wyear='+newv);
							}
							_self.panel.find("#facility_info_hid").show();

						} else if(facility_info_relation == "2"){
							//清空村庄数据
							_self.panel.find("#facility_info_administrativevillage").hide();
							_self.panel.find("#facility_info_administrativevillage_val").combobox('clear');
							//改善项目数据，重新初始化显示
							if(oldv != null && oldv != ""){

								panel.find('#facility_info_hid_val').combobox('clear');
								panel.find('#facility_info_hid_val').combobox('reload', Config.ContextPath+'service/sjcj/newhousingjbxx/list2?isAddUserCodes=F&htype=5&statuss=05&wyearflag=true&wyear='+newv);
							}
							_self.panel.find("#facility_info_hid").show();
						}else{
							_self.panel.find("#facility_info_hid").hide();
							panel.find('#facility_info_hid_val').combobox('clear');
							_self.panel.find("#facility_info_administrativevillage").show();

						}
					}

				}
			});



			// 行政村、自然村联动
			panel.find('#facility_info_town_val').combobox({
				onChange: function (newValue, oldValue) {
					if (newValue != null){
						if(oldValue != null && oldValue != ""){
							panel.find('#facility_info_administrativevillage_val').combobox("clear");
						}
						panel.find('#facility_info_administrativevillage_val').combobox('reload', Config.ContextPath + 'service/common/getUnitList?parentUnit=' + newValue);
					}
				}
			});
		};
		
		// @override
		this.submit = function(panel, data, closeCallback) {
			var form = panel.find('form');

			// 开启校验
			form.form('enableValidation');
			var isValid = form.form('validate');
			//自定义校验
			var obj = form.form('value');
			if( (obj.builtarea == null || obj.builtarea == '') && (obj.facilitylength == null || obj.facilitylength == '')) {
				$.messager.alert('提醒', '建筑面积和长度至少填写一项！','warning');
				isValid = false;
			} else if((obj.relation == "1"||obj.relation == "2") && (obj.hid == null || obj.hid == '')){
				$.messager.alert('提醒', '关联类型为改善项目时，改善项目不可为空！','warning');
				isValid = false;
			} else if(obj.relation == "3" && (obj.administrativevillage == null || obj.administrativevillage == '')){
				$.messager.alert('提醒', '关联类型为行政村时，行政村不可为空！','warning');
				isValid = false;
			}
			if (isValid) {
				//校验流程是否提交。
				Core.ajax(Config.ContextPath+'service/sjcj/fundsummary/isChange?fstype=1&fsyear=' + obj.fyear+"&unitCode=" + obj.unitCode, {
					type: 'json',
					method: 'get'
				}).then(function(rlt) {
					var isChange = rlt.isChange;
					var msg = rlt.msg;
					if(isChange){
						form.form('ajax', {
							url: Config.ContextPath + 'service/sjcj/facility',
							method: 'post'
						}).then(closeCallback);
					} else {
						$.messager.alert('提醒', msg,'warning');
					}
				});

			}
			return false;
		};
		
		// @override
		this.onClose = function(table) {
			table.datagrid('reload');
		};
	});

	return FacilityEdit;
});