define(function(require) {
	var Config = require('config');
	var Page = require('core/page');
	var Core = require('core/core');
	
	var FacilityAdd = Page.extend(function() {
		var _self;
		// @override
		this.load = function(panel, data) {
			_self = this;
			var form = panel.find('form');
			// 
			form.form('disableValidation')
			.form('focus');

			panel.find('#facility_info_ftype').combobox({
				onChange: function() {
					var code = panel.find('#facility_info_ftype').combobox('getValue');
					panel.find('#facility_info_ftype2').combobox('clear');
					// 重新获取数据
					panel.find('#facility_info_ftype2').combobox('reload', Config.ContextPath+'service/common/getDatasByCatalogCode/' + code);
				}
			});


			panel.find('#facility_info_relation').combobox({
				onChange: function(newv,oldv) {
					if(newv == "1"){
						//清空村庄数据
						_self.panel.find("#facility_info_administrativevillage").hide();
						_self.panel.find("#facility_info_administrativevillage_val").combobox('clear');
						//情况项目数据，重新初始化显示
						panel.find('#facility_info_hid_val').combobox('clear');
						var fyear = panel.find("#fyear").val();
						if(fyear == ""){
							panel.find('#facility_info_hid_val').combobox('clear');
						}else{
							var url = Config.ContextPath+'service/sjcj/newhousingjbxx/list2?isAddUserCodes=F&htype=3&statuss=05&wyearflag=true&wyear='+fyear;
							_self.panel.find("#facility_info_hid_val").combobox({
								url:url,
								valueField:'hid',
								textField:'houseName'
							});
						}

						_self.panel.find("#facility_info_hid").show();
					} else if(newv == "2"){
						//清空村庄数据
						_self.panel.find("#facility_info_administrativevillage").hide();
						_self.panel.find("#facility_info_administrativevillage_val").combobox('clear');
						//情况项目数据，重新初始化显示
						panel.find('#facility_info_hid_val').combobox('clear');

						var fyear = panel.find("#fyear").val();
						if(fyear == ""){
							panel.find('#facility_info_hid_val').combobox('clear');
						}else{
							var url = Config.ContextPath+'service/sjcj/newhousingjbxx/list2?isAddUserCodes=F&htype=5&statuss=05&wyearflag=true&wyear='+fyear;
							_self.panel.find("#facility_info_hid_val").combobox({
								url:url,
								valueField:'hid',
								textField:'houseName'
							});
						}


						_self.panel.find("#facility_info_hid").show();
					}else{
						_self.panel.find("#facility_info_hid").hide();
						panel.find('#facility_info_hid_val').combobox('clear');
						_self.panel.find("#facility_info_administrativevillage").show();

					}
				}
			});
			panel.find('#fyear').combobox({
				onChange: function(newv,oldv) {
					if(newv != ''){

						var facility_info_relation  =  panel.find("#facility_info_relation").val();
						if(facility_info_relation == "1"){
							//清空村庄数据
							_self.panel.find("#facility_info_administrativevillage").hide();
							_self.panel.find("#facility_info_administrativevillage_val").combobox('clear');
							//情况项目数据，重新初始化显示
							panel.find('#facility_info_hid_val').combobox('clear');
							var url = Config.ContextPath+'service/sjcj/newhousingjbxx/list2?isAddUserCodes=F&htype=3&statuss=05&wyearflag=true&wyear='+newv;
							_self.panel.find("#facility_info_hid_val").combobox({
								url:url,
								valueField:'hid',
								textField:'houseName'
							});
							_self.panel.find("#facility_info_hid").show();
						} else if(facility_info_relation == "2"){

							//清空村庄数据
							_self.panel.find("#facility_info_administrativevillage").hide();
							_self.panel.find("#facility_info_administrativevillage_val").combobox('clear');
							//情况项目数据，重新初始化显示
							panel.find('#facility_info_hid_val').combobox('clear');
							var url = Config.ContextPath+'service/sjcj/newhousingjbxx/list2?isAddUserCodes=F&htype=5&statuss=05&wyearflag=true&wyear='+newv;
							_self.panel.find("#facility_info_hid_val").combobox({
								url:url,
								valueField:'hid',
								textField:'houseName'
							});
							_self.panel.find("#facility_info_hid").show();
						}else{
							_self.panel.find("#facility_info_hid").hide();
							panel.find('#facility_info_hid_val').combobox('clear');
							_self.panel.find("#facility_info_administrativevillage").show();

						}
					}

				}
			});

			// 行政村、自然村联动
			panel.find('#facility_info_town_val').combobox({
				onChange: function (newValue, oldValue) {
					if (newValue != null){
						panel.find('#facility_info_administrativevillage_val').combobox("clear");
						panel.find('#facility_info_administrativevillage_val').combobox('reload', Config.ContextPath + 'service/common/getUnitList?parentUnit=' + newValue);
					}
				}
			});


		};

		this.submit = function (panel, data, closeCallback) {
			submitDosomething(panel, data, closeCallback, 1);
			return false;
		};
		this.submitNext = function (panel, data, closeCallback) {
			submitDosomething(panel, data, closeCallback, 2);
			return false;
		};
		var submitDosomething = function (panel, data, closeCallback, type) {
			var form = panel.find('form');
			
			// 开启校验
			form.form('enableValidation');
			var isValid = form.form('validate');
			//自定义校验
			var obj = form.form('value');
			if( (obj.builtarea == null || obj.builtarea == '') && (obj.facilitylength == null || obj.facilitylength == '')) {
				$.messager.alert('提醒', '建筑面积和长度至少填写一项！','warning');
				isValid = false;
			} else if((obj.relation == "1"||obj.relation == "2") && (obj.hid == null || obj.hid == '')){
				$.messager.alert('提醒', '关联类型为改善项目时，改善项目不可为空！','warning');
				isValid = false;
			} else if(obj.relation == "3" && (obj.administrativevillage == null || obj.administrativevillage == '')){
				$.messager.alert('提醒', '关联类型为行政村时，行政村不可为空！','warning');
				isValid = false;
			}
			if (isValid) {
				//校验：改善项目增加基础设施之前必须补充投资额信息。
				Core.ajax(Config.ContextPath+'service/sjcj/fundsummary/isChange?fstype=1&fsyear=' + obj.fyear, {
					type: 'json',
					method: 'get'
				}).then(function(rlt) {
					var isChange = rlt.isChange;
					var msg = rlt.msg;
					if(isChange){
						form.form('ajax', {
							url: Config.ContextPath + 'service/sjcj/facility',
							method: 'post'
						}).then(function (data) {
							if (type == 1) {
								closeCallback();
							} else {
								//保存后新增加：1.提醒保存成功，2.清空form数据，3.重新初始化变量和form数据（有些可使用load，有些需要自定义加载）
								$.messager.alert('提醒', '新增成功！请继续增加！');
								var panel = _self.panel;
								/*var form = panel.find('form');
								form.form('clear').form('disableValidation');*/
								panel.find("#unitCode").val(data.unitCode);
								panel.find("#facility_info_relation").combobox("setValue", data.relation);
								panel.find("#fyear").combobox("setValue", data.fyear);
								panel.find("#facility_info_hid_val").combobox("setValue", data.hid);

								panel.find('#facility_info_ftype').combobox('clear');
								panel.find('#facility_info_ftype2').combobox('clear');
								panel.find("#fname").textbox('setValue', '');
								panel.find("#builtarea").numberbox('setValue', '');
								panel.find("#facilitylength").numberbox('setValue', '');
								panel.find("#money").numberbox('setValue', '');




							}
						});
					} else {
						$.messager.alert('提醒', msg,'warning');
					}

				});

			}
			
			return false;
		};
		
		// @override 
		this.onClose = function(table, data) {
			table.datagrid('reload');
		};
	});
	
	return FacilityAdd;
});