define(function(require) {
    var Config = require('config');
    var Core = require('core/core');
    var Page = require('core/page');
    var $ = require('jquery');
    var ajaxSubmit = require('plugins/jquery.form');
    var RandomselectionViewSJSC = Page.extend(function() {
        var _self;
        // @override
        this.load = function(panel) {
            _self=this;
            var table = this.table = panel.find('table');
            var url = "service/utils/farmhousejbxxHouseVillage?isbetters=ST";
            table.cdatagrid({
                controller: this
            });

            //市
            panel.find('#sjsecond').combobox({
                url: Config.ContextPath + "service/jhgswork/getUnitInfoSecond?code=320000000000",
                valueField: 'unitCode',
                textField: 'unitName',
                onLoadSuccess: function (data) {
                    var da = data[0];
                    if (da != undefined) {
                        if (da["yhjb"] == "fsj") {
                            panel.find('#sjsecond').combobox('select', da["unitCode"]);
                            panel.find("#sjsecond").combobox('readonly', true);
                        }
                    }

                }
            });
            //区县
            panel.find('#sjthird').combobox({
                url: Config.ContextPath + "service/jhgswork/getUnitInfothird",
                valueField: 'unitCode',
                textField: 'unitName',
                onLoadSuccess: function (data) {
                    var da = data[0];
                    if (da != undefined) {
                        if (da["yhjb"] == "fsj") {
                            panel.find('#sjthird').combobox('select', da["unitCode"]);
                            panel.find("#sjthird").combobox('readonly', true);
                        }
                    }

                }
            });
            //市改变
            panel.find('#sjsecond').combobox({
                onChange: function() {
                    var code = panel.find('#sjsecond').combobox('getValue');
                    panel.find('#sjthird').combobox('clear');
                    // 重新获取数据
                    panel.find('#sjthird').combobox('reload', Config.ContextPath+'service/jhgswork/getUnitInfothird?code=' + code);
                }
            });



            //查询-巡查
            panel.find('#sj_create').click(function() {
              url = 'service/sjcj/farmhousejbxx/randomFarmhouse?t=t';
              var second = panel.find('#sjthird').combobox('getValue');
              var districtcode = panel.find('#sjthird').combobox('getValue');
              if(districtcode==null || districtcode==undefined || districtcode==''){
                  $.messager.alert('提醒', '请选择县区！');
                  return false;
              }

              var year = panel.find('#realityyear').combobox('getValues');
                if(realityyear==null || realityyear==undefined || realityyear==''){
                    $.messager.alert('提醒', '请选择实际改善年份！');
                    return false;
                }
            /*  if(second != ''){
                  url += '&second='+second;
              }*/
              if(districtcode != ''){
                url += '&districtcode='+districtcode;
              }

              if(year != null && year.length > 0){
                    url += "&realityyear=";
                    for(var i = 0 ; i < year.length ; i++){
                        url += year[i] + "a";
                    }
                    url = url.substring(0,url.length - 1);
              }

              table.cdatagrid({
                    controller: this,
                    url : url,
                });
            });

            //查询-抽查
            panel.find('#sj_create2').click(function() {
                url = 'service/sjcj/farmhousejbxx/randomFarmhouse?t=t&rtype=1';
                var second = panel.find('#sjthird').combobox('getValue');
                var districtcode = panel.find('#sjthird').combobox('getValue');
                if(districtcode==null || districtcode==undefined || districtcode==''){
                    $.messager.alert('提醒', '请选择县区！');
                    return false;
                }

                var year = panel.find('#realityyear').combobox('getValues');
                if(realityyear==null || realityyear==undefined || realityyear==''){
                    $.messager.alert('提醒', '请选择实际改善年份！');
                    return false;
                }
                /*  if(second != ''){
                      url += '&second='+second;
                  }*/
                if(districtcode != ''){
                    url += '&districtcode='+districtcode;
                }

                if(year != null && year.length > 0){
                    url += "&realityyear=";
                    for(var i = 0 ; i < year.length ; i++){
                        url += year[i] + "a";
                    }
                    url = url.substring(0,url.length - 1);
                }
                panel.find('#rs_rtype').val("1");
                table.cdatagrid({
                    controller: this,
                    url : url,
                });
            });
        };

        // @override
        this.submit = function(panel, data, closeCallback) {
            var table = this.table = panel.find('#table_farmhousejbxxHouseVillages');
            var rows = table.datagrid('getData').rows;

            if(rows != null && rows.length > 0) {
                var form = panel.find('#farmhousejbxxHouseVillages_form');
                var year = panel.find('#realityyear').combobox('getValues');
                var yearStr = '';
                for(var i = 0 ; i < year.length ; i++){
                    yearStr += year[i] + ",";
                }
                if(yearStr!=''){
                    yearStr =yearStr.substring(0,yearStr.length-1);
                }
                var rtype = panel.find('#rs_rtype').val();
                form.form('ajax', {
                    url: Config.ContextPath + 'service/task/randomSelection?realityyear='+yearStr + (rtype == '1' ? '&rtype=1':''),
                    method: 'post'
                }).then(function(data){
                    if (data.isOk == false) {
                        $.messager.alert('提醒', data.msg);
                    } else {
                        //保存子表
                        var json = JSON.stringify(rows);
                        var rid = data.obj.rid;
                        Core.ajax(Config.ContextPath + 'service/task/randomselectiondeail/saveSubRandomselectiondeail', {//保存子表
                            type: 'json',
                            method: 'post',
                            traditional: true,
                            data: {"list": json, "rid": rid},
                        }).then(closeCallback);
                    }
                });


            }else{
                $.messager.alert('提醒', '请先随机抽取');
                return false;
            }


        };

        // @override

        this.onClose = function() {
             _self.parent.panel.find('#randomselection_table').datagrid('reload');
        };

    });

    return RandomselectionViewSJSC;
});
