define(function(require) {
    var Config = require('config');
    var Core = require('core/core');
    var Page = require('core/page');
    var Dialog = require('centit/centit.dialog');

    
    var RandomselectionAdd = require('./randomselection.add');
    var RandomselectionEdit = require('./randomselection.edit');
    var RandomselectionView = require('./randomselection.view');
    var RandomselectionRemove = require('./randomselection.remove');


    // 业务信息
    var Randomselection = Page.extend(function() {
    	
    	this.injecte([
          new RandomselectionAdd('randomselection_add'),
          new RandomselectionEdit('randomselection_edit'),
          new RandomselectionView('randomselection_view'),
          new RandomselectionRemove('randomselection_remove'),

    	]);
        var _self;
    	// @override
    	this.load = function(panel) {
    	    _self = this;
            this.$autoHeight('north', panel.find('#randomselection-info-main', panel));
            var url = "service/task/randomSelection";
            var table = panel.find('#randomselection_table');
            table.cdatagrid({
                controller: this,
                url: url
            });

            //随机生成
            panel.find('#randomselection_sjsc').click(function() {
                var SelectUser = require('modules/randomSel/randomselection/ctrl/randomselection.sjsc');
                var _SelectUser = new SelectUser("randomselection_sjsc");
                _self.controllers["randomselection_sjsc"] = _SelectUser;
                _SelectUser.parent = _self;
                Dialog.open({
                    id : 'selectuser',
                    title : '随机抽取',
                    href : "modules/randomSel/randomselection/randomselection-sjsc.jsp",
                    width : 1300,
                    height :600,
                    buttons:[{method: 'submit', text: '保存记录'}]
                }, {}, _self.controllers["randomselection_sjsc"]);
            });

            //第一次加载
            panel.find('#first').combobox({
                url: Config.ContextPath + "service/jhgswork/getUnitInfoFirst",
                valueField: 'unitCode',
                textField: 'unitName',
                onLoadSuccess: function (data) {
                    var da = data[0];
                    $('#first').combobox('select', da["unitCode"]);
                    $("#first").combobox('readonly', true);

                }
            });

            panel.find('#second').combobox({
                url: Config.ContextPath + "service/jhgswork/getUnitInfoSecond",
                valueField: 'unitCode',
                textField: 'unitName',
                onLoadSuccess: function (data) {
                    var da = data[0];
                    if (da != undefined) {
                        if (da["yhjb"] == "fsj") {
                            $('#second').combobox('select', da["unitCode"]);
                            $("#second").combobox('readonly', true);
                        }
                    }

                }
            });

            panel.find('#third').combobox({
                url: Config.ContextPath + "service/jhgswork/getUnitInfothird",
                valueField: 'unitCode',
                textField: 'unitName',
                onLoadSuccess: function (data) {
                    var da = data[0];
                    if (da != undefined) {
                        if (da["yhjb"] == "fsj") {
                            $('#third').combobox('select', da["unitCode"]);
                            $("#third").combobox('readonly', true);
                        }
                    }

                }
            });


            panel.find('#first').combobox({
                onChange: function() {
                    var code = panel.find('#first').combobox('getValue');
                    panel.find('#second').combobox('clear');
                    // 重新获取数据
                    panel.find('#second').combobox('reload', Config.ContextPath+'service/jhgswork/getUnitInfoSecond?code=' + code);
                }
            });
            panel.find('#second').combobox({
                onChange: function() {
                    var code = panel.find('#second').combobox('getValue');
                    panel.find('#third').combobox('clear');
                    // 重新获取数据
                    panel.find('#third').combobox('reload', Config.ContextPath+'service/jhgswork/getUnitInfothird?code=' + code);
                }
            });


    	};
    	
    });

    return Randomselection;
});