define(function(require) {
	var Config = require('config');
	var Core = require('core/core');
	var RandomselectionAdd = require('./randomselection.add');

	var RandomselectionEdit = RandomselectionAdd.extend(function() {
		var _self ;
		
		// @override
		this.load = function(panel, data) {
            _self = this;
			var form = panel.find('form');
			Core.ajax(Config.ContextPath+'service/task/randomSelection/'+data.rid, {
				type: 'json',
				method: 'get' 
			}).then(function(data) {
				_self.data = data;
				
				form.form('load', data)
					.form('disableValidation')
					.form('readonly', 'rid')
					.form('focus');
                var url = "service/task/loadRandomselectiondeail/"+data.rid;
                Core.ajax(Config.ContextPath + url, {
                    method: 'get'
                }).then(function(list) {
                    if(list.objList != null && list.objList.length > 0){
                        var rlt = list.objList;
                        for(var i = 0 ; i < rlt.length ; i ++){
                            rlt[i].isreal = '<select name="isreal+'+ rlt[i].riid+'"><option value="T" selected>是</option><option value="F">否</option></select> ';
                            rlt[i].remarks = " <input name='remarks" + rlt[i].riid + "' class='in' style='width:50px' " +
                                "value='" + (rlt[i].remarks != null ? rlt[i].remarks : '' )+ "'>";
						}
                        var table = this.table = panel.find('#table_farmhousejbxxHouseVillages');
                        table.cdatagrid({
                            controller : _self
                        }).datagrid('loadData', rlt);
                    }

				});
			});
		};
		
		// @override
		this.submit = function(panel, data, closeCallback) {
            var table = this.table = panel.find('#table_farmhousejbxxHouseVillages');
            var rows = table.datagrid('getData').rows;
            if(rows != null && rows.length > 0) {
                var form = panel.find('#farmhousejbxxHouseVillages_form');
                form.form('ajax', {
                    url: Config.ContextPath + 'service/task/randomSelection/',
                    method: 'post'
                }).then(function(data){
                    if (data.isOk == false) {
                        $.messager.alert('提醒', data.msg);
                    } else {
                        var list = new Array();
                        for(var i = 0 ; i < rows.length ; i++){
                            var row = rows[i];
                            var temp = new Object();
                            temp.isreal = $("select[name='isreal+" + row.riid + "']").val();
                            temp.remarks = $("input[name='remarks+" + row.riid + "']").val();
                            temp.fid = rows[i].fid;
                            temp.riid = rows[i].riid;
                            temp.orderno = rows[i].orderno;
                            list[i] = temp;
                        }
                        //保存子表
                        var json = JSON.stringify(list);
                        var rid = data.obj.rid;
                        Core.ajax(Config.ContextPath + 'service/task/randomselectiondeail/saveSubRandomselectiondeail', {//保存子表
                            type: 'json',
                            method: 'post',
                            traditional: true,
                            data: {"list": json, "rid": rid},
                        }).then(closeCallback);
                    }
                });


            }

			return false;
		};
		
		// @override
		this.onClose = function(table) {
			table.datagrid('reload');
		};
	});

	return RandomselectionEdit;
});