function toFarmhouseList1(hid, point) {

    var lng = point.lng;
    var lat = point.lat;
    $(".cy-dialog").show();
    $('#map_iframe_village').attr("src", "../../modules/dp/test.html?hid=" + hid + "&lng=" + lng + "&lat=" + lat);

}

$(function () {
    var baseURL = "http://localhost:8080/nfgl/";
    var yhjb = "1";
    var curSelectObj = {
        "unitCode": "320000000000",
        "unitName": "江苏省",
        "unitType": 1,
        "unitManager": "119.692431,32.802493"
    };
    //初始化地图
    reLoadFromUnit();
    //五市各地改善农户类型占比
    loadBlock1();
    // loadBlock1();
    loadBlock2();
    //改善前后人均住房面积提升
    loadBlock3();
    //自然村数据统计分析
    loadBlock5();
    //省定各市目标及完成数
    loadBlock6();
    //各地新建改善项目数据分析
    loadBlock7();
    //五市各地改善项目统计
    loadBlock8();
    //各地县区改善工作评价
    loadBlock4();
    //四类人群表格数据
    fourPeopleData();
    //公共投资额
    serviveMonkey();
    //乡村基本数据
    baseCountryData();

    //地图重新加载江苏
    $('#mapReLoad_js_btn').click(function () {
        $('#home_city_combobox').combobox('clear');
        $('#home_district_combobox').combobox('clear');
        $('#home_town_combobox').combobox('clear');
        curSelectObj = {
            "unitCode": 320000000000,
            "unitName": "江苏省",
            "unitType": 1,
            "unitManager": "119.692431,32.802493"
        };
        reLoadFromUnit();
    });

    //初始化行政区划下拉框
    // 市下拉框
    $('#home_city_combobox').combobox({
        url: baseURL + 'service/common/getUnitList?parentUnit=320000000000&sb=T',
        onSelect: function (row) {
            if (row.unitName != '') {
                $('#home_district_combobox').combobox('reload', baseURL + 'service/common/getUnitList?parentUnit=' + row.unitCode);
                curSelectObj = {
                    "unitCode": row.unitCode,
                    "unitName": row.unitName,
                    "unitType": row.unitType,
                    "unitManager": row.unitManager
                };
                reLoadFromUnit();
            }
        },
        onChange: function (newValue, oldValue) {
            $('#home_district_combobox').combobox('clear');
            $('#home_town_combobox').combobox('clear');
            if (newValue == '') {
                $('#home_district_combobox').combobox('loadData', {});
                curSelectObj.unitCode = '320000000000';
                curSelectObj.unitName = '江苏省';
            }
            if(newValue == '320300000000'){
                $(".cy_title1").text("徐州市");
                $(".cy_title").text("徐州市");
            }
            if(newValue == '320700000000'){
                $(".cy_title1").text("连云港市");
                $(".cy_title").text("连云港市");
            }
            if(newValue == '320800000000'){
                $(".cy_title1").text("淮安市");
                $(".cy_title").text("淮安市");
            }
            if(newValue == '320900000000'){
                $(".cy_title1").text("盐城市");
                $(".cy_title").text("盐城市");
            }
            if(newValue == '321300000000'){
                $(".cy_title1").text("宿迁市");
                $(".cy_title").text("宿迁市");
            }
            var cy_year = $("#cc").combobox("getText");
            var cy_city = newValue.substring(0, 4);
            loadBlock1(cy_year,cy_city);//五市各地改善农户类型占比
            loadBlock2(cy_year, '');//拆除旧房面积和退出宅基地面积数据统计
            loadBlock3(cy_year);// 改善前后人均住房面积提升
            loadBlock4(cy_year, cy_city);//各地县区改善工作评价
            loadBlock5(cy_year,cy_city);//自然村数据统计分析
            loadBlock6(cy_year, cy_city);//省定各市目标及完成数
            loadBlock7('',cy_city)//各地新建改善项目数据分析
            loadBlock8(cy_year, '');//五市各地改善项目统计
            fourPeopleData(cy_year, cy_city);//四类人群数据
            baseCountryData(cy_year, cy_city);
        }
    });
    //点击年份时间
    $.getJSON("js/baseUrl.json", function (rlt) {
        var baseURL = rlt.baseUrl;
        $('#cc').combobox({
            onSelect: function (row) {
            },
            onChange: function (newValue, oldValue) {
                var cy_year = $("#cc").combobox("getText");
                var cy_city = $('#home_city_combobox').combobox("getValue").slice(0, 4);
                loadBlock1(cy_year,cy_city);//五市各地改善农户类型占比
                loadBlock2(cy_year, '');//拆除旧房面积和退出宅基地面积数据统计
                loadBlock3(cy_year);// 改善前后人均住房面积提升
                loadBlock4(cy_year, cy_city);//各地县区改善工作评价
                loadBlock5(cy_year,cy_city);//自然村数据统计分析
                loadBlock6(cy_year, cy_city);//省定各市目标及完成数
                loadBlock7('',cy_city)//各地新建改善项目数据分析
                loadBlock8(cy_year, '');//五市各地改善项目统计
                fourPeopleData(cy_year, cy_city);//四类人群数据
                serviveMonkey(cy_year);
                baseCountryData(cy_year);//乡村基本数据
            }
        });
    });
    // 区下拉框
    $('#home_district_combobox').combobox({
        onSelect: function (row) {
            if (row.unitName != '') {
                $('#home_town_combobox').combobox('reload', baseURL + 'service/common/getUnitList?parentUnit=' + row.unitCode);
                curSelectObj = {
                    "unitCode": row.unitCode,
                    "unitName": row.unitName,
                    "unitType": row.unitType,
                    "unitManager": row.unitManager
                };
                reLoadFromUnit();
            }
        },
        onChange: function (newValue, oldValue) {
            $('#home_town_combobox').combobox('clear');
            if (newValue == '') {
                $('#home_town_combobox').combobox('loadData', {});
                if ("" != $('#home_city_combobox').combobox('getValue')) {
                    curSelectObj.unitCode = $('#home_city_combobox').combobox('getValue');
                }
                curSelectObj.unitName = $('#home_city_combobox').combobox('getText');
            }
        }
    });

    // 镇下拉框
    $('#home_town_combobox').combobox({
        onSelect: function (row) {
            if (row.unitName != '') {
                curSelectObj = {
                    "unitCode": row.unitCode,
                    "unitName": row.unitName,
                    "unitType": row.unitType,
                    "unitManager": row.unitManager
                };
                reLoadFromUnit();
            }
        },
        onChange: function (newValue, oldValue) {
            if (newValue == '') {
                if ("" != $('#home_district_combobox').combobox('getValue')) {
                    curSelectObj.unitCode = $('#home_district_combobox').combobox('getValue');
                }
                curSelectObj.unitName = $('#home_city_combobox').combobox('getText') + $('#home_district_combobox').combobox('getText');
            }
        }
    });
    $("#mapReLoad_js_btn").on("click", function () {
        loadBlock1();
        // loadBlock1();
        loadBlock2();
        //改善前后人均住房面积提升
        loadBlock3();
        //自然村数据统计分析
        loadBlock5();
        //省定各市目标及完成数
        loadBlock6();
        //各地新建改善项目数据分析
        loadBlock7();
        //五市各地改善项目统计
        loadBlock8();
        //各地县区改善工作评价
        loadBlock4();
        baseCountryData();
        $(".cy_title1").text("各地");
        $(".cy_title").text("");
    })


    //行政区划改变导致页面数据加载
    function reLoadFromUnit() {
        //行政区划子页面赋值
        setXzqhObj();
        //边界绘制
        loadBoundary();
        //加载元素：点位图/热力图
        loadOverlay();
        //getHouseCount(curSelectObj.unitCode);
        //getHeatData();
    }

    // 热力图
    //$('#heat_map_btn').bind('click', toggleHeat);

    //加载点位图/热力图，农户/改善项目
    function loadOverlay() {
        var subMap = $("#home_map_iframe")[0].contentWindow;
        if (subMap.loadOverlay != null && subMap.map != null) {
            subMap.loadOverlay(curSelectObj.unitCode);
        } else {
            setTimeout(loadOverlay, 500);
        }
    }

    //行政区划子页面赋值
    function setXzqhObj() {
        var subMap = $("#home_map_iframe")[0].contentWindow;
        if (subMap.setXzqhObj != null) {
            subMap.setXzqhObj(curSelectObj);
        } else {
            setTimeout(setXzqhObj, 500);
        }
    }

    //点位图--农户/改善项目
    function loadPoint() {
        var subMap = $("#home_map_iframe")[0].contentWindow;
        if (subMap.loadPointByShowType != null && subMap.map != null) {
            subMap.loadPointByShowType(curSelectObj.unitCode);
        } else {
            setTimeout(loadPoint, 500);
        }
    }

    // 地图 - 绘制区划边界
    function loadBoundary() {
        var subMap = $("#home_map_iframe")[0].contentWindow;
        if (subMap.markBoundary != null && subMap.map != null) {
            subMap.markBoundary(curSelectObj, true);
            //根据最后的行政区划编码获取子集，标出子集范围
            $.ajax({
                url: baseURL + 'service/common/getUnitList?parentUnit=' + curSelectObj.unitCode,    //请求的url地址
                async: true,
                type: "get",   //请求方式
                success: function (rlt) {
                    if (rlt != null && rlt.length > 0) {
                        for (var i = 0; i < rlt.length; i++) {
                            subMap.markBoundary(rlt[i], false);
                        }
                    }
                },
                error: function (rlt, msg) {
                    consol.log("根据父级获取子集行政区划获取失败，原因：" + msg);
                }
            });
        } else {
            setTimeout(loadBoundary, 500);
        }
    }

// 地图 - 清除区划边界
    function clearBoundary() {
        var subMap = $("#home_map_iframe")[0].contentWindow;
        if (subMap.clearBoundary != null && subMap.map != null) {
            subMap.clearBoundary();
        } else {
            setTimeout(clearBoundary, 500);
        }
    }

// 地图 - 获取农改户数
    function getHouseCount(unitCode) {
        $.ajax({
            url: baseURL + 'service/sjcj/farmhousejbxx/getHouseCnt/' + unitCode,    //请求的url地址
            dataType: "json",   //返回格式为json
            async: true,
            type: "get",   //请求方式
            success: function (rlt) {
                loadHouseCntLabel(rlt.data);
            },
            error: function () {
                console.log("错误")
            }
        })
    }

// 地图 - 添加农改户数标注
    function loadHouseCntLabel(rlt) {
        var subMap = $("#home_map_iframe")[0].contentWindow;
        if (subMap.markHouseCount != null && subMap.map != null) {
            subMap.markHouseCount(rlt, curSelectObj.unitName);
        } else {
            setTimeout(function () {
                loadHouseCntLabel(rlt)
            }, 500);
        }
    }

// 地图 - 获取热力图所需数据
    function getHeatData() {
        $.ajax({
            url: baseURL + 'service/sjcj/farmhousejbxx/getListForHeatmap/' + curSelectObj.unitCode,    //请求的url地址
            type: "get",   //请求方式
            success: function (rlt) {
                rlt = rlt.data;
                drawHeatMap(rlt);
            },
            error: function () {
                console.log("错误")
            }
        })

    }

// 地图 - 绘制热力图
    function drawHeatMap(rlt) {
        var subMap = $("#home_map_iframe")[0].contentWindow;
        if (subMap.drawHeatMap != null && subMap.map != null) {
            subMap.drawHeatMap(rlt);
        } else {
            setTimeout(function () {
                drawHeatMap(rlt)
            }, 500);
        }
    }

// 地图 - 热力图显示、隐藏
    function toggleHeat() {
        var subMap = $("#home_map_iframe")[0].contentWindow;
        if ($("#heat_map_btn").linkbutton("options").selected) {
            if (subMap.showHeatMap != null && subMap.map != null) {
                subMap.showHeatMap();
            } else {
                setTimeout(toggleHeat, 500);
            }
        } else {
            if (subMap.hideHeatMap != null && subMap.map != null) {
                subMap.hideHeatMap();
            } else {
                setTimeout(toggleHeat, 500);
            }
        }
    }

    //请求基本数据
    function baseCountryData(year, city) {
        $.getJSON("js/baseUrl.json", function (rlt) {
            var baseURL = rlt.baseUrl;
            var cy_URL = baseURL + 'service/sjcj/dp/loadData?dataCode=jcsj';
            if (year != undefined) {
                if (year != "全年") {
                    cy_URL += '&dataYear=' + year
                }
            }
            if (city != "" && city != undefined) {
                cy_URL += '&cityCode=' + city
            }
            $.ajax({
                url: cy_URL,
                async: true,
                type: "get",
                success: function (data) {
                    if (data != "") {
                        $(".cy_city").text(data.city);
                        $(".cy_county").text(data.county);
                        $(".cy_town").text(data.town);
                        $(".cy_administrativeVillage").text(data.administrativeVillage);
                        $(".cy_naturalVillage").text(data.naturalVillage);
                        $(".cy_project1").text(data.project1);
                        $(".cy_project1NF").text(data.project1NF);
                        $(".cy_project2").text(data.project2);
                        $(".cy_project2NF").text(data.project2NF);
                        $(".cy_cyNF").text(data.cyNF);
                        $(".cy_gsNF").text(data.gsNF);
                    } else {
                        $(".cy_city").text("");
                        $(".cy_county").text("");
                        $(".cy_town").text("");
                        $(".cy_administrativeVillage").text("");
                        $(".cy_naturalVillage").text("");
                        $(".cy_project1").text("");
                        $(".cy_project1NF").text("");
                        $(".cy_project2").text("");
                        $(".cy_project2NF").text("");
                        $(".cy_cyNF").text("");
                        $(".cy_gsNF").text("");
                    }
                },
                error: function (rlt, msg) {
                    console.log("获取失败，原因：" + msg);
                }
            });

        });
    }

    //四类人群表格数据
    function fourPeopleData(year, city) {
        $.getJSON("js/baseUrl.json", function (rlt) {
            var baseURL = rlt.baseUrl;
            var cy_URL = baseURL + 'service/sjcj/dp/loadData?dataCode=sldx';
            if (year != undefined) {
                if (year != "全年") {
                    cy_URL += '&dataYear=' + year
                }
            }
            if (city != "" && city != undefined) {
                cy_URL += '&cityCode=' + city
            }
            $.ajax({
                url: cy_URL,    //请求的url地址
                async: true,
                type: "get",
                success: function (data) {
                    if (data != "") {
                        $("#cy_dsrnh").text(data.A);
                        $("#cy_dbh").text(data.B);
                        $("#cy_tkry").text(data.D);
                        $("#cy_pkcjjt").text(data.C);
                        var fourPeople = data.A + data.B + data.C + data.D;
                        var sum = fourPeople + data.FSL;
                        $("#cy_fslrq").text((data.FSL / sum * 100).toFixed(2) + '%');
                        $("#cy_slrq").text((fourPeople / sum * 100).toFixed(2) + '%');
                    } else {
                        $("#cy_dsrnh").text("");
                        $("#cy_dbh").text("");
                        $("#cy_tkry").text("");
                        $("#cy_pkcjjt").text("");
                        $("#cy_fslrq").text("");
                        $("#cy_slrq").text("");
                    }


                },
                error: function (rlt, msg) {
                    console.log("获取失败，原因：" + msg);
                }
            })
        })
    }

    //公共服务设施和基础设施面积和投资额统计
    function serviveMonkey(year, city) {
        $.getJSON("js/baseUrl.json", function (rlt) {
            var baseURL = rlt.baseUrl;
            var cy_URL = baseURL + 'service/sjcj/dp/loadData?dataCode=ss';
            if (year != undefined) {
                if (year != "全年") {
                    cy_URL += '&dataYear=' + year
                }
            }
            if (city != "" && city != undefined) {
                cy_URL += '&cityCode=' + city
            }
            $.ajax({
                url: cy_URL,    //请求的url地址
                async: true,
                type: "get",
                success: function (data) {
                    if (data != "") {
                        var cityName = [];
                        var ggmj_list = [];//公共设施面积
                        var ggje_list = [];//公共设施投资额（金额）
                        var jcmj_list = [];//基础设施面积
                        var jcje_list = [];//基础设施投资额（金额）
                        $.each(data.jcmj, function (index, item) {
                            cityName.push(index);    //挨个取出类别并填入类别数组
                            jcmj_list.push(item);
                        });
                        $.each(data.jcje, function (index, item) {
                            jcje_list.push(item);
                        });
                        $.each(data.ggmj, function (index, item) {
                            ggmj_list.push(item);
                        });
                        $.each(data.ggje, function (index, item) {
                            ggje_list.push(item);
                        });
                        for (var i = 0; i < cityName.length; i++) {
                            $(".cy-city-name").eq(i).text(cityName[i]);
                            $(".cy-jjss-area").eq(i).text(jcmj_list[i]);
                            $(".cy-jjss-monkey").eq(i).text(jcje_list[i]);
                            $(".cy-ggfw-area").eq(i).text(ggmj_list[i]);
                            $(".cy-ggfw-monkey").eq(i).text(ggje_list[i]);
                        }
                    } else {
                        var cityName = ["盐城", "徐州", "淮安", "宿迁", "连云港"];
                        for (var i = 0; i < cityName.length; i++) {
                            $(".cy-city-name").eq(i).text(cityName[i]);
                            $(".cy-jjss-area").text("");
                            $(".cy-jjss-monkey").text("");
                            $(".cy-ggfw-area").text("");
                            $(".cy-ggfw-monkey").text("");
                        }
                    }


                },
                error: function (rlt, msg) {
                    console.log("获取失败，原因：" + msg);
                }
            })
        })

    }


// 地图 - 跳转至农改列表


    /*  this.toFarmhouseList = function (point) {
     /!* //    var url = Config.ContextPath + "modules/sjcj/farmhousejbxx/farmhousejbxx.jsp";
          if (vid != null && vid != "" && vid != "undefined") {
              url += "?vid=" + vid;
          } else if (unitcode != null && unitcode != "" && unitcode != "undefined") {
              url += "?unitcode=" + unitcode;
          }
          Events.trigger('open.MenuTab', {
              id: 'taskList_m',
              text: unitname + '农房改善信息',
              url: url,
              closable: true
          }, false);*!/
          alert(1)
      }

    */
    //关闭弹框
    // $(document) 弹框内容的父容器
    $(".cy-dialog").on('click', function (e) {
        // closest('element') 选择的是弹窗内容容器
        if ($(e.target).closest('cy-dialo-content').length <= 0) {
            $(".cy-dialog").hide();
        }
    });


});

