$(function () {

    var picArray = [
        {
            "name": "淮安市金湖县-金南镇-南桥村四组2",
            "id": "p1",
            "imgSrc": "img/house/3.png",
            "num": 4,
            "children": ["img/house/3-1.png", "img/house/3-2.png", "img/house/3-3.png", "img/house/3-4.png"]
        },
        {
            "name": "宿迁市宿豫区-大兴镇-启宇村九组",
            "id": "p2",
            "imgSrc": "img/house/6.png",
            "num": 4,
            "children": ["img/house/6-1.png", "img/house/6-2.png", "img/house/6-3.png", "img/house/6-4.png"]
        },
        {
            "name": "徐州市丰县-常店镇-马楼村前郑庄",
            "id": "p3",
            "imgSrc": "img/house/2.png",
            "num": 4,
            "children": ["img/house/2-1.png", "img/house/2-2.png", "img/house/2-3.png","img/house/2-4.png"]
        },
        {
            "name": "淮安市金湖县-金南镇-福寿村七组",
            "id": "p4",
            "imgSrc": "img/house/4.png",
            "num": 3,
            "children": ["img/house/4-1.png", "img/house/4-2.png", "img/house/4-3.png"]
        },
        {
            "name": "徐州市丰县王沟镇-张庄村-曹庄-丰县王沟镇张庄村-张庄新型社区",
            "id": "p5",
            "imgSrc": "img/house/1.png",
            "num": 1,
            "children": ["img/house/1-1.png", "img/house/1-2.png", "img/house/1-3.png", "img/house/1-4.png"]
        }
    ];

    $.each(picArray, function (index, element) {
        var $target = $(".cy-improve-farmers").find("img:eq(" + index + ")");
        $target.attr("src", element.imgSrc).attr("name", element.name).attr("target", element.id);
    });
    //图片定时器
    var cy_pic_timer;
    if (cy_pic_timer) {
        clearInterval(cy_pic_timer);
    }
    cy_pic_timer = setInterval(function () {
        var deleteString = picArray.splice(0, 1);
        picArray.push(deleteString[0]);
        $.each(picArray, function (index, element) {
            var $target = $(".cy-improve-farmers").find("img:eq(" + index + ")");
            $target.attr("src", element.imgSrc).attr("name", element.name).attr("target", element.id);
        });

    }, 5000);

    //点击其他地方关闭图片轮播
    $(".cy-pic-prop").click(function (e) {
        if (!$(e.target).closest(".swiper-container").length) {
            $(this).hide();
        }
    });
    //图片点击事件
    $(".cy-house-item img").on("click", function () {
        $(".cy-prop-title").text($(this).attr("name"));
        $(".swiper-wrapper").html("");
        $(".cy-pic-prop").show();
        var target = $(this).attr("target");
        var children = [];
        picArray.forEach(function (picItem, picIndex) {
            if (target == picItem.id) {
                children.push(picItem.imgSrc);

                picItem.children.forEach(function (arr) {
                    children.push(arr);
                });
            }
        });
        var str = "";
        children.forEach(function (child, cIndex) {
            str += '<div class="swiper-slide">';
            str += '<img src=' + child + '>';
            str += '</div>';
        });
        $(".swiper-wrapper").append(str);
        //图片轮播
        var swiper = new Swiper('.swiper-container', {
            pagination: {
                el: '.swiper-pagination',
                type: 'fraction',
            },
            navigation: {
                nextEl: '.swiper-button-next',
                prevEl: '.swiper-button-prev',
            },
        });
    });

    //顶部时间
    function getTime() {
        var myDate = new Date();
        var myYear = myDate.getFullYear(); //获取完整的年份(4位,1970-????)
        var myMonth = myDate.getMonth() + 1; //获取当前月份(0-11,0代表1月)
        var myToday = myDate.getDate(); //获取当前日(1-31)
        var myDay = myDate.getDay(); //获取当前星期X(0-6,0代表星期天)
        var myHour = myDate.getHours(); //获取当前小时数(0-23)
        var myMinute = myDate.getMinutes(); //获取当前分钟数(0-59)
        var mySecond = myDate.getSeconds(); //获取当前秒数(0-59)
        var week = ['星期日', '星期一', '星期二', '星期三', '星期四', '星期五', '星期六'];
        var nowTime;
        nowTime = fillZero(myMonth) + '月' + fillZero(myToday) + '日' + '&nbsp;&nbsp;' + fillZero(myHour) + ':' + fillZero(myMinute) + ':' + fillZero(mySecond) + '&nbsp;&nbsp;' + week[myDay] + '&nbsp;&nbsp;';
        //console.log(nowTime);
        $('.cy-header-time span').html(nowTime);
    };

    function fillZero(str) {
        var realNum;
        if (str < 10) {
            realNum = '0' + str;
        } else {
            realNum = str;
        }
        return realNum;
    }

    setInterval(getTime, 1000);

    //实现文字切换
    $(".cy-house-pro li").on("click", function () {
        if ($(this).text() == "农房档案") {
            $(this).parent().parent().removeClass("cy-house-active");
        } else {
            $(this).parent().parent().addClass("cy-house-active");
        }
    });
    //年份选择
    $('#cc').combobox({
        url: 'js/year_json.json',
        valueField: 'id',
        textField: 'text'
    });
    //菜单滚动
    $(".myscroll").myScroll({
        speed: 45, //数值越大，速度越慢
        rowHeight: 105 //li的高度
    });


})
