function loadBlock8(year, city) {
    // 初始化echarts实例
    $.getJSON("js/baseUrl.json", function (rlt) {
        var baseURL = rlt.baseUrl;
        var cy_URL = baseURL + 'service/sjcj/dp/loadData?dataCode=xm';
        if (year != undefined) {
            if (year != "全年") {
                cy_URL += '&dataYear=' + year
            }
        }
        if (city != "" && city != undefined) {
            cy_URL += '&cityCode=' + city
        }
        $.ajax({
            url: cy_URL,    //请求的url地址
            async: true,
            type: "get",
            success: function (data) {
                if (data != null) {
                    var xData = [];
                    var series1 = [];
                    var series2 = [];
                    var newData = {};
                    var newData1 = {};
                    if (data.ncsq != undefined) {
                        newData = JSON.parse(JSON.stringify(data.ncsq, ["徐州", "连云港", "淮安", "盐城", "宿迁"], 5));
                    }
                    $.each(newData, function (index, item) {
                        series1.push(item);    //挨个取出类别并填入类别数组
                        xData.push(index);
                    });
                    if (data.azq != undefined) {
                        newData1 = JSON.parse(JSON.stringify(data.azq, ["徐州", "连云港", "淮安", "盐城", "宿迁"], 5));
                    }
                    $.each(newData1, function (index, item) {
                        series2.push(item);    //挨个取出类别并填入类别数组
                    });
                    let houseChart = echarts.init(document.getElementById('block8'));
                    houseChart.setOption({
                        tooltip: {
                            show: true,
                            trigger: 'axis',
                            backgroundColor: 'rgba(31, 61, 88, 0.92)',
                            borderWidth: '1',
                            borderColor: '#649EBD',
                            padding: [15, 15],
                            textStyle: {
                                color: '#fff',
                                fontSize: 30
                            },
                            formatter: function (params) {
                                var showHtm = params[0].name + '<br>';
                                for (var i = 0; i < params.length; i++) {
                                    var name = params[i].seriesName;
                                    var value = params[i].value;
                                    showHtm += name + ':' + value + '个' + '<br>'
                                }
                                return showHtm;
                            }
                        },
                        legend: {
                            top: '45',
                            textStyle: {  // 图列内容样式
                                color: '#fff',  // 字体颜色
                                fontSize: 30,
                                width: 200
                            },
                            itemWidth: 31,
                            itemHeight: 31,
                            itemGap: 35,
                            data: ['新型农村社区', '小城镇集中安置区'],
                        },
                        grid: {
                            show: true,    // 是否显示直角坐标系网格
                            top: 150,
                            left: 40,
                            right: 40,
                            bottom: 60,
                            borderWidth: '0',
                            containLabel: true, // gird 区域是否包含坐标轴的刻度标签
                        },
                        xAxis: {
                            data: xData,
                            splitLine: {
                                show: false,
                            },
                            axisLabel: {
                                show: true,
                                textStyle: {
                                    fontSize: 30,
                                    color: '#709FD9'
                                },
                                interval: 0
                            },
                            axisLine: {
                                lineStyle: {
                                    color: 'rgba(133, 177, 180, 0.2)',
                                    width: 1
                                }
                            },
                            axisTick: {
                                show: false
                            }
                        },
                        yAxis: {
                            name: '单位:个',
                            nameTextStyle: {
                                fontSize: 30,
                                color: '#709FD9'
                            },
                            nameGap: 35,
                            splitLine: {
                                show: false,
                            },
                            axisLabel: {
                                show: true,
                                textStyle: {
                                    fontSize: 30,
                                    color: '#709FD9'
                                },
                                interval: 0
                            },
                            axisLine: {
                                show: true,
                                lineStyle: {
                                    color: 'rgba(133, 177, 180, 0.2)',
                                    width: 1
                                }
                            },
                            axisTick: {
                                show: false
                            }
                        },
                        series: [{
                            name: '新型农村社区',
                            type: 'bar',
                            barWidth: 30,
                            stack: '数量统计',
                            data: series1,
                            itemStyle: {
                                normal: {
                                    color: new echarts.graphic.LinearGradient(1, 1, 0, 0, [{
                                        offset: 0,
                                        color: '#55CC7C'
                                    },
                                        {
                                            offset: 1,
                                            color: '#F5F97F'
                                        }])
                                }

                            }
                        },
                            {
                                name: '小城镇集中安置区',
                                type: 'bar',
                                barWidth: 30,
                                stack: '数量统计',
                                data: series2,
                                itemStyle: {
                                    normal: {
                                        color: new echarts.graphic.LinearGradient(1, 1, 0, 0, [{
                                            offset: 0,
                                            color: '#F19149'
                                        },
                                            {
                                                offset: 1,
                                                color: '#F7C457'
                                            }])
                                    }

                                },


                            }]

                    });
                }
            },
            error: function (rlt, msg) {
                console.log("获取失败，原因：" + msg);
            }
        });

    });

}
