function loadBlock7(year, city) {
    $.getJSON("js/baseUrl.json", function (rlt) {
        var baseURL = rlt.baseUrl;
        var cy_URL = baseURL + 'service/sjcj/dp/loadData?dataCode=gsxm';
        if (year != undefined && year != "") {
            if (year != "全年") {
                cy_URL += '&dataYear=' + year
            }
        }
        if (city != "" && city != undefined) {
            cy_URL += '&cityCode=' + city
        }
        $.ajax({
            url: cy_URL,    //请求的url地址
            async: true,
            type: "get",
            success: function (data) {
                if (data != null) {
                    var salvProName = [];
                    var salvProValue = [];
                    var objList = data;
                    delete objList.cityCode;
                    delete objList.dataYear;
                    var newObjList= JSON.parse(JSON.stringify( objList, ["开工","主体","封顶","竣工","交付"] , 5));
                    $.each(newObjList, function (name, value) {
                        salvProName.push(name);
                        salvProValue.push(value);
                    });

                    var salvProMax;//背景按最大值
                    for (let i = 0; i < salvProValue.length; i++) {
                        salvProMax = Math.max.apply(null, salvProValue);
                        // console.log("最大值是:" + salvProMax)
                    }
                    loadEcharts(salvProName, salvProValue, salvProMax);
                }
            },
            error: function (rlt, msg) {
                console.log("获取失败，原因：" + msg);
            }
        });


    });

    function loadEcharts(salvProName, salvProValue, salvProMax) {
        // 初始化echarts实例
        let houseChart = echarts.init(document.getElementById('block7'));
        houseChart.setOption({
            grid: {
                left: 35,
                right: 35,
                bottom: 10,
                top: 20,
                containLabel: true
            },
            tooltip: {
                trigger: 'axis',
                axisPointer: {
                    type: 'none'
                },
                backgroundColor: 'rgba(31, 61, 88, 0.92)',
                borderWidth: '1',
                borderColor: '#649EBD',
                padding: [15, 15],
                textStyle: {
                    color: '#fff',
                    fontSize: 25
                },
                formatter: function (params) {
                    return params[0].name + ' : ' + params[0].value + '户'
                }
            },
            xAxis: {
                show: false,
                type: 'value'
            },
            yAxis: [{
                type: 'category',
                inverse: true,
                axisLabel: {
                    show: true,
                    textStyle: {
                        color: '#fff',
                        fontSize: 30
                    },
                },
                splitLine: {
                    show: false
                },
                axisTick: {
                    show: false
                },
                axisLine: {
                    show: false
                },
                data: salvProName
            }, {
                type: 'category',
                inverse: true,
                axisTick: 'none',
                axisLine: 'none',
                show: true,
                axisLabel: {
                    textStyle: {
                        color: '#ffffff',
                        fontSize: '30'
                    },
                },
                data: salvProValue
            }],
            series: [{
                name: '值',
                type: 'bar',
                zlevel: 1,
                itemStyle: {
                    normal: {
                        barBorderRadius: 30,
                        color: new echarts.graphic.LinearGradient(0, 0, 1, 0, [{
                            offset: 0,
                            color: 'rgb(57,89,255,0.9)'
                        }, {
                            offset: 1,
                            color: 'rgb(0,255,253,0.7)'
                        }]),
                    },
                },
                barWidth: 30,
                data: salvProValue
            },
                {
                    name: '背景',
                    type: 'bar',
                    barWidth: 30,
                    barGap: '-100%',
                    data: salvProMax,
                    itemStyle: {
                        normal: {
                            color: 'rgba(24,31,68,0.3)',
                            barBorderRadius: 30,
                        }
                    },
                },
            ]

        });
    }


}
