var lengendData = ['目标数', '完成数', '完成率'];

function loadBlock6(year, city) {
    // 初始化echarts实例
    $.getJSON("js/baseUrl.json", function (rlt) {
        var baseURL = rlt.baseUrl;
        var cy_URL = baseURL + 'service/sjcj/dp/loadData?dataCode=wcs';
        if (year != undefined) {
            if (year != "全年") {
                cy_URL += '&dataYear=' + year
            }
        }
        if (city != "" && city != undefined) {
            cy_URL += '&cityCode=' + city
        }
        $.ajax({
            url: cy_URL,    //请求的url地址
            async: true,
            type: "get",
            success: function (data) {
                if (data != null) {
                    var xData = [];
                    var series1 = [];
                    var series2 = [];
                    var series3 = [];//完成率
                    var newData = {};
                    var newData1 = {};
                    if (data.mbs != undefined) {
                        newData = JSON.parse(JSON.stringify(data.mbs, ["徐州", "连云港", "淮安", "盐城", "宿迁"], 5));
                    }
                    $.each(newData, function (index, item) {
                        series1.push(item);    //挨个取出类别并填入类别数组
                        xData.push(index);
                    });
                    if (data.wcs != undefined) {
                        newData1 = JSON.parse(JSON.stringify(data.wcs, ["徐州", "连云港", "淮安", "盐城", "宿迁"], 5));
                    }
                    $.each(newData1, function (index, item) {
                        series2.push(item);    //挨个取出类别并填入类别数组
                    });
                    for (var i = 0; i < series2.length; i++) {
                        var finishData = (series2[i] / series1[1]).toFixed(2) * 100;
                        series3.push(finishData);
                    }
                    loadEcharts(xData, series1, series2, series3);

                }
            },
            error: function (rlt, msg) {
                console.log("获取失败，原因：" + msg);
            }
        });

    });

    function loadEcharts(xData, series1, series2, series3) {
        let houseChart = echarts.init(document.getElementById('block6'));
        houseChart.setOption({
            legend: {
                top: '30',
                textStyle: {  // 图列内容样式
                    color: '#fff',  // 字体颜色
                    fontSize: 25,
                    width: 200
                },
                itemWidth: 20,
                itemHeight: 20,
                itemGap: 35,
                data: lengendData,
                icon: "circle"
            },
            tooltip: {
                trigger: 'axis',
                axisPointer: {            // 坐标轴指示器，坐标轴触发有效
                    type: 'line'        // 默认为直线，可选为：'line' | 'shadow'
                },
                backgroundColor: 'rgba(31, 61, 88, 0.92)',
                borderWidth: '1',
                borderColor: '#649EBD',
                padding: [15, 15],
                textStyle: {
                    color: '#fff',
                    fontSize: 25
                },
                formatter: function (params) {
                    var showHtm = params[0].name + '<br>';
                    for (var i = 0; i < params.length; i++) {
                        var name = params[i].seriesName;
                        var value = params[i].value;
                        if (params[i].seriesName == "完成率") {
                            showHtm += name + ':' + value + '%' + '<br>'
                        } else {
                            showHtm += name + ':' + value + '个' + '<br>'
                        }


                    }
                    return showHtm;

                }
            },
            grid: {
                top: 130,
                right: 20,
                left: 20,
                bottom: 40,
                containLabel: true
            },
            xAxis: [
                {
                    type: 'category',
                    splitLine: {
                        show: false,
                    },
                    axisLabel: {
                        show: true,
                        textStyle: {
                            fontSize: 25,
                            color: '#fff'
                        },
                        interval: 0
                    },
                    axisLine: {
                        lineStyle: {
                            color: 'rgba(133, 177, 180, 0.2)',
                            width: 1
                        }
                    },
                    axisTick: {
                        show: false
                    },
                    boundaryGap: true,
                    data: xData
                }
            ],
            yAxis: [
                {
                    type: 'value',
                    name: '单位:个',
                    nameTextStyle: {
                        fontSize: 25,
                        color: '#fff'
                    },
                    nameGap: 35,
                    splitLine: {
                        show: false,
                    },
                    scale: false,
                    axisLabel: {
                        show: true,
                        textStyle: {
                            fontSize: 25,
                            color: '#fff'
                        },
                        interval: 0
                    },
                    axisLine: {
                        show: true,
                        lineStyle: {
                            color: 'rgba(133, 177, 180, 0.2)',
                            width: 1,
                            borderWidth: 1,
                        }
                    },
                    boundaryGap: false,
                    axisTick: {
                        show: false
                    }
                },
                {
                    type: 'value',
                    name: '单位:%',
                    nameTextStyle: {
                        fontSize: 25,
                        color: '#fff'
                    },
                    nameGap: 35,
                    splitLine: {
                        show: false,
                    },
                    scale: false,
                    axisLabel: {
                        show: true,
                        textStyle: {
                            fontSize: 25,
                            color: '#fff'
                        },
                        formatter: '{value}%',
                        interval: 0
                    },
                    axisLine: {
                        show: true,
                        lineStyle: {
                            color: 'rgba(133, 177, 180, 0.2)',
                            width: 1,
                            borderWidth: 1,
                        }
                    },
                    boundaryGap: false,
                    axisTick: {
                        show: false
                    }
                }
            ],
            series: [
                {
                    name: '目标数',
                    type: 'line',
                    stack: '总量',
                    symbol: 'emptyCircle',
                    symbolSize: 13,
                    hoverAnimation: 'true',
                    yAxisIndex: 0,
                    label: {
                        show: false,
                        position: "insideBottom",
                        distance: 10,
                        color: '#fff',
                        fontSize: 25
                    },
                    areaStyle: {
                        normal: {
                            //颜色渐变函数 前四个参数分别表示四个位置依次为左、下、右、上
                            color: new echarts.graphic.LinearGradient(0, 0, 0, 1, [{

                                offset: 0,
                                color: 'rgba(255,255,24,0.4)'

                            }, {
                                offset: 1,
                                color: 'rgba(255,255,24,0)'
                            }])

                        }
                    },
                    itemStyle: {
                        color: '#6A5ACD',
                        normal: {
                            lineStyle: {        // 系列级个性化折线样式
                                width: 3,
                                type: 'solid',
                                color: '#ffe118'
                            }
                        }
                    },

                    data: series1
                },
                {
                    name: '完成数',
                    type: 'line',
                    stack: '总量',
                    symbolSize: 13,
                    yAxisIndex: 0,
                    hoverAnimation: 'true',
                    label: {
                        show: false,
                        position: "insideBottom",
                        distance: 10,
                        color: '#fff',
                        fontSize: 25
                    },
                    areaStyle: {
                        normal: {
                            //颜色渐变函数 前四个参数分别表示四个位置依次为左、下、右、上
                            color: new echarts.graphic.LinearGradient(0, 0, 0, 1, [{

                                offset: 0,
                                color: 'rgba(57,255,220,0.4)'
                            }, {
                                offset: 1,
                                color: 'rgba(57,255,220,0)'
                            }])

                        }
                    },
                    itemStyle: {
                        color: '#f02c22',
                        normal: {
                            lineStyle: {        // 系列级个性化折线样式
                                width: 3,
                                type: 'solid',
                                color: '#39ffdc'
                            }
                        }
                    },
                    data: series2
                },
                {
                    name: '完成率',
                    type: 'line',
                    stack: '总量1',
                    symbolSize: 13,
                    yAxisIndex: 1,
                    hoverAnimation: 'true',
                    label: {
                        show: false,
                        position: "insideBottom",
                        distance: 10,
                        color: '#fff',
                        fontSize: 25
                    },
                    itemStyle: {
                        color: '#5c8dff',
                        normal: {
                            lineStyle: {        // 系列级个性化折线样式
                                width: 3,
                                type: 'solid',
                                color: '#5c8dff'
                            }
                        }
                    },
                    data: series3
                }
            ]
        });

    }


}
