function loadBlock4(year, city) {
    // 初始化echarts实例
    $.getJSON("js/baseUrl.json", function (rlt) {
        var baseURL = rlt.baseUrl;
        var cy_URL = baseURL + 'service/sjcj/dp/loadData?dataCode=gzpj';
        if (year != undefined) {
            if (year != "全年") {
                cy_URL += '&dataYear=' + year
            }
        }
        if (city != "" && city != undefined) {
            cy_URL += '&cityCode=' + city
        }
        $.ajax({
            url: cy_URL,    //请求的url地址
            async: true,
            type: "get",
            success: function (data) {
                if (data != null) {
                    var yData = [];
                    var yb_Data = [];
                    var lh_Data = [];
                    var yx_Data = [];
                    var newData = {};
                    var newData1 = {};
                    var newData2 = {};
                    if (data.yb != undefined) {
                        newData = JSON.parse(JSON.stringify(data.yb, ["徐州", "连云港", "淮安", "盐城", "宿迁"], 5));
                    }
                    $.each(newData, function (index, item) {
                        yb_Data.push(item);
                        yData.push(index);
                    });
                    if (data.lh != undefined) {
                        newData1 = JSON.parse(JSON.stringify(data.lh, ["徐州", "连云港", "淮安", "盐城", "宿迁"], 5));
                    }
                    $.each(newData1, function (index, item) {
                        lh_Data.push(item);    //挨个取出类别并填入类别数组

                    });
                    if (data.yx != undefined) {
                        newData2 = JSON.parse(JSON.stringify(data.yx, ["徐州", "连云港", "淮安", "盐城", "宿迁"], 5));
                    }
                    $.each(newData2, function (index, item) {
                        yx_Data.push(item);    //挨个取出类别并填入类别数组

                    });

                    // 初始化echarts实例
                    let houseChart = echarts.init(document.getElementById('block4'));
                    houseChart.setOption({
                        tooltip: {
                            trigger: 'axis',
                            axisPointer: {            // 坐标轴指示器，坐标轴触发有效
                                type: 'shadow'        // 默认为直线，可选为：'line' | 'shadow'
                            },
                            backgroundColor: 'rgba(31, 61, 88, 0.92)',
                            borderWidth: '1',
                            borderColor: '#649EBD',
                            padding: [15, 15],
                            textStyle: {
                                color: '#fff',
                                fontSize: 25
                            }
                        },
                        legend: {
                            top: '20',
                            textStyle: {  // 图列内容样式
                                color: '#fff',  // 字体颜色
                                fontSize: 25,
                                width: 200
                            },
                            itemWidth: 20,
                            itemHeight: 20,
                            itemGap: 35,
                            data: ['优秀', '良好', '一般']
                        },
                        grid: {
                            top: 60,
                            left: 50,
                            right: 60,
                            bottom: 30,
                            containLabel: true
                        },
                        xAxis: {
                            type: 'value',
                            splitLine: {
                                show: false,
                            },
                            axisLabel: {
                                show: true,
                                textStyle: {
                                    fontSize: 25,
                                    color: '#fff'
                                },
                                interval: 0
                            },
                            axisLine: {
                                lineStyle: {
                                    color: 'rgba(133, 177, 180, 0.2)',
                                    width: 6
                                }
                            },
                            axisTick: {
                                show: true
                            }
                        },
                        yAxis: {
                            type: 'category',
                            data: yData,
                            splitLine: {
                                show: false,
                            },
                            axisLabel: {
                                show: true,
                                textStyle: {
                                    fontSize: 25,
                                    color: '#fff'
                                },
                                interval: 0
                            },
                            axisLine: {
                                lineStyle: {
                                    color: 'rgba(133, 177, 180, 0.2)',
                                    width: 1
                                }
                            },
                            axisTick: {
                                show: false
                            }
                        },

                        series: [
                            {
                                name: '优秀',
                                type: 'bar',
                                stack: '总量',
                                label: {
                                    show: true,
                                    position: 'insideRight',
                                    color: '#fff',
                                    fontSize: 20,
                                },
                                itemStyle: {
                                    normal: {
                                        color: new echarts.graphic.LinearGradient(1, 1, 0, 0, [{
                                            offset: 0,
                                            color: '#8FFCA0'
                                        },
                                            {
                                                offset: 1,
                                                color: '#0D7F9C'
                                            }]),
                                        borderWidth: 1,
                                        borderType: 'solid',
                                        borderColor: '#8FFCA0'
                                    }
                                },

                                data: yx_Data
                            },
                            {
                                name: '良好',
                                type: 'bar',
                                stack: '总量',
                                label: {
                                    show: true,
                                    position: 'insideRight',
                                    color: '#fff',
                                    fontSize: 20,
                                },
                                itemStyle: {
                                    normal: {
                                        color: new echarts.graphic.LinearGradient(1, 1, 0, 0, [{
                                            offset: 0,
                                            color: '#E4B90C'
                                        },
                                            {
                                                offset: 1,
                                                color: '#A0670E'
                                            }]),
                                        borderWidth: 1,
                                        borderType: 'solid',
                                        borderColor: '#E4B90C'
                                    },

                                },
                                data: lh_Data
                            },
                            {
                                name: '一般',
                                type: 'bar',
                                stack: '总量',
                                label: {
                                    show: true,
                                    position: 'insideRight',
                                    color: '#fff',
                                    fontSize: 20,
                                },
                                itemStyle: {
                                    normal: {
                                        color: new echarts.graphic.LinearGradient(1, 1, 0, 0, [{
                                            offset: 0,
                                            color: '#00A8FF'
                                        },
                                            {
                                                offset: 1,
                                                color: '#0F3352'
                                            }]),
                                        borderWidth: 1,
                                        borderType: 'solid',
                                        borderColor: '#00A8FF'
                                    },

                                },
                                data: yb_Data

                            }
                        ]

                    });

                }
            },
            error: function (rlt, msg) {
                console.log("获取失败，原因：" + msg);
            }
        });

    });


}
